package com.ubuntuone.android.files.fragment;

import android.graphics.Typeface;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;

import com.ubuntuone.android.files.R;

public class SignInOrUpFragment extends Fragment implements OnClickListener {
	public static final int REQUEST_LOGIN = 1;

	private SignInOrUpFragmentCallback callback;
	
	private Button signInButton;
	private Button signUpButton;
	
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		callback = (SignInOrUpFragmentCallback) getActivity();
	}
	
	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {
		final View content = inflater.inflate(
				R.layout.fragment_sign_in_or_up, container, false);
		
		signInButton = (Button) content.findViewById(R.id.sign_in);
		signUpButton = (Button) content.findViewById(R.id.new_account);
		
		final Typeface ubuntuB = Typeface.createFromAsset(
				getActivity().getAssets(), "Ubuntu-B.ttf");
		
		((TextView) content.findViewById(R.id.u1f)).setTypeface(ubuntuB);
		signInButton.setTypeface(ubuntuB);
		signUpButton.setTypeface(ubuntuB);
		
		signInButton.setOnClickListener(this);
		signUpButton.setOnClickListener(this);
		
		return content;
	}
	
	@Override
	public void onClick(View v) {
		switch (v.getId()) {
		case R.id.sign_in:
			callback.reqestedSignIn();
			break;
		case R.id.new_account:
			callback.requestedSignUp();
		default:
			break;
		}
	}
	
	public interface SignInOrUpFragmentCallback {
		public void reqestedSignIn();
		public void requestedSignUp();
	}
}
