package com.ubuntuone.android.files.fragment;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.ubuntuone.android.files.R;
import com.ubuntuone.android.files.widget.TextViewPlus;

public class TutorialPageFragment extends Fragment {
	private int headerResId;
	private int textResId;
	private int imageResId;
	
	public TutorialPageFragment() {
		super();
	}
		
	public TutorialPageFragment(int headerResId, int textResId, int imageResId) {
		this.headerResId = headerResId;
		this.textResId = textResId;
		this.imageResId = imageResId;
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {
		final View content = inflater.inflate(R.layout.tutorial_page, null);
		final ImageView image = (ImageView)
				content.findViewById(R.id.tutorial_page_image);
		final TextViewPlus header =	(TextViewPlus)
				content.findViewById(R.id.tutorial_page_header);
		final TextViewPlus body = (TextViewPlus)
				content.findViewById(R.id.tutorial_page_body);
		
		image.setImageResource(imageResId);
		header.setText(headerResId);
		body.setText(textResId);
		
		return content;
	}
}
