/*
 * Ubuntu One Files - access Ubuntu One cloud storage on Android platform.
 * 
 * Copyright (C) 2011 Canonical Ltd.
 * Author: Michał Karnicki <michal.karnicki@canonical.com>
 *   
 * This file is part of Ubuntu One Files.
 *  
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses 
 */

package com.ubuntuone.android.files.service;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.ResultReceiver;

import com.ubuntuone.android.files.provider.MetaContract.Nodes;

public final class MetaServiceHelper {
	
	public static void updateUserInfo(Context context, ResultReceiver r) {
		Intent intent = new Intent(MetaService.ACTION_REFRESH_USER);
		intent.putExtra(MetaService.EXTRA_CALLBACK, r);
		context.startService(intent);
	}
	
	public static void createVolume(Context context, ResultReceiver r,
			String resourcePath) {
		Intent intent = new Intent(MetaService.ACTION_CREATE_VOLUME);
		intent.putExtra(MetaService.EXTRA_CALLBACK, r);
		intent.putExtra(Nodes.NODE_RESOURCE_PATH, resourcePath);
		context.startService(intent);
	}
	
	public static void refreshVolume(Context context, ResultReceiver r,
			String resourcePath) {
		Intent intent = new Intent(MetaService.ACTION_REFRESH_VOLUME);
		intent.putExtra(MetaService.EXTRA_CALLBACK, r);
		intent.putExtra(Nodes.NODE_RESOURCE_PATH, resourcePath);
		context.startService(intent);
	}
	
	public static void deleteVolume(Context context, ResultReceiver r,
			String resourcePath) {
		Intent intent = new Intent(MetaService.ACTION_REFRESH_VOLUME);
		intent.putExtra(MetaService.EXTRA_CALLBACK, r);
		intent.putExtra(Nodes.NODE_RESOURCE_PATH, resourcePath);
		context.startService(intent);
	}
	
	public static void createNode(Context context, ResultReceiver r,
			String resourcePath, Bundle extras) {
		Intent intent = new Intent(MetaService.ACTION_CREATE_NODE);
		intent.putExtra(MetaService.EXTRA_CALLBACK, r);
		intent.putExtra(Nodes.NODE_RESOURCE_PATH, resourcePath);
		intent.putExtras(extras);
		context.startService(intent);
	}
	
	public static void prefetchNodeRecurse(Context context, ResultReceiver r,
			String resourcePath) {
		Intent intent = new Intent(MetaService.ACTION_REFRESH_NODE);
		intent.putExtra(MetaService.EXTRA_CALLBACK, r);
		intent.putExtra(MetaService.EXTRA_PREFETCH, r);
		intent.putExtra(Nodes.NODE_RESOURCE_PATH, resourcePath);
		context.startService(intent);
	}
	
	public static void refreshNode(Context context, ResultReceiver r,
			String resourcePath) {
		Intent intent = new Intent(MetaService.ACTION_REFRESH_NODE);
		intent.putExtra(MetaService.EXTRA_CALLBACK, r);
		intent.putExtra(Nodes.NODE_RESOURCE_PATH, resourcePath);
		context.startService(intent);
	}
	
	private static void updateNode(Context context, ResultReceiver r,
			String resourcePath, Bundle extras) {
		Intent intent = new Intent(MetaService.ACTION_UPDATE_NODE);
		intent.putExtra(MetaService.EXTRA_CALLBACK, r);
		intent.putExtra(Nodes.NODE_RESOURCE_PATH, resourcePath);
		intent.putExtras(extras);
		context.startService(intent);
	}
	
	public static void deleteNode(Context context, ResultReceiver r,
			String resourcePath) {
		Intent intent = new Intent(MetaService.ACTION_DELETE_NODE);
		intent.putExtra(MetaService.EXTRA_CALLBACK, r);
		intent.putExtra(Nodes.NODE_RESOURCE_PATH, resourcePath);
		context.startService(intent);
	}
	
	public static void triggerAutoUpload(Context context) {
		Intent intent = new Intent(MetaService.ACTION_UPLOAD_MEDIA);
		context.startService(intent);
	}
	
	public static void triggerRetryFailed(Context context) {
		final Intent intent = new Intent(MetaService.ACTION_RETRY_FAILED);
		context.startService(intent);
	}
	
	public static void createDirectory(Context context, ResultReceiver r,
			String resourcePath, String newDirName) {
		Bundle extras = new Bundle(1);
		extras.putString(MetaService.EXTRA_KIND, Nodes.KIND_DIRECTORY);
		extras.putString(MetaService.EXTRA_NAME, newDirName);
		createNode(context, r, resourcePath, extras);
	}
	
	public static void rename(Context context, ResultReceiver r,
			String resourcePath, String newPath, String newName) {
		Bundle extras = new Bundle(1);
		extras.putString(Nodes.NODE_PATH, newPath);
		extras.putString(Nodes.NODE_NAME, newName);
		updateNode(context, r, resourcePath, extras);
	}
	
	public static void changePublicAccess(Context context, ResultReceiver r,
			String resourcePath, boolean isPublic) {
		Bundle extras = new Bundle(1);
		extras.putBoolean(Nodes.NODE_IS_PUBLIC, isPublic);
		updateNode(context, r, resourcePath, extras);
	}
	
	private MetaServiceHelper() {
	}

}
