/*
 * Ubuntu One Files - access Ubuntu One cloud storage on Android platform.
 * 
 * Copyright (C) 2011 Canonical Ltd.
 * Author: Michał Karnicki <michal.karnicki@canonical.com>
 *   
 * This file is part of Ubuntu One Files.
 *  
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *  
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses 
 */

package com.ubuntuone.android.files.util;

import oauth.signpost.signature.PlainTextMessageSigner;

import com.ubuntu.sso.authorizer.OAuthAuthorizer;
import com.ubuntu.sso.exceptions.TimeDriftException;
import com.ubuntuone.android.files.Constants;
import com.ubuntuone.android.files.Preferences;

public final class Authorizer {
	private static OAuthAuthorizer sAuthorizer;
	
	public static synchronized OAuthAuthorizer getInstance(boolean refresh)
			throws TimeDriftException {
		if (sAuthorizer == null || refresh) {
			sAuthorizer = OAuthAuthorizer.getWithTokens(
					Preferences.getSerializedOAuthToken(),
					new PlainTextMessageSigner());
			new Thread(new Runnable() {
				@Override
				public void run() {
					try {
						OAuthAuthorizer.fixTimeDrift(null, Constants.U1_HTP_URL);
					} catch (TimeDriftException e) {
						// Nothing much we can do. User will be thrown back to login screen.
						// Will track this event with analytics in separate commit/branch soon.
						e.printStackTrace();
					}
				}
			}).start();
		}
		return sAuthorizer;
	}
}
