package com.ubuntuone.android.files.util;

import org.apache.http.HttpVersion;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class HttpManager {
	private static final ClientConnectionManager sManager;
	private static final DefaultHttpClient sClient;	
		
	static {
		final HttpParams params = new BasicHttpParams();
		HttpProtocolParams.setVersion(params, HttpVersion.HTTP_1_1);
		HttpProtocolParams.setContentCharset(params, "UTF-8");

		HttpConnectionParams.setStaleCheckingEnabled(params, false);
		HttpConnectionParams.setConnectionTimeout(params, 20 * 1000);
		HttpConnectionParams.setSoTimeout(params, 20 * 1000);
		HttpConnectionParams.setSocketBufferSize(params, 8192);

		HttpClientParams.setRedirecting(params, false);

		SchemeRegistry schemeRegistry = new SchemeRegistry();
		schemeRegistry.register(
				new Scheme("https", SSLSocketFactory.getSocketFactory(), 443));
		// Register http scheme to allow HEAD http://one.ubuntu.com/api/time
		schemeRegistry.register(
				new Scheme("http", PlainSocketFactory.getSocketFactory(), 80));

		sManager = new ThreadSafeClientConnManager(params, schemeRegistry);
		sClient = new DefaultHttpClient(sManager, params);
		// HttpRequestInterceptor, for debugging requests only.
		/*
		sClient.addRequestInterceptor(new HttpRequestInterceptor() {
			
			@Override
			public void process(HttpRequest request, HttpContext context)
					throws HttpException, IOException {
				Log.d("http", request.getRequestLine().toString());
			}
		});
		*/
		
		// XXX staging server certificate workaround only.
		// workaroundStagingCertificate();
	}
	
	public static DefaultHttpClient getClient() {
		return sClient;
	}
	
	public static void shutdown() {
		sManager.shutdown();
	}
	
	@SuppressWarnings("unused")
	private void workaroundStagingCertificate() {
		SSLSocketFactory sslSocketFactory = (SSLSocketFactory) sClient
				.getConnectionManager().getSchemeRegistry().getScheme("https")
				.getSocketFactory();
		sslSocketFactory.setHostnameVerifier(new AllowAllHostnameVerifier());
	}

	private HttpManager() {
	}
}
