package com.ubuntuone.android.files.util;

import greendroid.widget.QuickAction;
import android.content.Context;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LightingColorFilter;
import android.graphics.drawable.Drawable;
import android.text.ClipboardManager;
import android.widget.Toast;

public final class UIUtil {
	
	private UIUtil() {
	}
	
	public static void showToast(Context context, String text, boolean isLong) {
		Toast.makeText(context, text,
				isLong ? Toast.LENGTH_LONG : Toast.LENGTH_SHORT).show();
	}
	
	public static void showToast(Context context, int resId, boolean isLong) {
		Toast.makeText(context, resId,
				isLong ? Toast.LENGTH_LONG : Toast.LENGTH_SHORT).show();
	}
	
	public static void showToast(Context context, String text) {
		showToast(context, text, false);
	}
	
	public static void showToast(Context context, int resId) {
		showToast(context, resId, false);
	}
	
	private static ClipboardManager clipboardManager;
	
	public static void save2Clipboard(Context context, String text) {
		if (clipboardManager == null)
			clipboardManager = (ClipboardManager) context
					.getSystemService(Context.CLIPBOARD_SERVICE);
		clipboardManager.setText(text);
	}
	
	public static class BlackQuickAction extends QuickAction {
		
		private static final ColorFilter BLACK_CF =
				new LightingColorFilter(Color.BLACK, Color.BLACK);

		public BlackQuickAction(Context ctx, int drawableId, int titleId) {
			super(ctx, buildDrawable(ctx, drawableId), titleId);
		}
		
		private static Drawable buildDrawable(Context ctx, int drawableId) {
			Drawable d = ctx.getResources().getDrawable(drawableId);
			d.setColorFilter(BLACK_CF);
			return d;
		}
		
	}

}
