/*
 * Decompiled with CFR 0.152.
 */
package com.ubuntuone.api.sso;

import com.ubuntuone.api.sso.authorizer.Authorizer;
import com.ubuntuone.api.sso.authorizer.AuthorizerException;
import com.ubuntuone.api.sso.authorizer.BasicAuthorizer;
import com.ubuntuone.api.sso.authorizer.OAuthAuthorizer;
import com.ubuntuone.api.sso.exceptions.AccountException;
import com.ubuntuone.api.sso.exceptions.AuthenticationException;
import com.ubuntuone.api.sso.exceptions.EmailTokenException;
import com.ubuntuone.api.sso.exceptions.NewCaptchaException;
import com.ubuntuone.api.sso.exceptions.NewPasswordException;
import com.ubuntuone.api.sso.exceptions.RegistrationException;
import com.ubuntuone.api.sso.exceptions.U1PingException;
import com.ubuntuone.api.sso.model.AccountResponse;
import com.ubuntuone.api.sso.model.AuthenticateResponse;
import com.ubuntuone.api.sso.model.CaptchaResponse;
import com.ubuntuone.api.sso.model.ServerResponse;
import com.ubuntuone.api.sso.model.ValidateEmailResponse;
import com.ubuntuone.api.sso.util.HttpUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

public class U1AuthAPI {
    private static final Logger LOGGER = Logger.getLogger(U1AuthAPI.class.getName());
    private static final String SCHEME = "https";
    private static final String HOST = "login.ubuntu.com";
    private static final String URLENCODED = "application/x-www-form-urlencoded";
    private static final String JSON = "application/json";
    private static final String API_ROOT = "/api/1.0";
    private static final String ACCOUNTS_PATH = "/api/1.0/accounts";
    private static final String AUTHENTICATIONS_PATH = "/api/1.0/authentications";
    private static final String CAPTCHAS_PATH = "/api/1.0/captchas";
    private static final String REGISTRATION_PATH = "/api/1.0/registration";
    public static final String U1_PING_HOST = "one.ubuntu.com";
    public static final String U1_STAGING_PING_HOST = "staging.one.ubuntu.com";
    private static final String U1_PING_PATH = "/oauth/sso-finished-so-get-tokens/";
    public static final String MOBILE = "mobile";
    public static final String DESKTOP = "desktop";
    public static final String RETURN_TO_SCHEME = "x-ubuntu-sso";
    private final String scheme;
    private final String host;
    private final String u1Host;
    private final String userAgent;
    private final HttpClient httpClient;
    private Authorizer authorizer;

    public U1AuthAPI(String appPackageName, String appVersion, HttpClient httpClient, Authorizer authorizer) {
        this(appPackageName, appVersion, SCHEME, HOST, httpClient, authorizer);
    }

    public U1AuthAPI(String appPackageName, String appVersion, String scheme, String host, HttpClient httpClient, Authorizer authorizer) {
        this.userAgent = this.getUserAgent(appPackageName, appVersion);
        if (scheme == null) {
            throw new IllegalStateException("Scheme cannot be null.");
        }
        if (!scheme.equals(SCHEME)) {
            LOGGER.severe("Ubuntu SSO initialized with non secure scheme: " + scheme);
        }
        this.scheme = scheme;
        if (host == null) {
            throw new IllegalStateException("Host cannot be null.");
        }
        this.host = host;
        String string = this.u1Host = host.contains("staging") ? U1_STAGING_PING_HOST : U1_PING_HOST;
        if (httpClient == null) {
            throw new IllegalStateException("HttpClient cannot be null.");
        }
        this.httpClient = httpClient;
        this.authorizer = authorizer;
    }

    public void setAuthorizer(Authorizer authorizer) {
        if (authorizer == null) {
            throw new IllegalStateException("Authorizer cannot be null.");
        }
        this.authorizer = authorizer;
    }

    public CaptchaResponse newCaptcha() throws NewCaptchaException, IOException {
        ArrayList<BasicNameValuePair> data = new ArrayList<BasicNameValuePair>();
        data.add(new BasicNameValuePair("ws.op", "new"));
        try {
            JSONObject json = this.post(CAPTCHAS_PATH, data, null);
            return json != null ? new CaptchaResponse(json) : null;
        }
        catch (JSONException e) {
            throw new NewCaptchaException(e);
        }
        catch (ClientProtocolException e) {
            throw new NewCaptchaException(e);
        }
        catch (AuthorizerException e) {
            throw new NewCaptchaException(e);
        }
    }

    public ServerResponse register(String email, String password, String captchaId, String captchaSolution, String displayName, String platform, String returnUri) throws RegistrationException, IOException {
        ArrayList<BasicNameValuePair> data = new ArrayList<BasicNameValuePair>();
        data.add(new BasicNameValuePair("ws.op", "register"));
        if (displayName != null) {
            data.add(new BasicNameValuePair("displayname", displayName));
        }
        data.add(new BasicNameValuePair("email", email));
        data.add(new BasicNameValuePair("password", password));
        data.add(new BasicNameValuePair("captcha_id", captchaId));
        data.add(new BasicNameValuePair("captcha_solution", captchaSolution));
        if (platform != null) {
            data.add(new BasicNameValuePair("platform", platform));
        }
        if (returnUri != null) {
            data.add(new BasicNameValuePair("validate_redirect_to", returnUri));
        }
        try {
            JSONObject json = this.post(REGISTRATION_PATH, data, null);
            return json != null ? new ServerResponse(json) : null;
        }
        catch (JSONException e) {
            throw new RegistrationException(e);
        }
        catch (ClientProtocolException e) {
            throw new RegistrationException(e);
        }
        catch (AuthorizerException e) {
            throw new RegistrationException(e);
        }
    }

    public ServerResponse requestPasswordResetToken(String email) throws NewPasswordException, IOException {
        ArrayList<BasicNameValuePair> data = new ArrayList<BasicNameValuePair>();
        data.add(new BasicNameValuePair("ws.op", "request_password_reset_token"));
        try {
            JSONObject json = this.post(REGISTRATION_PATH, data, null);
            return new ServerResponse(json);
        }
        catch (JSONException e) {
            throw new NewPasswordException(e);
        }
        catch (ClientProtocolException e) {
            throw new NewPasswordException(e);
        }
        catch (AuthorizerException e) {
            throw new NewPasswordException(e);
        }
    }

    public ServerResponse setNewPassword(String email, String newPassword, String token) throws NewPasswordException, IOException {
        ArrayList<BasicNameValuePair> data = new ArrayList<BasicNameValuePair>();
        data.add(new BasicNameValuePair("ws.op", "set_new_password"));
        data.add(new BasicNameValuePair("email", email));
        data.add(new BasicNameValuePair("newPassword", newPassword));
        data.add(new BasicNameValuePair("token", token));
        try {
            JSONObject json = this.post(REGISTRATION_PATH, data, null);
            return new ServerResponse(json);
        }
        catch (JSONException e) {
            throw new NewPasswordException(e);
        }
        catch (ClientProtocolException e) {
            throw new NewPasswordException(e);
        }
        catch (AuthorizerException e) {
            throw new NewPasswordException(e);
        }
    }

    public AuthenticateResponse authenticate(String tokenName) throws AuthenticationException, IOException {
        ArrayList<BasicNameValuePair> data = new ArrayList<BasicNameValuePair>();
        data.add(new BasicNameValuePair("ws.op", "authenticate"));
        data.add(new BasicNameValuePair("token_name", tokenName));
        if (this.authorizer == null) {
            throw new IllegalStateException("Authorizer cannot be null.");
        }
        if (!(this.authorizer instanceof BasicAuthorizer)) {
            throw new RuntimeException("Not a BasicAuthorizer!");
        }
        try {
            JSONObject json = this.get(AUTHENTICATIONS_PATH, data, this.authorizer);
            return json != null ? new AuthenticateResponse(json) : null;
        }
        catch (JSONException e) {
            throw new AuthenticationException(e);
        }
        catch (ClientProtocolException e) {
            throw new AuthenticationException(e);
        }
        catch (AuthorizerException e) {
            throw new AuthenticationException(e);
        }
    }

    public AccountResponse me() throws AccountException, IOException {
        ArrayList<BasicNameValuePair> data = new ArrayList<BasicNameValuePair>();
        data.add(new BasicNameValuePair("ws.op", "me"));
        if (this.authorizer == null) {
            throw new IllegalStateException("Authorizer cannot be null.");
        }
        if (!(this.authorizer instanceof OAuthAuthorizer)) {
            throw new RuntimeException("Not an OAuthAuthorizer!");
        }
        try {
            JSONObject json = this.get(ACCOUNTS_PATH, data, this.authorizer);
            return new AccountResponse(json);
        }
        catch (JSONException e) {
            throw new AccountException(e);
        }
        catch (ClientProtocolException e) {
            throw new AccountException(e);
        }
        catch (AuthorizerException e) {
            throw new AccountException(e);
        }
    }

    public ValidateEmailResponse validateEmail(String emailToken) throws EmailTokenException, IOException {
        ArrayList<BasicNameValuePair> data = new ArrayList<BasicNameValuePair>();
        data.add(new BasicNameValuePair("ws.op", "validate_email"));
        data.add(new BasicNameValuePair("email_token", emailToken));
        if (this.authorizer == null) {
            throw new IllegalStateException("Authorizer cannot be null.");
        }
        if (!(this.authorizer instanceof OAuthAuthorizer)) {
            throw new RuntimeException("Not an OAuthAuthorizer!");
        }
        try {
            JSONObject json = this.get(ACCOUNTS_PATH, data, this.authorizer);
            return new ValidateEmailResponse(json);
        }
        catch (JSONException e) {
            throw new EmailTokenException(e);
        }
        catch (ClientProtocolException e) {
            throw new EmailTokenException(e);
        }
        catch (AuthorizerException e) {
            throw new EmailTokenException(e);
        }
    }

    public void pingUbuntuOne(String email) throws U1PingException {
        block8: {
            long prevTimeDrift = OAuthAuthorizer.getTimeDriftMillis();
            try {
                String path = U1_PING_PATH + email;
                URI uri = new URI(this.scheme, this.u1Host, path, null, null);
                HttpGet get = new HttpGet(uri);
                get.addHeader("User-Agent", this.userAgent);
                if (this.authorizer == null) {
                    throw new IllegalStateException("Authorizer cannot be null.");
                }
                if (!(this.authorizer instanceof OAuthAuthorizer)) {
                    throw new RuntimeException("Not an OAuthAuthorizer!");
                }
                this.authorizer.signRequest((HttpUriRequest)get);
                LOGGER.info("Pinging " + uri.toString());
                HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    LOGGER.info("Ping OK: " + response.getStatusLine());
                    break block8;
                }
                LOGGER.severe("Ping failed: " + response.getStatusLine());
                HttpUtil.dumpHeaders(response.getAllHeaders(), LOGGER, Level.SEVERE);
                throw new Exception("Service unavailable.");
            }
            catch (Exception e) {
                throw new U1PingException(e.getMessage());
            }
            finally {
                OAuthAuthorizer.setTimeDriftMillis(prevTimeDrift);
            }
        }
    }

    public JSONObject get(String path, List<? extends NameValuePair> args, Authorizer auth) throws ClientProtocolException, IOException, AuthorizerException {
        HttpUtil.QueryStringBuilder qb = new HttpUtil.QueryStringBuilder(args);
        try {
            URI uri = new URI(this.scheme, this.host, path, qb.getQuery(), null);
            HttpGet get = new HttpGet(uri);
            get.addHeader("User-Agent", this.userAgent);
            get.addHeader("Accept", JSON);
            get.addHeader("Content-Type", URLENCODED);
            if (auth != null) {
                auth.signRequest((HttpUriRequest)get);
            }
            HttpUtil.JSONResponseHandler responseHandler = new HttpUtil.JSONResponseHandler();
            return (JSONObject)this.httpClient.execute((HttpUriRequest)get, (ResponseHandler)responseHandler);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject post(String path, List<? extends NameValuePair> data, Authorizer auth) throws ClientProtocolException, IOException, AuthorizerException {
        try {
            URI uri = new URI(this.scheme, this.host, path, null, null);
            HttpPost post = new HttpPost(uri);
            post.addHeader("User-Agent", this.userAgent);
            post.addHeader("Accept", JSON);
            post.addHeader("Content-Type", URLENCODED);
            UrlEncodedFormEntity body = new UrlEncodedFormEntity(data);
            post.setEntity((HttpEntity)body);
            if (auth != null) {
                auth.signRequest((HttpUriRequest)post);
            }
            HttpUtil.JSONResponseHandler responseHandler = new HttpUtil.JSONResponseHandler();
            return (JSONObject)this.httpClient.execute((HttpUriRequest)post, (ResponseHandler)responseHandler);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getUserAgent(String appPackageName, String appVersion) {
        if (appPackageName == null || appPackageName.length() == 0) {
            LOGGER.warning("It is encouraged to provide proper application package name.");
            appPackageName = "com.ubuntuone.api.sso-unkown";
        }
        if (appVersion == null || appVersion.length() == 0) {
            LOGGER.warning("It is encouraged to provide proper application version.");
            appVersion = "unknown";
        }
        return String.format("%s/%s", appPackageName, appVersion);
    }
}

