/*
 * Decompiled with CFR 0.152.
 */
package com.ubuntuone.api.sso.authorizer;

import com.ubuntuone.api.sso.authorizer.Authorizer;
import com.ubuntuone.api.sso.authorizer.AuthorizerException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.auth.params.AuthParams;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BufferedHeader;
import org.apache.http.params.HttpParams;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EncodingUtils;

public class BasicAuthorizer
implements Authorizer {
    private final String username;
    private final String password;

    public BasicAuthorizer(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public void signRequest(HttpUriRequest request) throws AuthorizerException {
        String charset = AuthParams.getCredentialCharset((HttpParams)request.getParams());
        request.addHeader(this.getAuthorizationHeader(charset));
    }

    private Header getAuthorizationHeader(String charset) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(this.username);
        tmp.append(":");
        tmp.append(this.password == null ? "null" : this.password);
        byte[] base64password = Base64.encodeBase64((byte[])EncodingUtils.getBytes((String)tmp.toString(), (String)charset));
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        buffer.append("Authorization");
        buffer.append(": Basic ");
        buffer.append(base64password, 0, base64password.length);
        return new BufferedHeader(buffer);
    }
}

