/*
 * Decompiled with CFR 0.152.
 */
package com.ubuntuone.api.sso.authorizer;

import com.ubuntuone.api.sso.U1AuthAPI;
import com.ubuntuone.api.sso.authorizer.Authorizer;
import com.ubuntuone.api.sso.authorizer.AuthorizerException;
import com.ubuntuone.api.sso.exceptions.TimeDriftException;
import com.ubuntuone.api.sso.model.AuthenticateResponse;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import oauth.signpost.http.HttpParameters;
import oauth.signpost.signature.OAuthMessageSigner;
import oauth.signpost.signature.PlainTextMessageSigner;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;

public class OAuthAuthorizer
extends CommonsHttpOAuthConsumer
implements Authorizer {
    private static final long serialVersionUID = -6724740559338096755L;
    private static final Logger LOGGER = Logger.getLogger(U1AuthAPI.class.getName());
    private static final String TIME_SERVER_SSO = "https://login.ubuntu.com";
    private static final String TIME_SERVER_U1 = "http://one.ubuntu.com/api/time";
    private static final String DATE_FMT = "E, dd MMM yyyy HH:mm:ss z";
    private static final long OAUTH_DRIFT_MILLIS = 300000L;
    private static long timeDriftMillis = 0L;

    public OAuthAuthorizer(String consumerKey, String consumerSecret, String tokenKey, String tokenSecret, OAuthMessageSigner signer) {
        super(consumerKey, consumerSecret);
        this.setMessageSigner(signer);
        this.setTokenWithSecret(tokenKey, tokenSecret);
        HttpParameters params = new HttpParameters();
        params.put("realm", "");
        this.setAdditionalParameters(params);
    }

    public OAuthAuthorizer(String consumerKey, String consumerSecret, String tokenKey, String tokenSecret) {
        this(consumerKey, consumerSecret, tokenKey, tokenSecret, (OAuthMessageSigner)new PlainTextMessageSigner());
    }

    public OAuthAuthorizer(AuthenticateResponse auth, OAuthMessageSigner signer) {
        this(auth.getConsumerKey(), auth.getConsumerSecret(), auth.getToken(), auth.getTokenSecret(), signer);
    }

    public OAuthAuthorizer(AuthenticateResponse auth) {
        this(auth, (OAuthMessageSigner)new PlainTextMessageSigner());
    }

    public static OAuthAuthorizer getWithTokens(String tokens, OAuthMessageSigner signer) {
        StringTokenizer tokenizer = new StringTokenizer(tokens, ":");
        String consumerKey = tokenizer.nextToken();
        String consumerSecret = tokenizer.nextToken();
        String tokenKey = tokenizer.nextToken();
        String tokenSecret = tokenizer.nextToken();
        return new OAuthAuthorizer(consumerKey, consumerSecret, tokenKey, tokenSecret, signer);
    }

    @Override
    public void signRequest(HttpUriRequest request) throws AuthorizerException {
        try {
            this.sign(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AuthorizerException(e);
        }
    }

    public static void syncTimeWithU1(HttpClient httpClient) throws TimeDriftException {
        OAuthAuthorizer.syncTimeWithServer(httpClient, TIME_SERVER_U1, DATE_FMT);
    }

    public static void syncTimeWithSSO(HttpClient httpClient) throws TimeDriftException {
        OAuthAuthorizer.syncTimeWithServer(httpClient, TIME_SERVER_SSO, DATE_FMT);
    }

    private static synchronized void syncTimeWithServer(HttpClient client, String uri, String format) throws TimeDriftException {
        HttpHead request = new HttpHead(uri);
        request.addHeader("Cache-Control", "no-cache");
        try {
            HttpResponse response = client.execute((HttpUriRequest)request);
            Header dateHeader = response.getFirstHeader("Date");
            assert (dateHeader != null);
            LOGGER.info("Server time is " + dateHeader.getValue());
            SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.ENGLISH);
            Date serverDate = formatter.parse(dateHeader.getValue());
            long serverTimeMillis = serverDate.getTime();
            long deviceTimeMillis = System.currentTimeMillis();
            timeDriftMillis = Math.abs(serverTimeMillis - deviceTimeMillis);
            if (timeDriftMillis > 300000L) {
                LOGGER.warning("Device time drifted: " + formatter.format(new Date(deviceTimeMillis)));
            } else {
                LOGGER.info("Insignificant device time drift: " + timeDriftMillis);
            }
        }
        catch (Exception e) {
            String msg = "Could not sync time: " + e.getMessage();
            LOGGER.warning(msg);
            throw new TimeDriftException(msg);
        }
    }

    public static long getTimeDriftMillis() {
        return timeDriftMillis;
    }

    public static void setTimeDriftMillis(long millis) {
        timeDriftMillis = millis;
    }

    protected String generateTimestamp() {
        return Long.toString((System.currentTimeMillis() + timeDriftMillis) / 1000L);
    }
}

