/*
 * Decompiled with CFR 0.152.
 */
package com.ubuntuone.api.sso.model;

import com.ubuntuone.api.sso.model.ServerResponse;
import com.ubuntuone.api.sso.util.JsonUtil;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class AccountResponse
extends ServerResponse {
    protected static final String JSON_DISPLAYNAME_KEY = "displayname";
    protected static final String JSON_OPENID_IDENTIFIER_KEY = "openid_identifier";
    protected static final String JSON_PREFERRED_EMAIL_KEY = "preferred_email";
    protected static final String JSON_VERIFIED_EMAILS = "verified_emails";
    protected static final String JSON_UNVERIFIED_EMAILS = "unverified_emails";
    private final String displayname;
    private final String openidIdentifier;
    private final String preferredEmail;
    private final ArrayList<String> verifiedEmails;
    private final ArrayList<String> unverifiedEmails;

    public AccountResponse(JSONObject json) throws JSONException {
        super(json);
        this.displayname = json.getString(JSON_DISPLAYNAME_KEY);
        this.openidIdentifier = json.getString(JSON_OPENID_IDENTIFIER_KEY);
        this.preferredEmail = json.getString(JSON_PREFERRED_EMAIL_KEY);
        this.verifiedEmails = JsonUtil.jsonArrayToArrayList(json.getJSONArray(JSON_VERIFIED_EMAILS));
        this.unverifiedEmails = JsonUtil.jsonArrayToArrayList(json.getJSONArray(JSON_UNVERIFIED_EMAILS));
    }

    public String getDisplayname() {
        return this.displayname;
    }

    public String getOpenidIdentifier() {
        return this.openidIdentifier;
    }

    public String getPreferredEmail() {
        return this.preferredEmail;
    }

    public ArrayList<String> getVerifiedEmails() {
        return this.verifiedEmails;
    }

    public ArrayList<String> getUnverifiedEmails() {
        return this.unverifiedEmails;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AccountResponse [displayname=");
        builder.append(this.displayname);
        builder.append(", openidIdentifier=");
        builder.append(this.openidIdentifier);
        builder.append(", preferredEmail=");
        builder.append(this.preferredEmail);
        builder.append(", unverifiedEmails=");
        builder.append(this.unverifiedEmails);
        builder.append(", verifiedEmails=");
        builder.append(this.verifiedEmails);
        builder.append(", status=");
        builder.append(this.status);
        builder.append(", message=");
        builder.append(this.message);
        builder.append(", errors=");
        builder.append(this.errors);
        builder.append("]");
        return builder.toString();
    }
}

