/*
 * Decompiled with CFR 0.152.
 */
package com.ubuntuone.api.sso.model;

import com.ubuntuone.api.sso.model.ServerResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthenticateResponse
extends ServerResponse {
    private static final String UTF8 = "UTF-8";
    protected static final String JSON_NAME_KEY = "name";
    protected static final String JSON_CONSUMER_KEY_KEY = "consumer_key";
    protected static final String JSON_CONSUMER_SECRET_KEY = "consumer_secret";
    protected static final String JSON_TOKEN_KEY = "token";
    protected static final String JSON_TOKEN_SECRET_KEY = "token_secret";
    private final String name;
    private final String consumerKey;
    private final String consumerSecret;
    private final String token;
    private final String tokenSecret;
    private String serialized;

    public AuthenticateResponse(JSONObject json) throws JSONException {
        super(json);
        this.name = json.getString(JSON_NAME_KEY);
        this.consumerKey = json.getString(JSON_CONSUMER_KEY_KEY);
        this.consumerSecret = json.getString(JSON_CONSUMER_SECRET_KEY);
        this.token = json.getString(JSON_TOKEN_KEY);
        this.tokenSecret = json.getString(JSON_TOKEN_SECRET_KEY);
    }

    public String getName() {
        try {
            return URLDecoder.decode(this.name, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public String getSerialized() {
        if (this.serialized != null) {
            return this.serialized;
        }
        StringBuilder result = new StringBuilder(30);
        result.append(this.getConsumerKey());
        result.append(":");
        result.append(this.getConsumerSecret());
        result.append(":");
        result.append(this.getToken());
        result.append(":");
        result.append(this.getTokenSecret());
        this.serialized = result.toString();
        return this.serialized;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AuthenticateResponse [name=");
        builder.append(this.getName());
        builder.append(", consumerKey=");
        builder.append(this.consumerKey);
        builder.append(", token=");
        builder.append(this.token);
        builder.append(", status=");
        builder.append(this.status);
        builder.append(", message=");
        builder.append(this.message);
        builder.append(", errors=");
        builder.append(this.errors);
        builder.append("]");
        return builder.toString();
    }
}

