/*
 * Decompiled with CFR 0.152.
 */
package com.ubuntuone.api.sso.model;

import com.ubuntuone.api.sso.util.JsonUtil;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ServerResponse {
    protected static final String JSON_STATUS_KEY = "status";
    protected static final String JSON_MESSAGE_KEY = "message";
    protected static final String JSON_ERRORS_KEY = "errors";
    public final String status;
    public final String message;
    public final ArrayList<Error> errors;

    public ServerResponse(JSONObject json) throws JSONException {
        this.status = json.has(JSON_STATUS_KEY) ? json.getString(JSON_STATUS_KEY) : null;
        String string = this.message = json.has(JSON_MESSAGE_KEY) ? json.getString(JSON_MESSAGE_KEY) : null;
        if (json.has(JSON_ERRORS_KEY)) {
            JSONArray errorsJson = json.optJSONArray(JSON_ERRORS_KEY);
            if (errorsJson != null) {
                int len = errorsJson.length();
                this.errors = new ArrayList(len);
                for (int i = 0; i < len; ++i) {
                    this.errors.add(new Error(errorsJson.getJSONArray(i)));
                }
            } else {
                JSONObject errorsJsonObj = json.optJSONObject(JSON_ERRORS_KEY);
                if (errorsJsonObj != null) {
                    this.errors = new ArrayList();
                    Iterator a = errorsJsonObj.keys();
                    while (a.hasNext()) {
                        String key = (String)a.next();
                        this.errors.add(new Error(key, errorsJsonObj.getJSONArray(key)));
                    }
                } else {
                    this.errors = null;
                }
            }
        } else {
            this.errors = null;
        }
    }

    public String getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean hasErrors() {
        return this.errors != null;
    }

    public ArrayList<Error> getErrors() {
        return this.errors;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ServerResponse [status=");
        builder.append(this.status);
        builder.append(", message=");
        builder.append(this.message);
        builder.append(", errors=");
        builder.append(this.errors);
        builder.append("]");
        return builder.toString();
    }

    public static class Error {
        private final String reason;
        private final ArrayList<String> details;

        public Error(String reason, JSONArray details) throws JSONException {
            this.reason = reason;
            this.details = JsonUtil.jsonArrayToArrayList(details);
        }

        public Error(JSONArray json) throws JSONException {
            if (json.length() == 2) {
                this.reason = json.getString(0);
                this.details = JsonUtil.jsonArrayToArrayList(json.getJSONArray(1));
            } else {
                this.reason = "unknown";
                this.details = null;
            }
        }

        public String getReason() {
            return this.reason;
        }

        public ArrayList<String> getDetails() {
            return this.details;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Error [reason=");
            builder.append(this.reason);
            builder.append(", details=");
            builder.append(this.details);
            builder.append("]");
            return builder.toString();
        }
    }
}

