/*
 * Decompiled with CFR 0.152.
 */
package com.ubuntuone.api.sso.util;

import com.ubuntuone.api.sso.util.JsonUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.json.JSONException;
import org.json.JSONObject;

public final class HttpUtil {
    private HttpUtil() {
    }

    public static void dumpRequest(HttpGet get) {
        System.err.println(get.getRequestLine());
        HeaderIterator it = get.headerIterator();
        while (it.hasNext()) {
            System.err.println(it.nextHeader().toString());
        }
    }

    public static void dumpRequest(HttpPost post) {
        System.err.println(post.getRequestLine());
        HeaderIterator it = post.headerIterator();
        while (it.hasNext()) {
            System.err.println(it.nextHeader().toString());
        }
        System.err.println("BODY:");
        HttpEntity entity = post.getEntity();
        HttpUtil.dumpHttpEntity(entity);
    }

    public static void dumpHeaders(Header[] headers, Logger logger, Level level) {
        if (logger.isLoggable(level) && headers != null) {
            logger.log(level, "Dumping headers:");
            for (Header header : headers) {
                if (header.getName().equals("Authorization")) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(level, header.toString());
                        continue;
                    }
                    logger.log(level, String.format("%s: ***", header.getName()));
                    continue;
                }
                logger.log(level, header.toString());
            }
        }
    }

    public static void dumpHttpEntity(HttpEntity entity) {
        if (entity == null) {
            System.err.println("Entity is null.");
            return;
        }
        try {
            InputStream in = entity.getContent();
            BufferedInputStream bin = new BufferedInputStream(in);
            byte[] buffer = new byte[1024];
            while (bin.read(buffer) > 0) {
                System.err.println(new String(buffer));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class QueryStringBuilder {
        private StringBuilder params;

        public QueryStringBuilder(List<? extends NameValuePair> params) {
            for (NameValuePair nameValuePair : params) {
                this.add(nameValuePair);
            }
        }

        public void add(String name, String value) {
            if (this.params == null) {
                this.params = new StringBuilder();
            } else {
                this.params.append("&");
            }
            this.params.append(name);
            this.params.append("=");
            this.params.append(value);
        }

        public void add(NameValuePair pair) {
            this.add(pair.getName(), pair.getValue());
        }

        public String getQuery() {
            return this.params.toString();
        }
    }

    public static class JSONResponseHandler
    implements ResponseHandler<JSONObject> {
        public JSONObject handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            if (statusCode >= 300) {
                System.err.println(response.getStatusLine());
                HttpUtil.dumpHttpEntity(entity);
                throw new HttpResponseException(statusCode, response.getStatusLine().getReasonPhrase());
            }
            try {
                JSONObject json = JsonUtil.entity2JSONObject(entity);
                return json;
            }
            catch (JSONException e) {
                throw new HttpResponseException(422, "malformed response: " + e.getMessage());
            }
        }
    }
}

