/*
 * Decompiled with CFR 0.152.
 */
package com.ubuntuone.api.files;

import com.ubuntuone.api.files.client.ContentClient;
import com.ubuntuone.api.files.client.ResourceClient;
import com.ubuntuone.api.files.json.U1CustomNodeJson;
import com.ubuntuone.api.files.json.U1DeltaJson;
import com.ubuntuone.api.files.json.U1NodeJson;
import com.ubuntuone.api.files.json.U1UserJson;
import com.ubuntuone.api.files.json.U1VolumeJson;
import com.ubuntuone.api.files.model.U1Node;
import com.ubuntuone.api.files.model.U1NodeKind;
import com.ubuntuone.api.files.request.U1DownloadListener;
import com.ubuntuone.api.files.request.U1UploadListener;
import com.ubuntuone.api.files.util.HashUtils;
import com.ubuntuone.api.files.util.U1CancelTrigger;
import com.ubuntuone.api.files.util.U1Failure;
import com.ubuntuone.api.files.util.U1OnProgressListener;
import com.ubuntuone.api.files.util.U1RequestListener;
import com.ubuntuone.api.sso.authorizer.Authorizer;
import com.ubuntuone.api.sso.authorizer.AuthorizerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.codehaus.jackson.JsonParseException;

public class U1FileAPI {
    private static final Logger LOGGER = Logger.getLogger(U1FileAPI.class.getName());
    public static final String HTTPS = "https";
    protected static final String RESOURCE_HOST = "one.ubuntu.com";
    protected static final String CONTENT_HOST = "files.one.ubuntu.com";
    private final ResourceClient resourceClient;
    private final ContentClient contentClient;

    public U1FileAPI(String appPackageName, String appVersion, HttpClient httpClient, Authorizer authorizer) {
        this(appPackageName, appVersion, HTTPS, RESOURCE_HOST, CONTENT_HOST, httpClient, authorizer);
    }

    public U1FileAPI(String appPackageName, String appVersion, String resourceHost, String contentHost, HttpClient httpClient, Authorizer authorizer) {
        this(appPackageName, appVersion, HTTPS, resourceHost, contentHost, httpClient, authorizer);
    }

    public U1FileAPI(String appPackageName, String appVersion, String scheme, String resourceHost, String contentHost, HttpClient httpClient, Authorizer authorizer) {
        String userAgent = this.getUserAgent(appPackageName, appVersion);
        this.resourceClient = new ResourceClient(userAgent, scheme, resourceHost, httpClient, authorizer);
        this.contentClient = new ContentClient(userAgent, scheme, contentHost, httpClient, authorizer);
    }

    private void handleNon200HttpResponse(HttpResponse response, String message, U1RequestListener<?> callback) {
        int statusCode = U1FileAPI.getStatusCode(response);
        switch (statusCode) {
            case 307: {
                callback.onFailure(new U1Failure(String.format("%s Not following redirect.", message), statusCode));
                break;
            }
            case 401: {
                callback.onFailure(new U1Failure(String.format("%s Unauthorized. Please log in again.", message), statusCode));
                break;
            }
            case 403: {
                callback.onFailure(new U1Failure(String.format("%s Forbidden. Please log in again.", message), statusCode));
                break;
            }
            case 400: {
                callback.onFailure(new U1Failure(String.format("%s Bad request. You can't do that.", message), statusCode));
                break;
            }
            case 404: {
                callback.onUbuntuOneFailure(new U1Failure(String.format("%s Resource not found.", message), statusCode));
                break;
            }
            case 408: {
                callback.onFailure(new U1Failure(String.format("%s Request timeout.", message), statusCode));
                break;
            }
            case 500: {
                String oopsId = U1FileAPI.getHeaderValue("X-Oops-Id", response);
                String bzrRev = U1FileAPI.getHeaderValue("X-Bzr-Revision-Number", response);
                String date = U1FileAPI.getHeaderValue("Date", response);
                callback.onUbuntuOneFailure(new U1Failure(String.format("%s Problem on the server.", message), statusCode, oopsId, bzrRev, date));
                break;
            }
            case 503: {
                callback.onUbuntuOneFailure(new U1Failure(String.format("%s Service temporarily unavailable.", message), statusCode));
                break;
            }
            default: {
                callback.onFailure(new U1Failure(String.format("%s Response failure (%d).", message, statusCode), statusCode));
            }
        }
        U1FileAPI.consumeContent(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getUser(U1RequestListener.U1UserRequestListener callback) {
        callback.onStart();
        String path = this.resourceClient.getPath("");
        HttpResponse response = null;
        try {
            response = this.resourceClient.request("GET", path);
            int statusCode = U1FileAPI.getStatusCode(response);
            if (statusCode == 200) {
                U1UserJson.fromJson(U1FileAPI.getContentInputStream(response), callback);
                U1FileAPI.consumeContent(response);
            } else {
                this.handleNon200HttpResponse(response, "Could not get user.", callback);
            }
        }
        catch (JsonParseException jpe) {
            String oopsId = U1FileAPI.getHeaderValue("X-Oops-Id", response);
            String bzrRev = U1FileAPI.getHeaderValue("X-Bzr-Revision-Number", response);
            String date = U1FileAPI.getHeaderValue("Date", response);
            callback.onUbuntuOneFailure(new U1Failure("Could not get Ubuntu user. Corrupt JSON.", jpe, 0, oopsId, bzrRev, date));
        }
        catch (OutOfMemoryError e) {
            callback.onFailure(new U1Failure("Out of memory!", e));
            throw e;
        }
        catch (SSLException sslException) {
            callback.onFailure(new U1Failure("SSL connection problem. This may be intermittent issue, please try again later.", sslException));
        }
        catch (IOException ioException) {
            callback.onFailure(new U1Failure("Could not get Ubutnu user (network error).", ioException));
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException(uriSyntaxException);
        }
        catch (AuthorizerException signingException) {
            callback.onFailure(new U1Failure("Could not get Ubutnu user (signing exception).", signingException));
        }
        finally {
            callback.onFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getVolumes(U1RequestListener.U1VolumeRequestListener callback) {
        callback.onStart();
        String path = this.resourceClient.getPath("volumes");
        HttpResponse response = null;
        try {
            response = this.resourceClient.request("GET", path);
            int statusCode = U1FileAPI.getStatusCode(response);
            if (statusCode == 200) {
                U1VolumeJson.fromJson(U1FileAPI.getContentInputStream(response), callback);
                U1FileAPI.consumeContent(response);
            } else {
                this.handleNon200HttpResponse(response, "Could not get volumes.", callback);
            }
        }
        catch (JsonParseException jpe) {
            String oopsId = U1FileAPI.getHeaderValue("X-Oops-Id", response);
            String bzrRev = U1FileAPI.getHeaderValue("X-Bzr-Revision-Number", response);
            String date = U1FileAPI.getHeaderValue("Date", response);
            callback.onUbuntuOneFailure(new U1Failure("Could not get volumes. Corrupt JSON.", jpe, 0, oopsId, bzrRev, date));
        }
        catch (OutOfMemoryError e) {
            callback.onFailure(new U1Failure("Out of memory!", e));
            throw e;
        }
        catch (SSLException sslException) {
            callback.onFailure(new U1Failure("SSL connection problem. This may be intermittent issue, please try again later.", sslException));
        }
        catch (IOException ioException) {
            callback.onFailure(new U1Failure("Could not get volumes (network error).", ioException));
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException(uriSyntaxException);
        }
        catch (AuthorizerException signingException) {
            callback.onFailure(new U1Failure("Could not get Ubutnu user (signing exception).", signingException));
        }
        finally {
            callback.onFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getVolume(String resourcePath, U1RequestListener.U1VolumeRequestListener callback) {
        callback.onStart();
        String path = this.resourceClient.getPath(resourcePath);
        HttpResponse response = null;
        try {
            response = this.resourceClient.request("GET", path);
            int statusCode = U1FileAPI.getStatusCode(response);
            if (statusCode == 200) {
                U1VolumeJson.fromJson(U1FileAPI.getContentInputStream(response), callback);
                U1FileAPI.consumeContent(response);
            } else {
                this.handleNon200HttpResponse(response, "Could not get volume.", callback);
            }
        }
        catch (JsonParseException jpe) {
            String oopsId = U1FileAPI.getHeaderValue("X-Oops-Id", response);
            String bzrRev = U1FileAPI.getHeaderValue("X-Bzr-Revision-Number", response);
            String date = U1FileAPI.getHeaderValue("Date", response);
            callback.onUbuntuOneFailure(new U1Failure("Could not get volume. Corrupt JSON.", jpe, 0, oopsId, bzrRev, date));
        }
        catch (OutOfMemoryError e) {
            callback.onFailure(new U1Failure("Out of memory!", e));
            throw e;
        }
        catch (SSLException sslException) {
            callback.onFailure(new U1Failure("SSL connection problem. This may be intermittent issue, please try again later.", sslException));
        }
        catch (IOException ioException) {
            callback.onFailure(new U1Failure("Could not get volume (network error).", ioException));
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException(uriSyntaxException);
        }
        catch (AuthorizerException signingException) {
            callback.onFailure(new U1Failure("Could not get volume (signing exception).", signingException));
        }
        finally {
            callback.onFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getVolumeDelta(String resourcePath, Long fromGeneration, U1RequestListener.U1NodeRequestListener callback) {
        callback.onStart();
        String path = this.resourceClient.getPath(resourcePath);
        HttpResponse response = null;
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("delta", fromGeneration.toString()));
        try {
            response = this.resourceClient.request("GET", path, params, null);
            int statusCode = U1FileAPI.getStatusCode(response);
            if (statusCode == 200) {
                U1DeltaJson.fromJson(U1FileAPI.getContentInputStream(response), callback);
                U1FileAPI.consumeContent(response);
            } else {
                this.handleNon200HttpResponse(response, "Could not get volume.", callback);
            }
        }
        catch (JsonParseException jpe) {
            String oopsId = U1FileAPI.getHeaderValue("X-Oops-Id", response);
            String bzrRev = U1FileAPI.getHeaderValue("X-Bzr-Revision-Number", response);
            String date = U1FileAPI.getHeaderValue("Date", response);
            callback.onUbuntuOneFailure(new U1Failure("Could not get volume. Corrupt JSON.", jpe, 0, oopsId, bzrRev, date));
        }
        catch (OutOfMemoryError e) {
            callback.onFailure(new U1Failure("Out of memory!", e));
            throw e;
        }
        catch (SSLException sslException) {
            callback.onFailure(new U1Failure("SSL connection problem. This may be intermittent issue, please try again later.", sslException));
        }
        catch (IOException ioException) {
            callback.onFailure(new U1Failure("Could not get volume (network error).", ioException));
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException(uriSyntaxException);
        }
        catch (AuthorizerException signingException) {
            callback.onFailure(new U1Failure("Could not get volume (signing exception).", signingException));
        }
        finally {
            callback.onFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createVolume(String resourcePath, U1RequestListener.U1VolumeRequestListener callback) {
        callback.onStart();
        String path = this.resourceClient.getPath(resourcePath);
        HttpResponse response = null;
        try {
            response = this.resourceClient.request("PUT", path);
            int statusCode = U1FileAPI.getStatusCode(response);
            if (statusCode == 200) {
                U1VolumeJson.fromJson(U1FileAPI.getContentInputStream(response), callback);
                U1FileAPI.consumeContent(response);
            } else {
                this.handleNon200HttpResponse(response, "Could not get volumes.", callback);
            }
        }
        catch (JsonParseException jpe) {
            String oopsId = U1FileAPI.getHeaderValue("X-Oops-Id", response);
            String bzrRev = U1FileAPI.getHeaderValue("X-Bzr-Revision-Number", response);
            String date = U1FileAPI.getHeaderValue("Date", response);
            callback.onUbuntuOneFailure(new U1Failure("Could not get volumes. Corrupt JSON.", jpe, 0, oopsId, bzrRev, date));
        }
        catch (OutOfMemoryError e) {
            callback.onFailure(new U1Failure("Out of memory!", e));
            throw e;
        }
        catch (SSLException sslException) {
            callback.onFailure(new U1Failure("SSL connection problem. This may be intermittent issue, please try again later.", sslException));
        }
        catch (IOException ioException) {
            callback.onFailure(new U1Failure("Could not create volume (network error).", ioException));
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException(uriSyntaxException);
        }
        catch (AuthorizerException signingException) {
            callback.onFailure(new U1Failure("Could not create volume (signing exception).", signingException));
        }
        finally {
            callback.onFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVolume(String resourcePath, U1RequestListener.U1VolumeRequestListener callback) {
        callback.onStart();
        String path = this.resourceClient.getPath(resourcePath);
        HttpResponse response = null;
        try {
            response = this.resourceClient.request("DELETE", path);
            int statusCode = U1FileAPI.getStatusCode(response);
            if (statusCode == 200) {
                U1FileAPI.consumeContent(response);
                callback.onSuccess(null);
            } else {
                this.handleNon200HttpResponse(response, "Could not delete volume.", callback);
            }
        }
        catch (SSLException sslException) {
            callback.onFailure(new U1Failure("SSL connection problem. This may be intermittent issue, please try again later.", sslException));
        }
        catch (IOException ioException) {
            callback.onFailure(new U1Failure("Could not delete volume (network error).", ioException));
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException(uriSyntaxException);
        }
        catch (AuthorizerException signingException) {
            callback.onFailure(new U1Failure("Could not delete volume (signing exception).", signingException));
        }
        finally {
            callback.onFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeDirectory(String resourcePath, U1RequestListener.U1NodeRequestListener callback) {
        callback.onStart();
        String path = this.resourceClient.getPath(resourcePath);
        HttpResponse response = null;
        try {
            String data = U1CustomNodeJson.newDirectoryJson(U1NodeKind.DIRECTORY);
            response = this.resourceClient.request("PUT", path, null, data);
            int statusCode = U1FileAPI.getStatusCode(response);
            if (statusCode == 200) {
                U1NodeJson.fromJson(U1FileAPI.getContentInputStream(response), (U1RequestListener<U1Node>)callback);
            } else {
                this.handleNon200HttpResponse(response, "Could not make directory.", callback);
            }
        }
        catch (JsonParseException jpe) {
            String oopsId = U1FileAPI.getHeaderValue("X-Oops-Id", response);
            String bzrRev = U1FileAPI.getHeaderValue("X-Bzr-Revision-Number", response);
            String date = U1FileAPI.getHeaderValue("Date", response);
            callback.onUbuntuOneFailure(new U1Failure("Could not make directory. Corrupt JSON.", jpe, 0, oopsId, bzrRev, date));
        }
        catch (OutOfMemoryError e) {
            callback.onFailure(new U1Failure("Out of memory!", e));
            throw e;
        }
        catch (SSLException sslException) {
            callback.onFailure(new U1Failure("SSL connection problem. This may be intermittent issue, please try again later.", sslException));
        }
        catch (IOException ioException) {
            callback.onFailure(new U1Failure("Could not make directory (network error).", ioException));
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException(uriSyntaxException);
        }
        catch (AuthorizerException signingException) {
            callback.onFailure(new U1Failure("Could not make directory (signing exception).", signingException));
        }
        finally {
            callback.onFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(String resourcePath, U1RequestListener.U1NodeRequestListener callback) {
        callback.onStart();
        String path = this.resourceClient.getPath(resourcePath);
        HttpResponse response = null;
        try {
            response = this.resourceClient.request("DELETE", path);
            int statusCode = U1FileAPI.getStatusCode(response);
            if (statusCode == 200) {
                U1FileAPI.consumeContent(response);
                callback.onSuccess(null);
            } else {
                this.handleNon200HttpResponse(response, "Could not delete node.", callback);
            }
        }
        catch (SSLException sslException) {
            callback.onFailure(new U1Failure("SSL connection problem. This may be intermittent issue, please try again later.", sslException));
        }
        catch (IOException ioException) {
            callback.onFailure(new U1Failure("Could not delete node (network error).", ioException));
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException(uriSyntaxException);
        }
        catch (AuthorizerException signingException) {
            callback.onFailure(new U1Failure("Could not delete node (signing exception).", signingException));
        }
        finally {
            callback.onFinish();
        }
    }

    public void listDirectory(String resourcePath, U1RequestListener.U1NodeRequestListener callback) {
        this.getNode(resourcePath, true, callback);
    }

    public void getNode(String resourcePath, U1RequestListener.U1NodeRequestListener callback) {
        this.getNode(resourcePath, null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNode(String resourcePath, Boolean includeChildren, U1RequestListener.U1NodeRequestListener callback) {
        callback.onStart();
        String path = this.resourceClient.getPath(resourcePath);
        ArrayList<NameValuePair> params = null;
        if (includeChildren != null) {
            params = new ArrayList<NameValuePair>();
            params.add((NameValuePair)new BasicNameValuePair("include_children", includeChildren.toString()));
        }
        HttpResponse response = null;
        try {
            response = this.resourceClient.request("GET", path, params, null);
            int statusCode = U1FileAPI.getStatusCode(response);
            if (statusCode == 200) {
                U1NodeJson.fromJson(U1FileAPI.getContentInputStream(response), (U1RequestListener<U1Node>)callback);
                U1FileAPI.consumeContent(response);
            } else {
                this.handleNon200HttpResponse(response, "Could not get node.", callback);
            }
        }
        catch (JsonParseException jpe) {
            String oopsId = U1FileAPI.getHeaderValue("X-Oops-Id", response);
            String bzrRev = U1FileAPI.getHeaderValue("X-Bzr-Revision-Number", response);
            String date = U1FileAPI.getHeaderValue("Date", response);
            callback.onUbuntuOneFailure(new U1Failure("Could not get node. Corrupt JSON.", jpe, 0, oopsId, bzrRev, date));
        }
        catch (OutOfMemoryError e) {
            callback.onFailure(new U1Failure("Out of memory!", e));
            throw e;
        }
        catch (SSLException sslException) {
            callback.onFailure(new U1Failure("SSL connection problem. This may be intermittent issue, please try again later.", sslException));
        }
        catch (IOException ioException) {
            callback.onFailure(new U1Failure("Could not get node (network error).", ioException));
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException(uriSyntaxException);
        }
        catch (AuthorizerException signingException) {
            callback.onFailure(new U1Failure("Could not get node (signing exception).", signingException));
        }
        finally {
            callback.onFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveNode(String resourcePath, String newPath, U1RequestListener.U1NodeRequestListener callback) {
        callback.onStart();
        String path = this.resourceClient.getPath(resourcePath);
        HttpResponse response = null;
        try {
            String data = U1CustomNodeJson.moveNodeJson(newPath);
            response = this.resourceClient.request("PUT", path, null, data);
            int statusCode = U1FileAPI.getStatusCode(response);
            if (statusCode == 200) {
                U1NodeJson.fromJson(U1FileAPI.getContentInputStream(response), (U1RequestListener<U1Node>)callback);
                U1FileAPI.consumeContent(response);
            } else {
                this.handleNon200HttpResponse(response, "Could not perform move.", callback);
            }
        }
        catch (JsonParseException jpe) {
            String oopsId = U1FileAPI.getHeaderValue("X-Oops-Id", response);
            String bzrRev = U1FileAPI.getHeaderValue("X-Bzr-Revision-Number", response);
            String date = U1FileAPI.getHeaderValue("Date", response);
            callback.onUbuntuOneFailure(new U1Failure("Could not perform move. Corrupt JSON.", jpe, 0, oopsId, bzrRev, date));
        }
        catch (OutOfMemoryError e) {
            callback.onFailure(new U1Failure("Out of memory!", e));
            throw e;
        }
        catch (SSLException sslException) {
            callback.onFailure(new U1Failure("SSL connection problem. This may be intermittent issue, please try again later.", sslException));
        }
        catch (IOException ioException) {
            callback.onFailure(new U1Failure("Could not perform move (network error).", ioException));
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException(uriSyntaxException);
        }
        catch (AuthorizerException signingException) {
            callback.onFailure(new U1Failure("Could not perform move (signing exception).", signingException));
        }
        finally {
            callback.onFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilePublic(String resourcePath, Boolean isPublic, U1RequestListener.U1NodeRequestListener callback) {
        callback.onStart();
        String path = this.resourceClient.getPath(resourcePath);
        HttpResponse response = null;
        try {
            String data = U1CustomNodeJson.publishFileJson(isPublic);
            response = this.resourceClient.request("PUT", path, null, data);
            int statusCode = U1FileAPI.getStatusCode(response);
            if (statusCode == 200) {
                U1NodeJson.fromJson(U1FileAPI.getContentInputStream(response), (U1RequestListener<U1Node>)callback);
                U1FileAPI.consumeContent(response);
            } else {
                this.handleNon200HttpResponse(response, "Could not publis file.", callback);
            }
        }
        catch (JsonParseException jpe) {
            String oopsId = U1FileAPI.getHeaderValue("X-Oops-Id", response);
            String bzrRev = U1FileAPI.getHeaderValue("X-Bzr-Revision-Number", response);
            String date = U1FileAPI.getHeaderValue("Date", response);
            callback.onUbuntuOneFailure(new U1Failure("Could not publis file. Corrupt JSON.", jpe, 0, oopsId, bzrRev, date));
        }
        catch (OutOfMemoryError e) {
            callback.onFailure(new U1Failure("Out of memory!", e));
            throw e;
        }
        catch (SSLException sslException) {
            callback.onFailure(new U1Failure("SSL connection problem. This may be intermittent issue, please try again later.", sslException));
        }
        catch (IOException ioException) {
            callback.onFailure(new U1Failure("Could not publis file (network error).", ioException));
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException(uriSyntaxException);
        }
        catch (AuthorizerException signingException) {
            callback.onFailure(new U1Failure("Could not publis file (signing exception).", signingException));
        }
        finally {
            callback.onFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPublicFiles(U1RequestListener.U1NodeRequestListener callback) {
        callback.onStart();
        String path = this.resourceClient.getPath("public_files");
        HttpResponse response = null;
        try {
            response = this.resourceClient.request("GET", path);
            int statusCode = U1FileAPI.getStatusCode(response);
            if (statusCode == 200) {
                U1NodeJson.fromJson(U1FileAPI.getContentInputStream(response), (U1RequestListener<U1Node>)callback);
                U1FileAPI.consumeContent(response);
            } else {
                this.handleNon200HttpResponse(response, "Could not get public files.", callback);
            }
        }
        catch (JsonParseException jpe) {
            String oopsId = U1FileAPI.getHeaderValue("X-Oops-Id", response);
            String bzrRev = U1FileAPI.getHeaderValue("X-Bzr-Revision-Number", response);
            String date = U1FileAPI.getHeaderValue("Date", response);
            callback.onUbuntuOneFailure(new U1Failure("Could not get public files. Corrupt JSON.", jpe, 0, oopsId, bzrRev, date));
        }
        catch (OutOfMemoryError e) {
            callback.onFailure(new U1Failure("Out of memory!", e));
            throw e;
        }
        catch (SSLException sslException) {
            callback.onFailure(new U1Failure("SSL connection problem. This may be intermittent issue, please try again later.", sslException));
        }
        catch (IOException ioException) {
            callback.onFailure(new U1Failure("Could not public files (network error).", ioException));
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException(uriSyntaxException);
        }
        catch (AuthorizerException signingException) {
            callback.onFailure(new U1Failure("Could not public files (signing exception).", signingException));
        }
        finally {
            callback.onFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFile(String filePath, String contentType, String resourcePath, Boolean useMagic, Boolean isPublic, U1UploadListener callback, U1CancelTrigger cancelTrigger) {
        HashUtils.U1Hashes hashes;
        callback.onStart();
        try {
            hashes = HashUtils.getU1Hashes(new FileInputStream(filePath));
        }
        catch (Exception e) {
            callback.onFailure(new U1Failure("Error reading file: " + filePath, e));
            callback.onFinish();
            return;
        }
        String path = this.resourceClient.getPath(resourcePath);
        String contentPath = this.contentClient.getPath(resourcePath);
        HttpResponse response = null;
        try {
            int statusCode;
            if (useMagic.booleanValue()) {
                String data = U1CustomNodeJson.newFileJson(U1NodeKind.FILE, isPublic, hashes.hash, hashes.magicHash);
                response = this.resourceClient.request("PUT", path, null, data);
                int statusCode2 = U1FileAPI.getStatusCode(response);
                if (statusCode2 == 200 || statusCode2 == 201) {
                    LOGGER.info("Magic upload success, status code: " + statusCode2);
                    U1NodeJson.fromJson(U1FileAPI.getContentInputStream(response), (U1RequestListener<U1Node>)callback);
                    U1FileAPI.consumeContent(response);
                    return;
                }
                if (statusCode2 == 400) {
                    LOGGER.info("Magic upload failure, status code: " + statusCode2);
                } else {
                    LOGGER.info("Magic upload failure, status code: " + statusCode2);
                    this.handleNon200HttpResponse(response, "Server problem? HTTP " + statusCode2, callback);
                    return;
                }
            }
            File file = new File(filePath);
            FileInputStream instream = new FileInputStream(file);
            long length = file.length();
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            if (200 <= (statusCode = U1FileAPI.getStatusCode(response = this.contentClient.upload(contentPath, instream, contentType, length, null, callback, cancelTrigger))) && statusCode <= 299) {
                U1NodeJson.fromJson(U1FileAPI.getContentInputStream(response), (U1RequestListener<U1Node>)callback);
                U1FileAPI.consumeContent(response);
            } else if (cancelTrigger != null && cancelTrigger.isCancelled()) {
            } else {
                this.handleNon200HttpResponse(response, "Could not upload file.", callback);
            }
        }
        catch (JsonParseException jpe) {
            String oopsId = U1FileAPI.getHeaderValue("X-Oops-Id", response);
            String bzrRev = U1FileAPI.getHeaderValue("X-Bzr-Revision-Number", response);
            String date = U1FileAPI.getHeaderValue("Date", response);
            callback.onUbuntuOneFailure(new U1Failure("Could not upload file. Corrupt JSON.", jpe, 0, oopsId, bzrRev, date));
        }
        catch (OutOfMemoryError e) {
            callback.onFailure(new U1Failure("Out of memory!", e));
            throw e;
        }
        catch (U1CancelTrigger.RequestCanceledException canceledException) {
            callback.onCancel();
        }
        catch (SSLException sslException) {
            callback.onFailure(new U1Failure("SSL connection problem. This may be intermittent issue, please try again later.", sslException));
        }
        catch (IOException ioException) {
            callback.onFailure(new U1Failure("Could not upload file (network error).", ioException));
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException(uriSyntaxException);
        }
        catch (AuthorizerException signingException) {
            callback.onFailure(new U1Failure("Could not upload file (signing exception).", signingException));
        }
        finally {
            callback.onFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFile(String resourcePath, String localPath, U1DownloadListener callback, U1CancelTrigger cancelTrigger) {
        callback.onStart();
        String contentPath = this.contentClient.getPath(resourcePath);
        HttpResponse response = null;
        int statusCode = 0;
        try {
            long offset;
            File file = new File(localPath);
            file.getParentFile().mkdirs();
            long l = offset = file.exists() ? file.length() : 0L;
            if (offset > 0L && (statusCode = U1FileAPI.getStatusCode(response = this.contentClient.download(contentPath, offset, cancelTrigger))) != 206) {
                U1FileAPI.consumeContent(response);
                offset = 0L;
            }
            if (statusCode != 206) {
                response = this.contentClient.download(contentPath, offset, cancelTrigger);
                statusCode = U1FileAPI.getStatusCode(response);
            }
            if (statusCode >= 200 && statusCode < 300) {
                boolean isResuming = offset > 0L;
                LOGGER.info(String.format("%s download to %s", isResuming ? "Resuming" : "Starting", file.getPath()));
                Header contentLength = response.getFirstHeader("Content-Length");
                long size = Long.valueOf(contentLength.getValue());
                U1OnProgressListener.ProgressInputStream in = new U1OnProgressListener.ProgressInputStream(U1FileAPI.getContentInputStream(response), offset, offset + size, callback);
                FileOutputStream stream = new FileOutputStream(file, isResuming);
                in.writeTo(stream);
                U1FileAPI.consumeContent(response);
                callback.onSuccess();
            } else if (cancelTrigger != null && cancelTrigger.isCancelled()) {
            } else {
                this.handleNon200HttpResponse(response, "Could not download file.", callback);
            }
        }
        catch (U1CancelTrigger.RequestCanceledException canceledException) {
            callback.onCancel();
        }
        catch (SSLException sslException) {
            callback.onFailure(new U1Failure("SSL connection problem. This may be intermittent issue, please try again later.", sslException));
        }
        catch (IOException ioException) {
            callback.onFailure(new U1Failure("Could not download file (network error).", ioException));
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException(uriSyntaxException);
        }
        catch (AuthorizerException signingException) {
            callback.onFailure(new U1Failure("Could not download file (signing exception).", signingException));
        }
        finally {
            callback.onFinish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void downloadThumbnail(String nodeKey, int size, String localPath, U1DownloadListener callback, U1CancelTrigger cancelTrigger) {
        callback.onStart();
        String contentPath = this.contentClient.getThumbnailPath(nodeKey, size);
        HttpResponse response = null;
        int statusCode = 0;
        try {
            long offset;
            File file = new File(localPath);
            long l = offset = file.exists() ? file.length() : 0L;
            if (offset > 0L && (statusCode = U1FileAPI.getStatusCode(response = this.contentClient.download(contentPath, offset, cancelTrigger))) != 206) {
                U1FileAPI.consumeContent(response);
                offset = 0L;
            }
            if (statusCode != 206) {
                response = this.contentClient.download(contentPath, offset, cancelTrigger);
                statusCode = U1FileAPI.getStatusCode(response);
            }
            if (statusCode >= 200 && statusCode < 300) {
                boolean isResuming = offset > 0L;
                LOGGER.info(String.format("%s download to %s", isResuming ? "Resuming" : "Starting", file.getPath()));
                U1OnProgressListener.ProgressInputStream in = new U1OnProgressListener.ProgressInputStream(U1FileAPI.getContentInputStream(response), 0L, 0L, null);
                FileOutputStream stream = new FileOutputStream(file, isResuming);
                in.writeTo(stream);
                U1FileAPI.consumeContent(response);
                callback.onSuccess();
            } else if (cancelTrigger != null && cancelTrigger.isCancelled()) {
            } else {
                this.handleNon200HttpResponse(response, "Could not download thumbnail.", callback);
            }
        }
        catch (U1CancelTrigger.RequestCanceledException canceledException) {
            callback.onCancel();
        }
        catch (SSLException sslException) {
            callback.onFailure(new U1Failure("SSL connection problem. This may be intermittent issue, please try again later.", sslException));
        }
        catch (IOException ioException) {
            callback.onFailure(new U1Failure("Could not download thumbnail (network error).", ioException));
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalStateException(uriSyntaxException);
        }
        catch (AuthorizerException signingException) {
            callback.onFailure(new U1Failure("Could not download thumbnail (signing exception).", signingException));
        }
        finally {
            callback.onFinish();
        }
    }

    private static final int getStatusCode(HttpResponse response) {
        return response != null ? Integer.valueOf(response.getStatusLine().getStatusCode()) : null;
    }

    private static final String getHeaderValue(String header, HttpResponse response) {
        return response.containsHeader(header) ? response.getFirstHeader(header).getValue() : null;
    }

    private static final InputStream getContentInputStream(HttpResponse response) throws IllegalStateException, IOException {
        return response != null ? response.getEntity().getContent() : null;
    }

    private static final void consumeContent(HttpResponse response) {
        HttpEntity entity;
        if (response != null && (entity = response.getEntity()) != null) {
            try {
                InputStream in = entity.getContent();
                if (in != null) {
                    while (in.read() != -1) {
                    }
                    in.close();
                }
            }
            catch (IOException e) {
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private String getUserAgent(String appPackageName, String appVersion) {
        if (appPackageName == null || appPackageName.length() == 0) {
            LOGGER.warning("It is encouraged to provide proper application package name.");
            appPackageName = "com.ubuntuone.api.files-unkown";
        }
        if (appVersion == null || appVersion.length() == 0) {
            LOGGER.warning("It is encouraged to provide proper application version.");
            appVersion = "unknown";
        }
        return String.format("%s/%s", appPackageName, appVersion);
    }
}

