/*
 * Decompiled with CFR 0.152.
 */
package com.ubuntuone.api.files.client;

import com.ubuntuone.api.sso.authorizer.Authorizer;
import com.ubuntuone.api.sso.authorizer.AuthorizerException;
import java.io.IOException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;

public abstract class BaseClient {
    public static final String API_VERSION = "v1";
    public static final String API_PATH = "/api/file_storage/v1";
    protected final String userAgent;
    private final HttpClient httpClient;
    private final HttpHost httpHost;
    private Authorizer authorizer;
    private HttpRequestRetryHandler retryHandler = new HttpRequestRetryHandler(){

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            boolean idempotent;
            if (executionCount >= 3) {
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                return true;
            }
            if (exception instanceof SSLHandshakeException) {
                return false;
            }
            HttpRequest request = (HttpRequest)context.getAttribute("http.request");
            boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
            return idempotent;
        }
    };

    public BaseClient(String userAgent, String scheme, String hostname, HttpClient httpClient, Authorizer authorizer) {
        this.userAgent = userAgent != null ? userAgent : "u1-files-java-library";
        this.httpClient = httpClient;
        if (httpClient.getClass() == DefaultHttpClient.class) {
            ((DefaultHttpClient)this.httpClient).setHttpRequestRetryHandler(this.retryHandler);
        }
        this.httpHost = new HttpHost(hostname, -1, scheme);
        this.authorizer = authorizer;
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected HttpHost getHost() {
        return this.httpHost;
    }

    public abstract String getPath(String var1);

    protected void sign(HttpUriRequest request) throws AuthorizerException {
        this.authorizer.signRequest(request);
    }
}

