/*
 * Decompiled with CFR 0.152.
 */
package com.ubuntuone.api.files.client;

import com.ubuntuone.api.files.U1FileAPI;
import com.ubuntuone.api.files.client.BaseClient;
import com.ubuntuone.api.files.util.HttpUtils;
import com.ubuntuone.api.files.util.U1CancelTrigger;
import com.ubuntuone.api.files.util.U1OnProgressListener;
import com.ubuntuone.api.sso.authorizer.Authorizer;
import com.ubuntuone.api.sso.authorizer.AuthorizerException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.InputStreamEntity;

public class ContentClient
extends BaseClient {
    private final Logger logger = Logger.getLogger(U1FileAPI.class.getName());

    public ContentClient(String userAgent, String scheme, String hostname, HttpClient httpClient, Authorizer authorizer) {
        super(userAgent, scheme, hostname, httpClient, authorizer);
    }

    @Override
    public String getPath(String path) {
        if (path.startsWith("/")) {
            path = path.length() == 1 ? "" : path.substring(1);
        }
        return String.format("/content/%s", path);
    }

    public String getThumbnailPath(String nodeKey, int size) {
        return String.format("/thumbnail/file_storage/%s/%dx%d/", nodeKey, size, size);
    }

    public HttpResponse upload(String path, InputStream instream, String contentType, long length, List<NameValuePair> params, U1OnProgressListener progressListener, U1CancelTrigger cancelTrigger) throws IOException, SSLException, URISyntaxException, AuthorizerException, U1CancelTrigger.RequestCanceledException {
        HttpClient httpClient = this.getHttpClient();
        String query = null;
        if (params != null) {
            query = URLEncodedUtils.format(params, (String)"UTF-8");
        }
        URI uri = new URI(this.getHost().getSchemeName(), this.getHost().getHostName(), path, query, null);
        InputStreamEntity entity = new InputStreamEntity(instream, length);
        Object wrappedEntity = progressListener != null ? new U1OnProgressListener.ProgressHttpEntity((HttpEntity)entity, progressListener) : entity;
        HttpPut request = new HttpPut(uri.toString());
        if (cancelTrigger != null) {
            cancelTrigger.setRequest((HttpUriRequest)request);
        }
        request.addHeader("User-Agent", this.userAgent);
        request.addHeader("Connection", "close");
        request.addHeader("Accept", "application/json");
        request.addHeader("Content-Type", contentType);
        request.setEntity((HttpEntity)wrappedEntity);
        this.sign((HttpUriRequest)request);
        this.logger.fine(request.getRequestLine().toString());
        HttpUtils.dumpHeaders(request.getAllHeaders(), this.logger, Level.FINE);
        HttpResponse response = httpClient.execute(this.getHost(), (HttpRequest)request);
        if (response != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            String msg = response.getStatusLine().toString();
            if (200 <= statusCode && statusCode <= 299) {
                this.logger.fine(msg);
            } else {
                this.logger.warning(msg);
                this.logger.warning(request.getRequestLine().toString());
            }
        }
        return response;
    }

    public HttpResponse download(String path, long offset, U1CancelTrigger cancelTrigger) throws IOException, SSLException, AuthorizerException, URISyntaxException, U1CancelTrigger.RequestCanceledException {
        HttpClient httpClient = this.getHttpClient();
        URI uri = new URI(this.getHost().getSchemeName(), this.getHost().getHostName(), path, null);
        HttpGet request = new HttpGet(uri.toString());
        if (cancelTrigger != null) {
            cancelTrigger.setRequest((HttpUriRequest)request);
        }
        request.addHeader("User-Agent", this.userAgent);
        request.addHeader("Accept", "*/*");
        request.addHeader("Connection", "close");
        if (offset > 0L) {
            request.addHeader("Range", String.format("bytes=%d-", offset));
        }
        this.sign((HttpUriRequest)request);
        this.logger.fine(request.getRequestLine().toString());
        HttpUtils.dumpHeaders(request.getAllHeaders(), this.logger, Level.FINE);
        HttpResponse response = httpClient.execute(this.getHost(), (HttpRequest)request);
        if (response != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            String msg = response.getStatusLine().toString();
            if (200 <= statusCode && statusCode <= 299) {
                this.logger.fine(msg);
            } else {
                this.logger.warning(msg);
            }
            HttpUtils.dumpHeaders(response.getAllHeaders(), this.logger, Level.FINE);
        }
        return response;
    }
}

