/*
 * Decompiled with CFR 0.152.
 */
package com.ubuntuone.api.files.client;

import com.ubuntuone.api.files.U1FileAPI;
import com.ubuntuone.api.files.client.BaseClient;
import com.ubuntuone.api.files.util.HttpUriRequestFactory;
import com.ubuntuone.api.sso.authorizer.Authorizer;
import com.ubuntuone.api.sso.authorizer.AuthorizerException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;

public class ResourceClient
extends BaseClient {
    private final Logger logger = Logger.getLogger(U1FileAPI.class.getName());
    public static final String INCLUDE_CHILDREN = "include_children=true";
    public static final String IS_PUBLIC = "is_public=true";

    public ResourceClient(String userAgent, String scheme, String hostname, HttpClient httpClient, Authorizer authorizer) {
        super(userAgent, scheme, hostname, httpClient, authorizer);
    }

    @Override
    public String getPath(String path) {
        if (path != null && !path.equals("")) {
            if (path.startsWith("/")) {
                path = path.length() == 1 ? "" : path.substring(1);
            }
            return String.format("%s/%s", "/api/file_storage/v1", path);
        }
        return "/api/file_storage/v1";
    }

    public HttpResponse request(String method, String path, List<NameValuePair> params, String data) throws IOException, SSLException, URISyntaxException, AuthorizerException {
        HttpClient httpClient = this.getHttpClient();
        String query = null;
        if (params != null) {
            query = URLEncodedUtils.format(params, (String)"UTF-8");
        }
        URI uri = new URI(this.getHost().getSchemeName(), this.getHost().getHostName(), path, query, null);
        HttpUriRequest request = HttpUriRequestFactory.buildUriRequest(method, uri.toString());
        request.addHeader("User-Agent", this.userAgent);
        request.addHeader("Connection", "close");
        request.addHeader("Accept", "application/json");
        if (data != null && "PUT".equals(method)) {
            ((HttpPut)request).setEntity((HttpEntity)new StringEntity(data, "UTF-8"));
        }
        this.sign(request);
        this.logger.fine(request.getRequestLine().toString());
        HttpResponse response = httpClient.execute(this.getHost(), (HttpRequest)request);
        if (response != null) {
            int statusCode = response.getStatusLine().getStatusCode();
            String msg = response.getStatusLine().toString();
            if (200 <= statusCode && statusCode <= 299) {
                this.logger.fine(msg);
            } else {
                this.logger.warning(request.getRequestLine().toString());
                this.logger.warning(msg);
            }
        }
        return response;
    }

    public HttpResponse request(String method, String path) throws IOException, SSLException, URISyntaxException, AuthorizerException {
        return this.request(method, path, null, null);
    }
}

