/*
 * Decompiled with CFR 0.152.
 */
package com.ubuntuone.api.files.json;

import com.ubuntuone.api.files.model.U1Directory;
import com.ubuntuone.api.files.model.U1File;
import com.ubuntuone.api.files.model.U1Node;
import com.ubuntuone.api.files.model.U1NodeKind;
import com.ubuntuone.api.files.model.U1Resource;
import com.ubuntuone.api.files.util.U1RequestListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class U1NodeJson {
    public static String toJson(U1Node node, U1Node ... children) throws IOException {
        JsonFactory factory = new JsonFactory();
        StringWriter writer = new StringWriter(128);
        JsonGenerator g = factory.createJsonGenerator((Writer)writer);
        g.writeStartObject();
        g.writeStringField("resource_path", node.getResourcePath());
        g.writeStringField("kind", node.getKind().toString());
        g.writeBooleanField("is_live", node.getIsLive().booleanValue());
        g.writeStringField("path", node.getPath());
        g.writeStringField("parent_path", node.getParentPath());
        g.writeStringField("volume_path", node.getVolumePath());
        g.writeStringField("key", node.getKey());
        g.writeStringField("when_created", U1Resource.simpleDateFormat.format(node.getWhenCreated()));
        g.writeStringField("when_changed", U1Resource.simpleDateFormat.format(node.getWhenChanged()));
        g.writeNumberField("generation", node.getGeneration().longValue());
        g.writeNumberField("generation_created", node.getGenerationCreated().longValue());
        g.writeStringField("content_path", node.getContentPath());
        if (U1NodeKind.FILE == node.getKind()) {
            U1File file = (U1File)node;
            g.writeStringField("hash", file.getHash());
            g.writeNumberField("size", file.getSize().longValue());
            g.writeBooleanField("is_public", file.getIsPublic().booleanValue());
            g.writeStringField("public_url", file.getPublicUrl());
        } else if (children != null && children.length > 0) {
            g.writeBooleanField("has_children", true);
            g.writeArrayFieldStart("children");
            boolean first = true;
            for (U1Node childNode : children) {
                if (first) {
                    first = false;
                } else {
                    g.writeRaw(",");
                }
                g.writeRaw(U1NodeJson.toJson(childNode));
            }
            g.writeEndArray();
        } else {
            g.writeBooleanField("has_children", false);
        }
        g.writeEndObject();
        g.close();
        return writer.toString();
    }

    public static String toJson(U1Node node) throws IOException {
        return U1NodeJson.toJson(node, null);
    }

    public static void fromJson(InputStream stream, U1RequestListener<U1Node> callback) throws JsonParseException, IOException {
        JsonFactory factory = new JsonFactory();
        JsonParser jp = factory.createJsonParser(stream);
        U1NodeJson.fromJson(jp, callback);
    }

    static void fromJson(JsonParser jp, U1RequestListener<U1Node> callback) throws JsonParseException, IOException {
        while (true) {
            String resourcePath = null;
            U1NodeKind kind = null;
            Boolean isLive = false;
            String path = null;
            String parentPath = null;
            String volumePath = null;
            String key = null;
            Date whenCreated = null;
            Date whenChanged = null;
            Long generation = null;
            Long generationCreated = null;
            String contentPath = null;
            String hash = null;
            Long size = null;
            Boolean isPublic = null;
            String publicUrl = null;
            Boolean hasChildren = false;
            Boolean processedChildren = false;
            JsonToken token = jp.nextToken();
            if (token == null || JsonToken.END_ARRAY == token) break;
            if (JsonToken.START_ARRAY == token) continue;
            if (JsonToken.START_OBJECT != token) {
                throw new JsonParseException("Expected JsonToken.START_OBJECT", null);
            }
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String field = jp.getCurrentName();
                jp.nextToken();
                if ("resource_path".equals(field)) {
                    resourcePath = jp.getText();
                    continue;
                }
                if ("kind".equals(field)) {
                    kind = U1NodeKind.valueOf(jp.getText().toUpperCase(Locale.US));
                    continue;
                }
                if ("is_live".equals(field)) {
                    isLive = Boolean.valueOf(jp.getText().toLowerCase(Locale.US));
                    continue;
                }
                if ("path".equals(field)) {
                    path = jp.getText();
                    continue;
                }
                if ("parent_path".equals(field)) {
                    if (jp.getCurrentToken() == JsonToken.VALUE_NULL) continue;
                    parentPath = jp.getText();
                    continue;
                }
                if ("volume_path".equals(field)) {
                    volumePath = jp.getText();
                    continue;
                }
                if ("key".equals(field)) {
                    key = jp.getText();
                    continue;
                }
                if ("when_created".equals(field)) {
                    try {
                        whenCreated = U1Resource.simpleDateFormat.parse(jp.getText());
                        continue;
                    }
                    catch (ParseException e) {
                        throw new JsonParseException("Incorrect date format", null);
                    }
                }
                if ("when_changed".equals(field)) {
                    try {
                        whenChanged = U1Resource.simpleDateFormat.parse(jp.getText());
                        continue;
                    }
                    catch (ParseException e) {
                        throw new JsonParseException("Incorrect date format", null);
                    }
                }
                if ("generation".equals(field)) {
                    generation = jp.getLongValue();
                    continue;
                }
                if ("generation_created".equals(field)) {
                    generationCreated = jp.getLongValue();
                    continue;
                }
                if ("content_path".equals(field)) {
                    contentPath = jp.getText();
                    continue;
                }
                if ("hash".equals(field)) {
                    if (jp.getCurrentToken() == JsonToken.VALUE_NULL) continue;
                    hash = jp.getText();
                    continue;
                }
                if ("size".equals(field)) {
                    if (jp.getCurrentToken() == JsonToken.VALUE_NULL) continue;
                    size = jp.getLongValue();
                    continue;
                }
                if ("is_public".equals(field)) {
                    isPublic = jp.getBooleanValue();
                    continue;
                }
                if ("public_url".equals(field)) {
                    if (jp.getCurrentToken() == JsonToken.VALUE_NULL) continue;
                    publicUrl = jp.getText();
                    continue;
                }
                if ("has_children".equals(field)) {
                    hasChildren = jp.getBooleanValue();
                    continue;
                }
                if ("children".equals(field)) {
                    U1NodeJson.fromJson(jp, callback);
                    processedChildren = true;
                    break;
                }
                System.err.println("Unrecognized JSON field '" + field + "'");
            }
            if (processedChildren.booleanValue()) break;
            if (U1NodeKind.FILE == kind) {
                U1File file = new U1File(resourcePath, kind, isLive, path, parentPath, volumePath, key, whenCreated, whenChanged, generation, generationCreated, contentPath, hash, size, isPublic, publicUrl);
                callback.onSuccess(file);
                continue;
            }
            U1Directory directory = new U1Directory(resourcePath, kind, isLive, path, parentPath, volumePath, key, whenCreated, whenChanged, generation, generationCreated, contentPath, hasChildren);
            callback.onSuccess(directory);
        }
        jp.close();
    }
}

