/*
 * Decompiled with CFR 0.152.
 */
package com.ubuntuone.api.files.json;

import com.ubuntuone.api.files.model.U1User;
import com.ubuntuone.api.files.util.U1RequestListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class U1UserJson {
    public static String toJson(U1User user) throws IOException {
        JsonFactory factory = new JsonFactory();
        StringWriter writer = new StringWriter(128);
        JsonGenerator g = factory.createJsonGenerator((Writer)writer);
        g.writeStartObject();
        g.writeStringField("resource_path", "");
        g.writeNumberField("user_id", user.getUserId().longValue());
        g.writeStringField("visible_name", user.getVisibleName());
        g.writeNumberField("max_bytes", user.getMaxBytes().longValue());
        g.writeNumberField("used_bytes", user.getUsedBytes().longValue());
        g.writeStringField("root_node_path", user.getRootNodePath());
        g.writeArrayFieldStart("user_node_paths");
        ArrayList<String> paths = user.getUserNodePaths();
        for (String path : paths) {
            g.writeString(path);
        }
        g.writeEndArray();
        g.writeEndObject();
        g.close();
        return writer.toString();
    }

    public static void fromJson(InputStream stream, U1RequestListener<U1User> callback) throws JsonParseException, IOException {
        JsonFactory factory = new JsonFactory();
        JsonParser jp = factory.createJsonParser(stream);
        if (JsonToken.START_OBJECT != jp.nextToken()) {
            throw new JsonParseException("Expected JsonToken.START_OBJECT", null);
        }
        String resourcePath = null;
        Long userId = null;
        String visibleName = null;
        Long maxBytes = null;
        Long usedBytes = null;
        String rootNodePath = null;
        ArrayList<String> userNodePaths = new ArrayList<String>();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String field = jp.getCurrentName();
            jp.nextToken();
            if ("resource_path".equals(field)) {
                resourcePath = jp.getText();
                continue;
            }
            if ("user_id".equals(field)) {
                userId = jp.getLongValue();
                continue;
            }
            if ("visible_name".equals(field)) {
                visibleName = jp.getText();
                continue;
            }
            if ("max_bytes".equals(field)) {
                maxBytes = jp.getLongValue();
                continue;
            }
            if ("used_bytes".equals(field)) {
                usedBytes = jp.getLongValue();
                continue;
            }
            if ("root_node_path".equals(field)) {
                rootNodePath = jp.getText();
                continue;
            }
            if ("user_node_paths".equals(field)) {
                while (jp.nextToken() != JsonToken.END_ARRAY) {
                    userNodePaths.add(jp.getText());
                }
                continue;
            }
            System.err.println("Unrecognized JSON field '" + field + "'");
        }
        jp.close();
        callback.onSuccess(new U1User(resourcePath, userId, visibleName, maxBytes, usedBytes, rootNodePath, userNodePaths));
    }
}

