/*
 * Decompiled with CFR 0.152.
 */
package com.ubuntuone.api.files.json;

import com.ubuntuone.api.files.json.U1NodeJson;
import com.ubuntuone.api.files.model.U1Node;
import com.ubuntuone.api.files.model.U1Resource;
import com.ubuntuone.api.files.model.U1Volume;
import com.ubuntuone.api.files.util.U1RequestListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Date;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class U1VolumeJson {
    public static String toJson(U1Volume ... volumes) throws JsonGenerationException, IOException {
        JsonFactory factory = new JsonFactory();
        StringWriter writer = new StringWriter(128);
        JsonGenerator g = factory.createJsonGenerator((Writer)writer);
        g.writeStartArray();
        for (U1Volume volume : volumes) {
            g.writeStartObject();
            g.writeStringField("resource_path", volume.getResourcePath());
            g.writeStringField("type", volume.getType());
            g.writeStringField("path", volume.getPath());
            g.writeNumberField("generation", volume.getGeneration().longValue());
            g.writeStringField("when_created", U1Resource.simpleDateFormat.format(volume.getWhenCreated()));
            g.writeStringField("node_path", volume.getNodePath());
            g.writeStringField("content_path", volume.getContentPath());
            if (volume.getFromGeneration() != -1L) {
                g.writeObjectFieldStart("delta");
                g.writeNumberField("from_generation", volume.getFromGeneration().longValue());
                g.writeArrayFieldStart("nodes");
                boolean first = true;
                for (U1Node node : volume.getDeltaNodes()) {
                    if (first) {
                        first = false;
                    } else {
                        g.writeRaw(",");
                    }
                    g.writeRaw(U1NodeJson.toJson(node));
                }
                g.writeEndArray();
                g.writeEndObject();
            }
            g.writeEndObject();
        }
        g.writeEndArray();
        g.close();
        return writer.toString();
    }

    public static void fromJson(InputStream stream, U1RequestListener<U1Volume> callback) throws JsonParseException, IOException {
        JsonFactory factory = new JsonFactory();
        JsonParser jp = factory.createJsonParser(stream);
        while (true) {
            String resourcePath = null;
            String type = null;
            String path = null;
            Long generation = null;
            Date whenCreated = null;
            String nodePath = null;
            String contentPath = null;
            JsonToken token = jp.nextToken();
            if (token == null || JsonToken.END_ARRAY == token) break;
            if (JsonToken.START_ARRAY == token) continue;
            if (JsonToken.START_OBJECT != token) {
                throw new JsonParseException("Expected JsonToken.START_OBJECT", null);
            }
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String field = jp.getCurrentName();
                jp.nextToken();
                if ("resource_path".equals(field)) {
                    resourcePath = jp.getText();
                    continue;
                }
                if ("type".equals(field)) {
                    type = jp.getText();
                    continue;
                }
                if ("path".equals(field)) {
                    path = jp.getText();
                    continue;
                }
                if ("generation".equals(field)) {
                    generation = jp.getLongValue();
                    continue;
                }
                if ("when_created".equals(field)) {
                    try {
                        whenCreated = U1Resource.simpleDateFormat.parse(jp.getText());
                        continue;
                    }
                    catch (ParseException e) {
                        throw new JsonParseException("Incorrect date format", null);
                    }
                }
                if ("node_path".equals(field)) {
                    nodePath = jp.getText();
                    continue;
                }
                if ("content_path".equals(field)) {
                    contentPath = jp.getText();
                    continue;
                }
                System.err.println("Unrecognized JSON field '" + field + "'");
            }
            callback.onSuccess(new U1Volume(resourcePath, type, path, generation, whenCreated, nodePath, contentPath, -1L, null));
        }
        jp.close();
    }
}

