/*
 * Decompiled with CFR 0.152.
 */
package com.ubuntuone.api.files.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class HashUtils {
    private static final String SHA1 = "SHA-1";
    private static final int CHUNK_SIZE = 8192;

    private HashUtils() {
    }

    public static String getSha1(InputStream stream) throws IOException {
        MessageDigest dataDigest;
        try {
            dataDigest = MessageDigest.getInstance(SHA1);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("SHA-1 algorithm not available.");
        }
        dataDigest.reset();
        byte[] data = new byte[8192];
        int n = 0;
        while ((n = stream.read(data)) != -1) {
            dataDigest.update(data, 0, n);
        }
        byte[] digest = dataDigest.digest();
        return HashUtils.toHexString(digest);
    }

    public static String getSha1(File file) throws IOException {
        return HashUtils.getSha1(new FileInputStream(file));
    }

    public static String getSha1(String data) {
        MessageDigest dataDigest;
        try {
            dataDigest = MessageDigest.getInstance(SHA1);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("SHA-1 algorithm not available.");
        }
        dataDigest.reset();
        dataDigest.update(data.getBytes());
        byte[] digest = dataDigest.digest();
        return HashUtils.toHexString(digest);
    }

    public static U1Hashes getU1Hashes(InputStream stream) throws IOException {
        MessageDigest magicDigest;
        MessageDigest dataDigest;
        try {
            dataDigest = MessageDigest.getInstance(SHA1);
            magicDigest = MessageDigest.getInstance(SHA1);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("SHA-1 algorithm not available.");
        }
        dataDigest.reset();
        magicDigest.reset();
        magicDigest.update("Ubuntu One".getBytes("UTF-8"));
        byte[] data = new byte[8192];
        int n = 0;
        while ((n = stream.read(data)) != -1) {
            dataDigest.update(data, 0, n);
            magicDigest.update(data, 0, n);
        }
        byte[] digestBytes = dataDigest.digest();
        byte[] magicBytes = magicDigest.digest();
        String hash = HashUtils.toHexString(digestBytes);
        String magicHash = HashUtils.toHexString(magicBytes);
        return new U1Hashes(hash, magicHash);
    }

    private static String toHexString(byte[] data) {
        StringBuilder sha1 = new StringBuilder(46);
        sha1.append("sha1:");
        for (int i = 0; i < data.length; ++i) {
            sha1.append(Integer.toHexString((0xFF & data[i]) + 256).substring(1));
        }
        return sha1.toString();
    }

    public static class U1Hashes {
        public final String hash;
        public final String magicHash;

        public U1Hashes(String hash, String magicHash) {
            this.hash = hash;
            this.magicHash = magicHash;
        }
    }
}

