/*
 * Decompiled with CFR 0.152.
 */
package com.ubuntuone.api.files.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;

public interface U1OnProgressListener {
    public static final long PROGRESS_INTERVAL = 400L;

    public void onProgress(long var1, long var3);

    public static class DummyListener
    implements U1OnProgressListener {
        @Override
        public void onProgress(long bytes, long total) {
        }
    }

    public static class ProgressInputStream {
        private static final int CHUNK_SIZE = 8192;
        private InputStream stream;
        private long bytes;
        private long length;
        private U1OnProgressListener listener;

        public ProgressInputStream(InputStream stream, long bytes, long length, U1OnProgressListener listener) {
            this.stream = stream;
            this.bytes = bytes;
            this.length = length;
            this.listener = listener != null ? listener : new DummyListener();
        }

        public void writeTo(OutputStream out) throws IllegalStateException, IOException {
            long lastCallback = 0L;
            long now = 0L;
            byte[] buffer = new byte[8192];
            long total = this.bytes;
            int bytes = 0;
            while ((bytes = this.stream.read(buffer, 0, 8192)) >= 0) {
                out.write(buffer, 0, bytes);
                total += (long)bytes;
                now = System.currentTimeMillis();
                if (now - lastCallback < this.getProgressInterval()) continue;
                this.listener.onProgress(total, this.length);
                lastCallback = now;
            }
            if (total == this.length) {
                this.listener.onProgress(total, this.length);
            }
            out.flush();
            out.close();
            this.stream.close();
        }

        public long getProgressInterval() {
            return 400L;
        }
    }

    public static class ProgressHttpEntity
    extends HttpEntityWrapper {
        private static final int CHUNK_SIZE = 8192;
        private HttpEntity entity;
        private U1OnProgressListener listener;

        public ProgressHttpEntity(HttpEntity entity, U1OnProgressListener listener) {
            super(entity);
            this.entity = entity;
            this.listener = listener != null ? listener : new DummyListener();
        }

        public void writeTo(OutputStream out) throws IllegalStateException, IOException {
            InputStream in = this.entity.getContent();
            long lastCallback = 0L;
            long now = 0L;
            byte[] buffer = new byte[8192];
            long length = this.entity.getContentLength();
            long total = 0L;
            int bytes = 0;
            while ((bytes = in.read(buffer, 0, 8192)) >= 0) {
                out.write(buffer, 0, bytes);
                total += (long)bytes;
                now = System.currentTimeMillis();
                if (now - lastCallback < this.getProgressInterval()) continue;
                this.listener.onProgress(total, length);
                lastCallback = now;
            }
            if (total == length) {
                this.listener.onProgress(total, length);
            }
            out.flush();
            out.close();
            in.close();
        }

        public long getProgressInterval() {
            return 400L;
        }
    }
}

