/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.URL;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.Versioned;
import org.codehaus.jackson.format.InputAccessor;
import org.codehaus.jackson.format.MatchStrength;
import org.codehaus.jackson.impl.ByteSourceBootstrapper;
import org.codehaus.jackson.impl.ReaderBasedParser;
import org.codehaus.jackson.impl.Utf8Generator;
import org.codehaus.jackson.impl.WriterBasedGenerator;
import org.codehaus.jackson.io.CharacterEscapes;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.io.InputDecorator;
import org.codehaus.jackson.io.OutputDecorator;
import org.codehaus.jackson.io.UTF8Writer;
import org.codehaus.jackson.sym.BytesToNameCanonicalizer;
import org.codehaus.jackson.sym.CharsToNameCanonicalizer;
import org.codehaus.jackson.util.BufferRecycler;
import org.codehaus.jackson.util.VersionUtil;

public class JsonFactory
implements Versioned {
    public static final String FORMAT_NAME_JSON = "JSON";
    static final int DEFAULT_PARSER_FEATURE_FLAGS = JsonParser.Feature.collectDefaults();
    static final int DEFAULT_GENERATOR_FEATURE_FLAGS = JsonGenerator.Feature.collectDefaults();
    protected static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef = new ThreadLocal();
    protected CharsToNameCanonicalizer _rootCharSymbols = CharsToNameCanonicalizer.createRoot();
    protected BytesToNameCanonicalizer _rootByteSymbols = BytesToNameCanonicalizer.createRoot();
    protected ObjectCodec _objectCodec;
    protected int _parserFeatures = DEFAULT_PARSER_FEATURE_FLAGS;
    protected int _generatorFeatures = DEFAULT_GENERATOR_FEATURE_FLAGS;
    protected CharacterEscapes _characterEscapes;
    protected InputDecorator _inputDecorator;
    protected OutputDecorator _outputDecorator;

    public JsonFactory() {
        this(null);
    }

    public JsonFactory(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    public String getFormatName() {
        if (this.getClass() == JsonFactory.class) {
            return FORMAT_NAME_JSON;
        }
        return null;
    }

    public MatchStrength hasFormat(InputAccessor inputAccessor) throws IOException {
        if (this.getClass() == JsonFactory.class) {
            return this.hasJSONFormat(inputAccessor);
        }
        return null;
    }

    protected MatchStrength hasJSONFormat(InputAccessor inputAccessor) throws IOException {
        return ByteSourceBootstrapper.hasJSONFormat(inputAccessor);
    }

    public Version version() {
        return VersionUtil.versionFor(Utf8Generator.class);
    }

    public final JsonFactory configure(JsonParser.Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public JsonFactory enable(JsonParser.Feature feature) {
        this._parserFeatures |= feature.getMask();
        return this;
    }

    public JsonFactory disable(JsonParser.Feature feature) {
        this._parserFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(JsonParser.Feature feature) {
        return (this._parserFeatures & feature.getMask()) != 0;
    }

    public final void enableParserFeature(JsonParser.Feature feature) {
        this.enable(feature);
    }

    public final void disableParserFeature(JsonParser.Feature feature) {
        this.disable(feature);
    }

    public final void setParserFeature(JsonParser.Feature feature, boolean bl) {
        this.configure(feature, bl);
    }

    public final boolean isParserFeatureEnabled(JsonParser.Feature feature) {
        return (this._parserFeatures & feature.getMask()) != 0;
    }

    public InputDecorator getInputDecorator() {
        return this._inputDecorator;
    }

    public JsonFactory setInputDecorator(InputDecorator inputDecorator) {
        this._inputDecorator = inputDecorator;
        return this;
    }

    public final JsonFactory configure(JsonGenerator.Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public JsonFactory enable(JsonGenerator.Feature feature) {
        this._generatorFeatures |= feature.getMask();
        return this;
    }

    public JsonFactory disable(JsonGenerator.Feature feature) {
        this._generatorFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(JsonGenerator.Feature feature) {
        return (this._generatorFeatures & feature.getMask()) != 0;
    }

    @Deprecated
    public final void enableGeneratorFeature(JsonGenerator.Feature feature) {
        this.enable(feature);
    }

    @Deprecated
    public final void disableGeneratorFeature(JsonGenerator.Feature feature) {
        this.disable(feature);
    }

    @Deprecated
    public final void setGeneratorFeature(JsonGenerator.Feature feature, boolean bl) {
        this.configure(feature, bl);
    }

    @Deprecated
    public final boolean isGeneratorFeatureEnabled(JsonGenerator.Feature feature) {
        return this.isEnabled(feature);
    }

    public CharacterEscapes getCharacterEscapes() {
        return this._characterEscapes;
    }

    public JsonFactory setCharacterEscapes(CharacterEscapes characterEscapes) {
        this._characterEscapes = characterEscapes;
        return this;
    }

    public OutputDecorator getOutputDecorator() {
        return this._outputDecorator;
    }

    public JsonFactory setOutputDecorator(OutputDecorator outputDecorator) {
        this._outputDecorator = outputDecorator;
        return this;
    }

    public JsonFactory setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        return this;
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public JsonParser createJsonParser(File file) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(file, true);
        InputStream inputStream = new FileInputStream(file);
        if (this._inputDecorator != null) {
            inputStream = this._inputDecorator.decorate(iOContext, inputStream);
        }
        return this._createJsonParser(inputStream, iOContext);
    }

    public JsonParser createJsonParser(URL uRL) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(uRL, true);
        InputStream inputStream = this._optimizedStreamFromURL(uRL);
        if (this._inputDecorator != null) {
            inputStream = this._inputDecorator.decorate(iOContext, inputStream);
        }
        return this._createJsonParser(inputStream, iOContext);
    }

    public JsonParser createJsonParser(InputStream inputStream) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(inputStream, false);
        if (this._inputDecorator != null) {
            inputStream = this._inputDecorator.decorate(iOContext, inputStream);
        }
        return this._createJsonParser(inputStream, iOContext);
    }

    public JsonParser createJsonParser(Reader reader) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(reader, false);
        if (this._inputDecorator != null) {
            reader = this._inputDecorator.decorate(iOContext, reader);
        }
        return this._createJsonParser(reader, iOContext);
    }

    public JsonParser createJsonParser(byte[] byArray) throws IOException, JsonParseException {
        InputStream inputStream;
        IOContext iOContext = this._createContext(byArray, true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, 0, byArray.length)) != null) {
            return this._createJsonParser(inputStream, iOContext);
        }
        return this._createJsonParser(byArray, 0, byArray.length, iOContext);
    }

    public JsonParser createJsonParser(byte[] byArray, int n, int n2) throws IOException, JsonParseException {
        InputStream inputStream;
        IOContext iOContext = this._createContext(byArray, true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, n, n2)) != null) {
            return this._createJsonParser(inputStream, iOContext);
        }
        return this._createJsonParser(byArray, n, n2, iOContext);
    }

    public JsonParser createJsonParser(String string) throws IOException, JsonParseException {
        Reader reader = new StringReader(string);
        IOContext iOContext = this._createContext(reader, true);
        if (this._inputDecorator != null) {
            reader = this._inputDecorator.decorate(iOContext, reader);
        }
        return this._createJsonParser(reader, iOContext);
    }

    public JsonGenerator createJsonGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        IOContext iOContext = this._createContext(outputStream, false);
        iOContext.setEncoding(jsonEncoding);
        if (jsonEncoding == JsonEncoding.UTF8) {
            if (this._outputDecorator != null) {
                outputStream = this._outputDecorator.decorate(iOContext, outputStream);
            }
            return this._createUTF8JsonGenerator(outputStream, iOContext);
        }
        Writer writer = this._createWriter(outputStream, jsonEncoding, iOContext);
        if (this._outputDecorator != null) {
            writer = this._outputDecorator.decorate(iOContext, writer);
        }
        return this._createJsonGenerator(writer, iOContext);
    }

    public JsonGenerator createJsonGenerator(Writer writer) throws IOException {
        IOContext iOContext = this._createContext(writer, false);
        if (this._outputDecorator != null) {
            writer = this._outputDecorator.decorate(iOContext, writer);
        }
        return this._createJsonGenerator(writer, iOContext);
    }

    public JsonGenerator createJsonGenerator(OutputStream outputStream) throws IOException {
        return this.createJsonGenerator(outputStream, JsonEncoding.UTF8);
    }

    public JsonGenerator createJsonGenerator(File file, JsonEncoding jsonEncoding) throws IOException {
        OutputStream outputStream = new FileOutputStream(file);
        IOContext iOContext = this._createContext(outputStream, true);
        iOContext.setEncoding(jsonEncoding);
        if (jsonEncoding == JsonEncoding.UTF8) {
            if (this._outputDecorator != null) {
                outputStream = this._outputDecorator.decorate(iOContext, outputStream);
            }
            return this._createUTF8JsonGenerator(outputStream, iOContext);
        }
        Writer writer = this._createWriter(outputStream, jsonEncoding, iOContext);
        if (this._outputDecorator != null) {
            writer = this._outputDecorator.decorate(iOContext, writer);
        }
        return this._createJsonGenerator(writer, iOContext);
    }

    protected JsonParser _createJsonParser(InputStream inputStream, IOContext iOContext) throws IOException, JsonParseException {
        return new ByteSourceBootstrapper(iOContext, inputStream).constructParser(this._parserFeatures, this._objectCodec, this._rootByteSymbols, this._rootCharSymbols);
    }

    protected JsonParser _createJsonParser(Reader reader, IOContext iOContext) throws IOException, JsonParseException {
        return new ReaderBasedParser(iOContext, this._parserFeatures, reader, this._objectCodec, this._rootCharSymbols.makeChild(this.isEnabled(JsonParser.Feature.CANONICALIZE_FIELD_NAMES), this.isEnabled(JsonParser.Feature.INTERN_FIELD_NAMES)));
    }

    protected JsonParser _createJsonParser(byte[] byArray, int n, int n2, IOContext iOContext) throws IOException, JsonParseException {
        return new ByteSourceBootstrapper(iOContext, byArray, n, n2).constructParser(this._parserFeatures, this._objectCodec, this._rootByteSymbols, this._rootCharSymbols);
    }

    protected JsonGenerator _createJsonGenerator(Writer writer, IOContext iOContext) throws IOException {
        WriterBasedGenerator writerBasedGenerator = new WriterBasedGenerator(iOContext, this._generatorFeatures, this._objectCodec, writer);
        if (this._characterEscapes != null) {
            writerBasedGenerator.setCharacterEscapes(this._characterEscapes);
        }
        return writerBasedGenerator;
    }

    protected JsonGenerator _createUTF8JsonGenerator(OutputStream outputStream, IOContext iOContext) throws IOException {
        Utf8Generator utf8Generator = new Utf8Generator(iOContext, this._generatorFeatures, this._objectCodec, outputStream);
        if (this._characterEscapes != null) {
            utf8Generator.setCharacterEscapes(this._characterEscapes);
        }
        return utf8Generator;
    }

    protected Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        if (jsonEncoding == JsonEncoding.UTF8) {
            return new UTF8Writer(iOContext, outputStream);
        }
        return new OutputStreamWriter(outputStream, jsonEncoding.getJavaName());
    }

    protected IOContext _createContext(Object object, boolean bl) {
        return new IOContext(this._getBufferRecycler(), object, bl);
    }

    public BufferRecycler _getBufferRecycler() {
        BufferRecycler bufferRecycler;
        SoftReference<BufferRecycler> softReference = _recyclerRef.get();
        BufferRecycler bufferRecycler2 = bufferRecycler = softReference == null ? null : softReference.get();
        if (bufferRecycler == null) {
            bufferRecycler = new BufferRecycler();
            _recyclerRef.set(new SoftReference<BufferRecycler>(bufferRecycler));
        }
        return bufferRecycler;
    }

    protected InputStream _optimizedStreamFromURL(URL uRL) throws IOException {
        String string;
        if ("file".equals(uRL.getProtocol()) && ((string = uRL.getHost()) == null || string.length() == 0)) {
            return new FileInputStream(uRL.getPath());
        }
        return uRL.openStream();
    }
}

