/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.format;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.format.DataFormatMatcher;
import org.codehaus.jackson.format.MatchStrength;

public interface InputAccessor {
    public boolean hasMoreBytes() throws IOException;

    public byte nextByte() throws IOException;

    public void reset();

    public static class Std
    implements InputAccessor {
        protected final InputStream _in;
        protected final byte[] _buffer;
        protected int _bufferedAmount;
        protected int _ptr;

        public Std(InputStream inputStream, byte[] byArray) {
            this._in = inputStream;
            this._buffer = byArray;
            this._bufferedAmount = 0;
        }

        public Std(byte[] byArray) {
            this._in = null;
            this._buffer = byArray;
            this._bufferedAmount = byArray.length;
        }

        public boolean hasMoreBytes() throws IOException {
            if (this._ptr < this._bufferedAmount) {
                return true;
            }
            int n = this._buffer.length - this._ptr;
            if (n < 1) {
                return false;
            }
            int n2 = this._in.read(this._buffer, this._ptr, n);
            if (n2 <= 0) {
                return false;
            }
            this._bufferedAmount += n2;
            return true;
        }

        public byte nextByte() throws IOException {
            if (this._ptr > -this._bufferedAmount && !this.hasMoreBytes()) {
                throw new EOFException("Could not read more than " + this._ptr + " bytes (max buffer size: " + this._buffer.length + ")");
            }
            return this._buffer[this._ptr++];
        }

        public void reset() {
            this._ptr = 0;
        }

        public DataFormatMatcher createMatcher(JsonFactory jsonFactory, MatchStrength matchStrength) {
            return new DataFormatMatcher(this._in, this._buffer, this._bufferedAmount, jsonFactory, matchStrength);
        }
    }
}

