/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.codehaus.jackson.Base64Variant;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.SerializableString;
import org.codehaus.jackson.impl.JsonGeneratorBase;
import org.codehaus.jackson.impl.JsonWriteContext;
import org.codehaus.jackson.io.CharacterEscapes;
import org.codehaus.jackson.io.IOContext;
import org.codehaus.jackson.io.NumberOutput;
import org.codehaus.jackson.io.SerializedString;
import org.codehaus.jackson.util.CharTypes;

public final class WriterBasedGenerator
extends JsonGeneratorBase {
    protected static final int SHORT_WRITE = 32;
    protected static final char[] HEX_CHARS = CharTypes.copyHexChars();
    protected static final int[] sOutputEscapes = CharTypes.get7BitOutputEscapes();
    protected final IOContext _ioContext;
    protected final Writer _writer;
    protected int[] _outputEscapes = sOutputEscapes;
    protected int _maximumNonEscapedChar;
    protected CharacterEscapes _characterEscapes;
    protected SerializableString _currentEscape;
    protected char[] _outputBuffer;
    protected int _outputHead = 0;
    protected int _outputTail = 0;
    protected int _outputEnd;
    protected char[] _entityBuffer;

    public WriterBasedGenerator(IOContext iOContext, int n, ObjectCodec objectCodec, Writer writer) {
        super(n, objectCodec);
        this._ioContext = iOContext;
        this._writer = writer;
        this._outputBuffer = iOContext.allocConcatBuffer();
        this._outputEnd = this._outputBuffer.length;
        if (this.isEnabled(JsonGenerator.Feature.ESCAPE_NON_ASCII)) {
            this.setHighestNonEscapedChar(127);
        }
    }

    public JsonGenerator setHighestNonEscapedChar(int n) {
        this._maximumNonEscapedChar = n < 0 ? 0 : n;
        return this;
    }

    public int getHighestEscapedChar() {
        return this._maximumNonEscapedChar;
    }

    public JsonGenerator setCharacterEscapes(CharacterEscapes characterEscapes) {
        this._characterEscapes = characterEscapes;
        this._outputEscapes = characterEscapes == null ? sOutputEscapes : characterEscapes.getEscapeCodesForAscii();
        return this;
    }

    public CharacterEscapes getCharacterEscapes() {
        return this._characterEscapes;
    }

    public Object getOutputTarget() {
        return this._writer;
    }

    public final void writeFieldName(String string) throws IOException, JsonGenerationException {
        int n = this._writeContext.writeFieldName(string);
        if (n == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(string, n == 1);
    }

    public final void writeStringField(String string, String string2) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeString(string2);
    }

    public final void writeFieldName(SerializedString serializedString) throws IOException, JsonGenerationException {
        int n = this._writeContext.writeFieldName(serializedString.getValue());
        if (n == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(serializedString, n == 1);
    }

    public final void writeFieldName(SerializableString serializableString) throws IOException, JsonGenerationException {
        int n = this._writeContext.writeFieldName(serializableString.getValue());
        if (n == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(serializableString, n == 1);
    }

    public final void writeStartArray() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 91;
        }
    }

    public final void writeEndArray() throws IOException, JsonGenerationException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndArray(this, this._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 93;
        }
        this._writeContext = this._writeContext.getParent();
    }

    public final void writeStartObject() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 123;
        }
    }

    public final void writeEndObject() throws IOException, JsonGenerationException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeEndObject(this, this._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 125;
        }
    }

    protected void _writeFieldName(String string, boolean bl) throws IOException, JsonGenerationException {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(string, bl);
            return;
        }
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (bl) {
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (!this.isEnabled(JsonGenerator.Feature.QUOTE_FIELD_NAMES)) {
            this._writeString(string);
            return;
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeString(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    public void _writeFieldName(SerializableString serializableString, boolean bl) throws IOException, JsonGenerationException {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(serializableString, bl);
            return;
        }
        if (this._outputTail + 1 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (bl) {
            this._outputBuffer[this._outputTail++] = 44;
        }
        char[] cArray = serializableString.asQuotedChars();
        if (!this.isEnabled(JsonGenerator.Feature.QUOTE_FIELD_NAMES)) {
            this.writeRaw(cArray, 0, cArray.length);
            return;
        }
        this._outputBuffer[this._outputTail++] = 34;
        int n = cArray.length;
        if (this._outputTail + n + 1 >= this._outputEnd) {
            this.writeRaw(cArray, 0, n);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
        } else {
            System.arraycopy(cArray, 0, this._outputBuffer, this._outputTail, n);
            this._outputTail += n;
            this._outputBuffer[this._outputTail++] = 34;
        }
    }

    protected final void _writePPFieldName(String string, boolean bl) throws IOException, JsonGenerationException {
        if (bl) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if (this.isEnabled(JsonGenerator.Feature.QUOTE_FIELD_NAMES)) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
            this._writeString(string);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
        } else {
            this._writeString(string);
        }
    }

    protected final void _writePPFieldName(SerializableString serializableString, boolean bl) throws IOException, JsonGenerationException {
        if (bl) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        char[] cArray = serializableString.asQuotedChars();
        if (this.isEnabled(JsonGenerator.Feature.QUOTE_FIELD_NAMES)) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
            this.writeRaw(cArray, 0, cArray.length);
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 34;
        } else {
            this.writeRaw(cArray, 0, cArray.length);
        }
    }

    public void writeString(String string) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write text value");
        if (string == null) {
            this._writeNull();
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeString(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    public void writeString(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write text value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeString(cArray, n, n2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    public final void writeString(SerializableString serializableString) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write text value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        char[] cArray = serializableString.asQuotedChars();
        int n = cArray.length;
        if (n < 32) {
            int n2 = this._outputEnd - this._outputTail;
            if (n > n2) {
                this._flushBuffer();
            }
            System.arraycopy(cArray, 0, this._outputBuffer, this._outputTail, n);
            this._outputTail += n;
        } else {
            this._flushBuffer();
            this._writer.write(cArray, 0, n);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    public void writeRawUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeUTF8String(byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(String string) throws IOException, JsonGenerationException {
        int n = string.length();
        int n2 = this._outputEnd - this._outputTail;
        if (n2 == 0) {
            this._flushBuffer();
            n2 = this._outputEnd - this._outputTail;
        }
        if (n2 >= n) {
            string.getChars(0, n, this._outputBuffer, this._outputTail);
            this._outputTail += n;
        } else {
            this.writeRawLong(string);
        }
    }

    public void writeRaw(String string, int n, int n2) throws IOException, JsonGenerationException {
        int n3 = this._outputEnd - this._outputTail;
        if (n3 < n2) {
            this._flushBuffer();
            n3 = this._outputEnd - this._outputTail;
        }
        if (n3 >= n2) {
            string.getChars(n, n + n2, this._outputBuffer, this._outputTail);
            this._outputTail += n2;
        } else {
            this.writeRawLong(string.substring(n, n + n2));
        }
    }

    public void writeRaw(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        if (n2 < 32) {
            int n3 = this._outputEnd - this._outputTail;
            if (n2 > n3) {
                this._flushBuffer();
            }
            System.arraycopy(cArray, n, this._outputBuffer, this._outputTail, n2);
            this._outputTail += n2;
            return;
        }
        this._flushBuffer();
        this._writer.write(cArray, n, n2);
    }

    public void writeRaw(char c) throws IOException, JsonGenerationException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = c;
    }

    private void writeRawLong(String string) throws IOException, JsonGenerationException {
        int n;
        int n2;
        int n3 = this._outputEnd - this._outputTail;
        string.getChars(0, n3, this._outputBuffer, this._outputTail);
        this._outputTail += n3;
        this._flushBuffer();
        int n4 = n3;
        for (n = string.length() - n3; n > this._outputEnd; n -= n2) {
            n2 = this._outputEnd;
            string.getChars(n4, n4 + n2, this._outputBuffer, 0);
            this._outputHead = 0;
            this._outputTail = n2;
            this._flushBuffer();
            n4 += n2;
        }
        string.getChars(n4, n4 + n, this._outputBuffer, 0);
        this._outputHead = 0;
        this._outputTail = n;
    }

    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._writeBinary(base64Variant, byArray, n, n + n2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    public void writeNumber(int n) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedInt(n);
            return;
        }
        if (this._outputTail + 11 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputInt(n, this._outputBuffer, this._outputTail);
    }

    private final void _writeQuotedInt(int n) throws IOException {
        if (this._outputTail + 13 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._outputTail = NumberOutput.outputInt(n, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = 34;
    }

    public void writeNumber(long l) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedLong(l);
            return;
        }
        if (this._outputTail + 21 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputLong(l, this._outputBuffer, this._outputTail);
    }

    private final void _writeQuotedLong(long l) throws IOException {
        if (this._outputTail + 23 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this._outputTail = NumberOutput.outputLong(l, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = 34;
    }

    public void writeNumber(BigInteger bigInteger) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (bigInteger == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigInteger);
        } else {
            this.writeRaw(bigInteger.toString());
        }
    }

    public void writeNumber(double d) throws IOException, JsonGenerationException {
        if (this._cfgNumbersAsStrings || (Double.isNaN(d) || Double.isInfinite(d)) && this.isEnabled(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS)) {
            this.writeString(String.valueOf(d));
            return;
        }
        this._verifyValueWrite("write number");
        this.writeRaw(String.valueOf(d));
    }

    public void writeNumber(float f) throws IOException, JsonGenerationException {
        if (this._cfgNumbersAsStrings || (Float.isNaN(f) || Float.isInfinite(f)) && this.isEnabled(JsonGenerator.Feature.QUOTE_NON_NUMERIC_NUMBERS)) {
            this.writeString(String.valueOf(f));
            return;
        }
        this._verifyValueWrite("write number");
        this.writeRaw(String.valueOf(f));
    }

    public void writeNumber(BigDecimal bigDecimal) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (bigDecimal == null) {
            this._writeNull();
        } else if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigDecimal);
        } else {
            this.writeRaw(bigDecimal.toString());
        }
    }

    public void writeNumber(String string) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(string);
        } else {
            this.writeRaw(string);
        }
    }

    private final void _writeQuotedRaw(Object object) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
        this.writeRaw(object.toString());
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 34;
    }

    public void writeBoolean(boolean bl) throws IOException, JsonGenerationException {
        this._verifyValueWrite("write boolean value");
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        int n = this._outputTail;
        char[] cArray = this._outputBuffer;
        if (bl) {
            cArray[n] = 116;
            cArray[++n] = 114;
            cArray[++n] = 117;
            cArray[++n] = 101;
        } else {
            cArray[n] = 102;
            cArray[++n] = 97;
            cArray[++n] = 108;
            cArray[++n] = 115;
            cArray[++n] = 101;
        }
        this._outputTail = n + 1;
    }

    public void writeNull() throws IOException, JsonGenerationException {
        this._verifyValueWrite("write null value");
        this._writeNull();
    }

    protected final void _verifyValueWrite(String string) throws IOException, JsonGenerationException {
        int n = this._writeContext.writeValue();
        if (n == 5) {
            this._reportError("Can not " + string + ", expecting field name");
        }
        if (this._cfgPrettyPrinter == null) {
            int n2;
            switch (n) {
                case 1: {
                    n2 = 44;
                    break;
                }
                case 2: {
                    n2 = 58;
                    break;
                }
                case 3: {
                    n2 = 32;
                    break;
                }
                default: {
                    return;
                }
            }
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail] = n2;
            ++this._outputTail;
            return;
        }
        this._verifyPrettyValueWrite(string, n);
    }

    protected final void _verifyPrettyValueWrite(String string, int n) throws IOException, JsonGenerationException {
        switch (n) {
            case 1: {
                this._cfgPrettyPrinter.writeArrayValueSeparator(this);
                break;
            }
            case 2: {
                this._cfgPrettyPrinter.writeObjectFieldValueSeparator(this);
                break;
            }
            case 3: {
                this._cfgPrettyPrinter.writeRootValueSeparator(this);
                break;
            }
            case 0: {
                if (this._writeContext.inArray()) {
                    this._cfgPrettyPrinter.beforeArrayValues(this);
                    break;
                }
                if (!this._writeContext.inObject()) break;
                this._cfgPrettyPrinter.beforeObjectEntries(this);
                break;
            }
            default: {
                this._cantHappen();
            }
        }
    }

    public final void flush() throws IOException {
        this._flushBuffer();
        if (this._writer != null && this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
            this._writer.flush();
        }
    }

    public void close() throws IOException {
        super.close();
        if (this._outputBuffer != null && this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (true) {
                JsonWriteContext jsonWriteContext;
                if ((jsonWriteContext = this.getOutputContext()).inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!jsonWriteContext.inObject()) break;
                this.writeEndObject();
            }
        }
        this._flushBuffer();
        if (this._writer != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
                this._writer.close();
            } else if (this.isEnabled(JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM)) {
                this._writer.flush();
            }
        }
        this._releaseBuffers();
    }

    protected void _releaseBuffers() {
        char[] cArray = this._outputBuffer;
        if (cArray != null) {
            this._outputBuffer = null;
            this._ioContext.releaseConcatBuffer(cArray);
        }
    }

    private void _writeString(String string) throws IOException, JsonGenerationException {
        int n = string.length();
        if (n > this._outputEnd) {
            this._writeLongString(string);
            return;
        }
        if (this._outputTail + n > this._outputEnd) {
            this._flushBuffer();
        }
        string.getChars(0, n, this._outputBuffer, this._outputTail);
        if (this._characterEscapes != null) {
            this._writeStringCustom(n);
        } else if (this._maximumNonEscapedChar != 0) {
            this._writeStringASCII(n, this._maximumNonEscapedChar);
        } else {
            this._writeString2(n);
        }
    }

    private void _writeString2(int n) throws IOException, JsonGenerationException {
        int n2 = this._outputTail + n;
        int[] nArray = this._outputEscapes;
        int n3 = nArray.length;
        block0: while (this._outputTail < n2) {
            int n4;
            while ((n4 = this._outputBuffer[this._outputTail]) >= n3 || nArray[n4] == 0) {
                if (++this._outputTail < n2) continue;
                break block0;
            }
            n4 = this._outputTail - this._outputHead;
            if (n4 > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, n4);
            }
            char c = this._outputBuffer[this._outputTail++];
            this._prependOrWriteCharacterEscape(c, nArray[c]);
        }
    }

    private void _writeLongString(String string) throws IOException, JsonGenerationException {
        int n;
        this._flushBuffer();
        int n2 = string.length();
        int n3 = 0;
        do {
            int n4;
            n = n3 + (n4 = this._outputEnd) > n2 ? n2 - n3 : n4;
            string.getChars(n3, n3 + n, this._outputBuffer, 0);
            if (this._characterEscapes != null) {
                this._writeSegmentCustom(n);
                continue;
            }
            if (this._maximumNonEscapedChar != 0) {
                this._writeSegmentASCII(n, this._maximumNonEscapedChar);
                continue;
            }
            this._writeSegment(n);
        } while ((n3 += n) < n2);
    }

    private final void _writeSegment(int n) throws IOException, JsonGenerationException {
        int n2;
        int[] nArray = this._outputEscapes;
        int n3 = nArray.length;
        int n4 = n2 = 0;
        while (n2 < n) {
            char c;
            while (((c = this._outputBuffer[n2]) >= n3 || nArray[c] == 0) && ++n2 < n) {
            }
            int n5 = n2 - n4;
            if (n5 > 0) {
                this._writer.write(this._outputBuffer, n4, n5);
                if (n2 >= n) break;
            }
            n4 = this._prependOrWriteCharacterEscape(this._outputBuffer, ++n2, n, c, nArray[c]);
        }
    }

    private final void _writeString(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        if (this._characterEscapes != null) {
            this._writeStringCustom(cArray, n, n2);
            return;
        }
        if (this._maximumNonEscapedChar != 0) {
            this._writeStringASCII(cArray, n, n2, this._maximumNonEscapedChar);
            return;
        }
        n2 += n;
        int[] nArray = this._outputEscapes;
        int n3 = nArray.length;
        while (n < n2) {
            int n4;
            int n5 = n;
            while (((n4 = cArray[n]) >= n3 || nArray[n4] == 0) && ++n < n2) {
            }
            n4 = n - n5;
            if (n4 < 32) {
                if (this._outputTail + n4 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n4 > 0) {
                    System.arraycopy(cArray, n5, this._outputBuffer, this._outputTail, n4);
                    this._outputTail += n4;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n5, n4);
            }
            if (n >= n2) break;
            char c = cArray[n++];
            this._appendCharacterEscape(c, nArray[c]);
        }
    }

    private void _writeStringASCII(int n, int n2) throws IOException, JsonGenerationException {
        int n3 = this._outputTail + n;
        int[] nArray = this._outputEscapes;
        int n4 = Math.min(nArray.length, this._maximumNonEscapedChar + 1);
        int n5 = 0;
        while (this._outputTail < n3) {
            char c;
            block5: {
                do {
                    if ((c = this._outputBuffer[this._outputTail]) < n4) {
                        n5 = nArray[c];
                        if (n5 == 0) continue;
                    } else {
                        if (c <= n2) continue;
                        n5 = -1;
                    }
                    break block5;
                } while (++this._outputTail < n3);
                break;
            }
            int n6 = this._outputTail - this._outputHead;
            if (n6 > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, n6);
            }
            ++this._outputTail;
            this._prependOrWriteCharacterEscape(c, n5);
        }
    }

    private final void _writeSegmentASCII(int n, int n2) throws IOException, JsonGenerationException {
        int[] nArray = this._outputEscapes;
        int n3 = Math.min(nArray.length, this._maximumNonEscapedChar + 1);
        int n4 = 0;
        int n5 = 0;
        int n6 = n4;
        while (n4 < n) {
            char c;
            do {
                if ((c = this._outputBuffer[n4]) < n3) {
                    n5 = nArray[c];
                    if (n5 == 0) continue;
                    break;
                }
                if (c <= n2) continue;
                n5 = -1;
                break;
            } while (++n4 < n);
            int n7 = n4 - n6;
            if (n7 > 0) {
                this._writer.write(this._outputBuffer, n6, n7);
                if (n4 >= n) break;
            }
            n6 = this._prependOrWriteCharacterEscape(this._outputBuffer, ++n4, n, c, n5);
        }
    }

    private final void _writeStringASCII(char[] cArray, int n, int n2, int n3) throws IOException, JsonGenerationException {
        n2 += n;
        int[] nArray = this._outputEscapes;
        int n4 = Math.min(nArray.length, n3 + 1);
        int n5 = 0;
        while (n < n2) {
            char c;
            int n6 = n;
            do {
                if ((c = cArray[n]) < n4) {
                    n5 = nArray[c];
                    if (n5 == 0) continue;
                    break;
                }
                if (c <= n3) continue;
                n5 = -1;
                break;
            } while (++n < n2);
            int n7 = n - n6;
            if (n7 < 32) {
                if (this._outputTail + n7 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n7 > 0) {
                    System.arraycopy(cArray, n6, this._outputBuffer, this._outputTail, n7);
                    this._outputTail += n7;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n6, n7);
            }
            if (n >= n2) break;
            ++n;
            this._appendCharacterEscape(c, n5);
        }
    }

    private void _writeStringCustom(int n) throws IOException, JsonGenerationException {
        int n2 = this._outputTail + n;
        int[] nArray = this._outputEscapes;
        int n3 = this._maximumNonEscapedChar < 1 ? 65535 : this._maximumNonEscapedChar;
        int n4 = Math.min(nArray.length, n3 + 1);
        int n5 = 0;
        CharacterEscapes characterEscapes = this._characterEscapes;
        while (this._outputTail < n2) {
            int n6;
            block7: {
                do {
                    if ((n6 = this._outputBuffer[this._outputTail]) < n4) {
                        n5 = nArray[n6];
                        if (n5 == 0) continue;
                    } else if (n6 > n3) {
                        n5 = -1;
                    } else {
                        this._currentEscape = characterEscapes.getEscapeSequence(n6);
                        if (this._currentEscape == null) continue;
                        n5 = -2;
                    }
                    break block7;
                } while (++this._outputTail < n2);
                break;
            }
            int n7 = this._outputTail - this._outputHead;
            if (n7 > 0) {
                this._writer.write(this._outputBuffer, this._outputHead, n7);
            }
            ++this._outputTail;
            this._prependOrWriteCharacterEscape((char)n6, n5);
        }
    }

    private final void _writeSegmentCustom(int n) throws IOException, JsonGenerationException {
        int[] nArray = this._outputEscapes;
        int n2 = this._maximumNonEscapedChar < 1 ? 65535 : this._maximumNonEscapedChar;
        int n3 = Math.min(nArray.length, this._maximumNonEscapedChar + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        int n4 = 0;
        int n5 = 0;
        int n6 = n4;
        while (n4 < n) {
            int n7;
            do {
                if ((n7 = this._outputBuffer[n4]) < n3) {
                    n5 = nArray[n7];
                    if (n5 == 0) continue;
                    break;
                }
                if (n7 > n2) {
                    n5 = -1;
                    break;
                }
                this._currentEscape = characterEscapes.getEscapeSequence(n7);
                if (this._currentEscape == null) continue;
                n5 = -2;
                break;
            } while (++n4 < n);
            int n8 = n4 - n6;
            if (n8 > 0) {
                this._writer.write(this._outputBuffer, n6, n8);
                if (n4 >= n) break;
            }
            n6 = this._prependOrWriteCharacterEscape(this._outputBuffer, ++n4, n, (char)n7, n5);
        }
    }

    private final void _writeStringCustom(char[] cArray, int n, int n2) throws IOException, JsonGenerationException {
        n2 += n;
        int[] nArray = this._outputEscapes;
        int n3 = this._maximumNonEscapedChar < 1 ? 65535 : this._maximumNonEscapedChar;
        int n4 = Math.min(nArray.length, n3 + 1);
        CharacterEscapes characterEscapes = this._characterEscapes;
        int n5 = 0;
        while (n < n2) {
            int n6;
            int n7 = n;
            do {
                if ((n6 = cArray[n]) < n4) {
                    n5 = nArray[n6];
                    if (n5 == 0) continue;
                    break;
                }
                if (n6 > n3) {
                    n5 = -1;
                    break;
                }
                this._currentEscape = characterEscapes.getEscapeSequence(n6);
                if (this._currentEscape == null) continue;
                n5 = -2;
                break;
            } while (++n < n2);
            int n8 = n - n7;
            if (n8 < 32) {
                if (this._outputTail + n8 > this._outputEnd) {
                    this._flushBuffer();
                }
                if (n8 > 0) {
                    System.arraycopy(cArray, n7, this._outputBuffer, this._outputTail, n8);
                    this._outputTail += n8;
                }
            } else {
                this._flushBuffer();
                this._writer.write(cArray, n7, n8);
            }
            if (n >= n2) break;
            ++n;
            this._appendCharacterEscape((char)n6, n5);
        }
    }

    protected void _writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) throws IOException, JsonGenerationException {
        int n3;
        int n4 = n2 - 3;
        int n5 = this._outputEnd - 6;
        int n6 = base64Variant.getMaxLineLength() >> 2;
        while (n <= n4) {
            if (this._outputTail > n5) {
                this._flushBuffer();
            }
            n3 = byArray[n++] << 8;
            n3 |= byArray[n++] & 0xFF;
            n3 = n3 << 8 | byArray[n++] & 0xFF;
            this._outputTail = base64Variant.encodeBase64Chunk(n3, this._outputBuffer, this._outputTail);
            if (--n6 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n6 = base64Variant.getMaxLineLength() >> 2;
        }
        n3 = n2 - n;
        if (n3 > 0) {
            if (this._outputTail > n5) {
                this._flushBuffer();
            }
            int n7 = byArray[n++] << 16;
            if (n3 == 2) {
                n7 |= (byArray[n++] & 0xFF) << 8;
            }
            this._outputTail = base64Variant.encodeBase64Partial(n7, n3, this._outputBuffer, this._outputTail);
        }
    }

    private final void _writeNull() throws IOException {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        int n = this._outputTail;
        char[] cArray = this._outputBuffer;
        cArray[n] = 110;
        cArray[++n] = 117;
        cArray[++n] = 108;
        cArray[++n] = 108;
        this._outputTail = n + 1;
    }

    private final void _prependOrWriteCharacterEscape(char c, int n) throws IOException, JsonGenerationException {
        String string;
        if (n >= 0) {
            if (this._outputTail >= 2) {
                int n2;
                this._outputHead = n2 = this._outputTail - 2;
                this._outputBuffer[n2++] = 92;
                this._outputBuffer[n2] = (char)n;
                return;
            }
            char[] cArray = this._entityBuffer;
            if (cArray == null) {
                cArray = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            cArray[1] = (char)n;
            this._writer.write(cArray, 0, 2);
            return;
        }
        if (n != -2) {
            if (this._outputTail >= 6) {
                int n3;
                char[] cArray = this._outputBuffer;
                this._outputHead = n3 = this._outputTail - 6;
                cArray[n3] = 92;
                cArray[++n3] = 117;
                if (c > '\u00ff') {
                    int n4 = c >> 8 & 0xFF;
                    cArray[++n3] = HEX_CHARS[n4 >> 4];
                    cArray[++n3] = HEX_CHARS[n4 & 0xF];
                    c = (char)(c & 0xFF);
                } else {
                    cArray[++n3] = 48;
                    cArray[++n3] = 48;
                }
                cArray[++n3] = HEX_CHARS[c >> 4];
                cArray[++n3] = HEX_CHARS[c & 0xF];
                return;
            }
            char[] cArray = this._entityBuffer;
            if (cArray == null) {
                cArray = this._allocateEntityBuffer();
            }
            this._outputHead = this._outputTail;
            if (c > '\u00ff') {
                int n5 = c >> 8 & 0xFF;
                int n6 = c & 0xFF;
                cArray[10] = HEX_CHARS[n5 >> 4];
                cArray[11] = HEX_CHARS[n5 & 0xF];
                cArray[12] = HEX_CHARS[n6 >> 4];
                cArray[13] = HEX_CHARS[n6 & 0xF];
                this._writer.write(cArray, 8, 6);
            } else {
                cArray[6] = HEX_CHARS[c >> 4];
                cArray[7] = HEX_CHARS[c & 0xF];
                this._writer.write(cArray, 2, 6);
            }
            return;
        }
        if (this._currentEscape == null) {
            string = this._characterEscapes.getEscapeSequence(c).getValue();
        } else {
            string = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        int n7 = string.length();
        if (this._outputTail >= n7) {
            int n8;
            this._outputHead = n8 = this._outputTail - n7;
            string.getChars(0, n7, this._outputBuffer, n8);
            return;
        }
        this._outputHead = this._outputTail;
        this._writer.write(string);
    }

    private final int _prependOrWriteCharacterEscape(char[] cArray, int n, int n2, char c, int n3) throws IOException, JsonGenerationException {
        String string;
        if (n3 >= 0) {
            if (n > 1 && n < n2) {
                cArray[n -= 2] = 92;
                cArray[n + 1] = (char)n3;
            } else {
                char[] cArray2 = this._entityBuffer;
                if (cArray2 == null) {
                    cArray2 = this._allocateEntityBuffer();
                }
                cArray2[1] = (char)n3;
                this._writer.write(cArray2, 0, 2);
            }
            return n;
        }
        if (n3 != -2) {
            if (n > 5 && n < n2) {
                n -= 6;
                cArray[n++] = 92;
                cArray[n++] = 117;
                if (c > '\u00ff') {
                    int n4 = c >> 8 & 0xFF;
                    cArray[n++] = HEX_CHARS[n4 >> 4];
                    cArray[n++] = HEX_CHARS[n4 & 0xF];
                    c = (char)(c & 0xFF);
                } else {
                    cArray[n++] = 48;
                    cArray[n++] = 48;
                }
                cArray[n++] = HEX_CHARS[c >> 4];
                cArray[n] = HEX_CHARS[c & 0xF];
                n -= 5;
            } else {
                char[] cArray3 = this._entityBuffer;
                if (cArray3 == null) {
                    cArray3 = this._allocateEntityBuffer();
                }
                this._outputHead = this._outputTail;
                if (c > '\u00ff') {
                    int n5 = c >> 8 & 0xFF;
                    int n6 = c & 0xFF;
                    cArray3[10] = HEX_CHARS[n5 >> 4];
                    cArray3[11] = HEX_CHARS[n5 & 0xF];
                    cArray3[12] = HEX_CHARS[n6 >> 4];
                    cArray3[13] = HEX_CHARS[n6 & 0xF];
                    this._writer.write(cArray3, 8, 6);
                } else {
                    cArray3[6] = HEX_CHARS[c >> 4];
                    cArray3[7] = HEX_CHARS[c & 0xF];
                    this._writer.write(cArray3, 2, 6);
                }
            }
            return n;
        }
        if (this._currentEscape == null) {
            string = this._characterEscapes.getEscapeSequence(c).getValue();
        } else {
            string = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        int n7 = string.length();
        if (n >= n7 && n < n2) {
            string.getChars(0, n7, cArray, n -= n7);
        } else {
            this._writer.write(string);
        }
        return n;
    }

    private final void _appendCharacterEscape(char c, int n) throws IOException, JsonGenerationException {
        String string;
        if (n >= 0) {
            if (this._outputTail + 2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = (char)n;
            return;
        }
        if (n != -2) {
            if (this._outputTail + 2 > this._outputEnd) {
                this._flushBuffer();
            }
            int n2 = this._outputTail;
            char[] cArray = this._outputBuffer;
            cArray[n2++] = 92;
            cArray[n2++] = 117;
            if (c > '\u00ff') {
                int n3 = c >> 8 & 0xFF;
                cArray[n2++] = HEX_CHARS[n3 >> 4];
                cArray[n2++] = HEX_CHARS[n3 & 0xF];
                c = (char)(c & 0xFF);
            } else {
                cArray[n2++] = 48;
                cArray[n2++] = 48;
            }
            cArray[n2++] = HEX_CHARS[c >> 4];
            cArray[n2] = HEX_CHARS[c & 0xF];
            this._outputTail = n2;
            return;
        }
        if (this._currentEscape == null) {
            string = this._characterEscapes.getEscapeSequence(c).getValue();
        } else {
            string = this._currentEscape.getValue();
            this._currentEscape = null;
        }
        int n4 = string.length();
        if (this._outputTail + n4 > this._outputEnd) {
            this._flushBuffer();
            if (n4 > this._outputEnd) {
                this._writer.write(string);
                return;
            }
        }
        string.getChars(0, n4, this._outputBuffer, this._outputTail);
        this._outputTail += n4;
    }

    private char[] _allocateEntityBuffer() {
        char[] cArray = new char[14];
        cArray[0] = 92;
        cArray[2] = 92;
        cArray[3] = 117;
        cArray[4] = 48;
        cArray[5] = 48;
        cArray[8] = 92;
        cArray[9] = 117;
        this._entityBuffer = cArray;
        return cArray;
    }

    protected final void _flushBuffer() throws IOException {
        int n = this._outputTail - this._outputHead;
        if (n > 0) {
            int n2 = this._outputHead;
            this._outputHead = 0;
            this._outputTail = 0;
            this._writer.write(this._outputBuffer, n2, n);
        }
    }
}

