/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.io;

import java.lang.ref.SoftReference;
import org.codehaus.jackson.util.ByteArrayBuilder;
import org.codehaus.jackson.util.CharTypes;
import org.codehaus.jackson.util.TextBuffer;

public final class JsonStringEncoder {
    private static final char[] HEX_CHARS = CharTypes.copyHexChars();
    private static final byte[] HEX_BYTES = CharTypes.copyHexBytes();
    private static final int SURR1_FIRST = 55296;
    private static final int SURR1_LAST = 56319;
    private static final int SURR2_FIRST = 56320;
    private static final int SURR2_LAST = 57343;
    private static final int INT_BACKSLASH = 92;
    private static final int INT_U = 117;
    private static final int INT_0 = 48;
    protected static final ThreadLocal<SoftReference<JsonStringEncoder>> _threadEncoder = new ThreadLocal();
    protected TextBuffer _textBuffer;
    protected ByteArrayBuilder _byteBuilder;
    protected final char[] _quoteBuffer = new char[6];

    public JsonStringEncoder() {
        this._quoteBuffer[0] = 92;
        this._quoteBuffer[2] = 48;
        this._quoteBuffer[3] = 48;
    }

    public static JsonStringEncoder getInstance() {
        JsonStringEncoder jsonStringEncoder;
        SoftReference<JsonStringEncoder> softReference = _threadEncoder.get();
        JsonStringEncoder jsonStringEncoder2 = jsonStringEncoder = softReference == null ? null : softReference.get();
        if (jsonStringEncoder == null) {
            jsonStringEncoder = new JsonStringEncoder();
            _threadEncoder.set(new SoftReference<JsonStringEncoder>(jsonStringEncoder));
        }
        return jsonStringEncoder;
    }

    public char[] quoteAsString(String string) {
        TextBuffer textBuffer = this._textBuffer;
        if (textBuffer == null) {
            this._textBuffer = textBuffer = new TextBuffer(null);
        }
        char[] cArray = textBuffer.emptyAndGetCurrentSegment();
        int[] nArray = CharTypes.get7BitOutputEscapes();
        int n = nArray.length;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        block0: while (n2 < n3) {
            int n5;
            int n6;
            while ((n6 = string.charAt(n2)) >= n || nArray[n6] == 0) {
                if (n4 >= cArray.length) {
                    cArray = textBuffer.finishCurrentSegment();
                    n4 = 0;
                }
                cArray[n4++] = n6;
                if (++n2 < n3) continue;
                break block0;
            }
            if (n4 + (n5 = this._appendSingleEscape(n6 = nArray[string.charAt(n2++)], this._quoteBuffer)) > cArray.length) {
                int n7 = cArray.length - n4;
                if (n7 > 0) {
                    System.arraycopy(this._quoteBuffer, 0, cArray, n4, n7);
                }
                cArray = textBuffer.finishCurrentSegment();
                int n8 = n5 - n7;
                System.arraycopy(this._quoteBuffer, n7, cArray, n4, n8);
                n4 += n8;
                continue;
            }
            System.arraycopy(this._quoteBuffer, 0, cArray, n4, n5);
            n4 += n5;
        }
        textBuffer.setCurrentLength(n4);
        return textBuffer.contentsAsArray();
    }

    public byte[] quoteAsUTF8(String string) {
        ByteArrayBuilder byteArrayBuilder = this._byteBuilder;
        if (byteArrayBuilder == null) {
            this._byteBuilder = byteArrayBuilder = new ByteArrayBuilder(null);
        }
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        byte[] byArray = byteArrayBuilder.resetAndGetFirstSegment();
        block0: while (n < n2) {
            int n4;
            int[] nArray = CharTypes.get7BitOutputEscapes();
            while ((n4 = string.charAt(n)) <= 127 && nArray[n4] == 0) {
                if (n3 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n3 = 0;
                }
                byArray[n3++] = (byte)n4;
                if (++n < n2) continue;
                break block0;
            }
            if (n3 >= byArray.length) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n3 = 0;
            }
            if ((n4 = string.charAt(n++)) <= 127) {
                int n5 = nArray[n4];
                n3 = this._appendByteEscape(n4, n5, byteArrayBuilder, n3);
                byArray = byteArrayBuilder.getCurrentSegment();
                continue;
            }
            if (n4 <= 2047) {
                byArray[n3++] = (byte)(0xC0 | n4 >> 6);
                n4 = 0x80 | n4 & 0x3F;
            } else if (n4 < 55296 || n4 > 57343) {
                byArray[n3++] = (byte)(0xE0 | n4 >> 12);
                if (n3 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                n4 = 0x80 | n4 & 0x3F;
            } else {
                if (n4 > 56319) {
                    this._throwIllegalSurrogate(n4);
                }
                if (n >= n2) {
                    this._throwIllegalSurrogate(n4);
                }
                if ((n4 = this._convertSurrogate(n4, string.charAt(n++))) > 0x10FFFF) {
                    this._throwIllegalSurrogate(n4);
                }
                byArray[n3++] = (byte)(0xF0 | n4 >> 18);
                if (n3 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n4 >> 12 & 0x3F);
                if (n3 >= byArray.length) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n4 >> 6 & 0x3F);
                n4 = 0x80 | n4 & 0x3F;
            }
            if (n3 >= byArray.length) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n3 = 0;
            }
            byArray[n3++] = (byte)n4;
        }
        return this._byteBuilder.completeAndCoalesce(n3);
    }

    public byte[] encodeAsUTF8(String string) {
        ByteArrayBuilder byteArrayBuilder = this._byteBuilder;
        if (byteArrayBuilder == null) {
            this._byteBuilder = byteArrayBuilder = new ByteArrayBuilder(null);
        }
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        byte[] byArray = byteArrayBuilder.resetAndGetFirstSegment();
        int n4 = byArray.length;
        block0: while (n < n2) {
            int n5 = string.charAt(n++);
            while (n5 <= 127) {
                if (n3 >= n4) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n3 = 0;
                }
                byArray[n3++] = (byte)n5;
                if (n >= n2) break block0;
                n5 = string.charAt(n++);
            }
            if (n3 >= n4) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n4 = byArray.length;
                n3 = 0;
            }
            if (n5 < 2048) {
                byArray[n3++] = (byte)(0xC0 | n5 >> 6);
            } else if (n5 < 55296 || n5 > 57343) {
                byArray[n3++] = (byte)(0xE0 | n5 >> 12);
                if (n3 >= n4) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n5 >> 6 & 0x3F);
            } else {
                if (n5 > 56319) {
                    this._throwIllegalSurrogate(n5);
                }
                if (n >= n2) {
                    this._throwIllegalSurrogate(n5);
                }
                if ((n5 = this._convertSurrogate(n5, string.charAt(n++))) > 0x10FFFF) {
                    this._throwIllegalSurrogate(n5);
                }
                byArray[n3++] = (byte)(0xF0 | n5 >> 18);
                if (n3 >= n4) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n5 >> 12 & 0x3F);
                if (n3 >= n4) {
                    byArray = byteArrayBuilder.finishCurrentSegment();
                    n4 = byArray.length;
                    n3 = 0;
                }
                byArray[n3++] = (byte)(0x80 | n5 >> 6 & 0x3F);
            }
            if (n3 >= n4) {
                byArray = byteArrayBuilder.finishCurrentSegment();
                n4 = byArray.length;
                n3 = 0;
            }
            byArray[n3++] = (byte)(0x80 | n5 & 0x3F);
        }
        return this._byteBuilder.completeAndCoalesce(n3);
    }

    private int _appendSingleEscape(int n, char[] cArray) {
        if (n < 0) {
            int n2 = -(n + 1);
            cArray[1] = 117;
            cArray[4] = HEX_CHARS[n2 >> 4];
            cArray[5] = HEX_CHARS[n2 & 0xF];
            return 6;
        }
        cArray[1] = (char)n;
        return 2;
    }

    private int _appendByteEscape(int n, int n2, ByteArrayBuilder byteArrayBuilder, int n3) {
        byteArrayBuilder.setCurrentSegmentLength(n3);
        byteArrayBuilder.append(92);
        if (n2 < 0) {
            byteArrayBuilder.append(117);
            if (n > 255) {
                int n4 = n >> 8;
                byteArrayBuilder.append(HEX_BYTES[n4 >> 4]);
                byteArrayBuilder.append(HEX_BYTES[n4 & 0xF]);
                n &= 0xFF;
            } else {
                byteArrayBuilder.append(48);
                byteArrayBuilder.append(48);
            }
            byteArrayBuilder.append(HEX_BYTES[n >> 4]);
            byteArrayBuilder.append(HEX_BYTES[n & 0xF]);
        } else {
            byteArrayBuilder.append((byte)n2);
        }
        return byteArrayBuilder.getCurrentSegmentLength();
    }

    private int _convertSurrogate(int n, int n2) {
        if (n2 < 56320 || n2 > 57343) {
            throw new IllegalArgumentException("Broken surrogate pair: first char 0x" + Integer.toHexString(n) + ", second 0x" + Integer.toHexString(n2) + "; illegal combination");
        }
        return 65536 + (n - 55296 << 10) + (n2 - 56320);
    }

    private void _throwIllegalSurrogate(int n) {
        if (n > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(n) + ") to output; max is 0x10FFFF as per RFC 4627");
        }
        if (n >= 55296) {
            if (n <= 56319) {
                throw new IllegalArgumentException("Unmatched first part of surrogate pair (0x" + Integer.toHexString(n) + ")");
            }
            throw new IllegalArgumentException("Unmatched second part of surrogate pair (0x" + Integer.toHexString(n) + ")");
        }
        throw new IllegalArgumentException("Illegal character point (0x" + Integer.toHexString(n) + ") to output");
    }
}

