/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.io;

import org.codehaus.jackson.SerializableString;
import org.codehaus.jackson.io.JsonStringEncoder;

public class SerializedString
implements SerializableString {
    protected final String _value;
    protected byte[] _quotedUTF8Ref;
    protected byte[] _unquotedUTF8Ref;
    protected char[] _quotedChars;

    public SerializedString(String string) {
        this._value = string;
    }

    public final String getValue() {
        return this._value;
    }

    public final int charLength() {
        return this._value.length();
    }

    public final char[] asQuotedChars() {
        char[] cArray = this._quotedChars;
        if (cArray == null) {
            this._quotedChars = cArray = JsonStringEncoder.getInstance().quoteAsString(this._value);
        }
        return cArray;
    }

    public final byte[] asUnquotedUTF8() {
        byte[] byArray = this._unquotedUTF8Ref;
        if (byArray == null) {
            this._unquotedUTF8Ref = byArray = JsonStringEncoder.getInstance().encodeAsUTF8(this._value);
        }
        return byArray;
    }

    public final byte[] asQuotedUTF8() {
        byte[] byArray = this._quotedUTF8Ref;
        if (byArray == null) {
            this._quotedUTF8Ref = byArray = JsonStringEncoder.getInstance().quoteAsUTF8(this._value);
        }
        return byArray;
    }

    public final String toString() {
        return this._value;
    }

    public final int hashCode() {
        return this._value.hashCode();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        SerializedString serializedString = (SerializedString)object;
        return this._value.equals(serializedString._value);
    }
}

