/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.io;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.io.BaseReader;
import org.codehaus.jackson.io.IOContext;

public final class UTF32Reader
extends BaseReader {
    final boolean mBigEndian;
    char mSurrogate = '\u0000';
    int mCharCount = 0;
    int mByteCount = 0;

    public UTF32Reader(IOContext iOContext, InputStream inputStream, byte[] byArray, int n, int n2, boolean bl) {
        super(iOContext, inputStream, byArray, n, n2);
        this.mBigEndian = bl;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        if (this._buffer == null) {
            return -1;
        }
        if (n2 < 1) {
            return n2;
        }
        if (n < 0 || n + n2 > cArray.length) {
            this.reportBounds(cArray, n, n2);
        }
        n2 += n;
        int n4 = n;
        if (this.mSurrogate != '\u0000') {
            cArray[n4++] = this.mSurrogate;
            this.mSurrogate = '\u0000';
        } else {
            n3 = this._length - this._ptr;
            if (n3 < 4 && !this.loadMore(n3)) {
                return -1;
            }
        }
        while (n4 < n2) {
            n3 = this._ptr;
            int n5 = this.mBigEndian ? this._buffer[n3] << 24 | (this._buffer[n3 + 1] & 0xFF) << 16 | (this._buffer[n3 + 2] & 0xFF) << 8 | this._buffer[n3 + 3] & 0xFF : this._buffer[n3] & 0xFF | (this._buffer[n3 + 1] & 0xFF) << 8 | (this._buffer[n3 + 2] & 0xFF) << 16 | this._buffer[n3 + 3] << 24;
            this._ptr += 4;
            if (n5 > 65535) {
                if (n5 > 0x10FFFF) {
                    this.reportInvalid(n5, n4 - n, "(above " + Integer.toHexString(0x10FFFF) + ") ");
                }
                cArray[n4++] = (char)(55296 + ((n5 -= 65536) >> 10));
                n5 = 0xDC00 | n5 & 0x3FF;
                if (n4 >= n2) {
                    this.mSurrogate = (char)n5;
                    break;
                }
            }
            cArray[n4++] = (char)n5;
            if (this._ptr < this._length) continue;
            break;
        }
        n2 = n4 - n;
        this.mCharCount += n2;
        return n2;
    }

    private void reportUnexpectedEOF(int n, int n2) throws IOException {
        int n3 = this.mByteCount + n;
        int n4 = this.mCharCount;
        throw new CharConversionException("Unexpected EOF in the middle of a 4-byte UTF-32 char: got " + n + ", needed " + n2 + ", at char #" + n4 + ", byte #" + n3 + ")");
    }

    private void reportInvalid(int n, int n2, String string) throws IOException {
        int n3 = this.mByteCount + this._ptr - 1;
        int n4 = this.mCharCount + n2;
        throw new CharConversionException("Invalid UTF-32 character 0x" + Integer.toHexString(n) + string + " at char #" + n4 + ", byte #" + n3 + ")");
    }

    private boolean loadMore(int n) throws IOException {
        int n2;
        this.mByteCount += this._length - n;
        if (n > 0) {
            if (this._ptr > 0) {
                for (n2 = 0; n2 < n; ++n2) {
                    this._buffer[n2] = this._buffer[this._ptr + n2];
                }
                this._ptr = 0;
            }
            this._length = n;
        } else {
            this._ptr = 0;
            n2 = this._in.read(this._buffer);
            if (n2 < 1) {
                this._length = 0;
                if (n2 < 0) {
                    this.freeBuffers();
                    return false;
                }
                this.reportStrangeStream();
            }
            this._length = n2;
        }
        while (this._length < 4) {
            n2 = this._in.read(this._buffer, this._length, this._buffer.length - this._length);
            if (n2 < 1) {
                if (n2 < 0) {
                    this.freeBuffers();
                    this.reportUnexpectedEOF(this._length, 4);
                }
                this.reportStrangeStream();
            }
            this._length += n2;
        }
        return true;
    }
}

