/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Pattern;
import org.codehaus.jackson.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionUtil {
    public static final String VERSION_FILE = "VERSION.txt";
    private static final Pattern VERSION_SEPARATOR = Pattern.compile("[-_./;:]");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version versionFor(Class<?> clazz) {
        Version version;
        block9: {
            version = null;
            try {
                InputStream inputStream = clazz.getResourceAsStream(VERSION_FILE);
                if (inputStream == null) break block9;
                try {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    version = VersionUtil.parseVersion(bufferedReader.readLine());
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return version == null ? Version.unknownVersion() : version;
    }

    public static Version parseVersion(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        String[] stringArray = VERSION_SEPARATOR.split(string);
        if (stringArray.length < 2) {
            return null;
        }
        int n = VersionUtil.parseVersionPart(stringArray[0]);
        int n2 = VersionUtil.parseVersionPart(stringArray[1]);
        int n3 = stringArray.length > 2 ? VersionUtil.parseVersionPart(stringArray[2]) : 0;
        String string2 = stringArray.length > 3 ? stringArray[3] : null;
        return new Version(n, n2, n3, string2);
    }

    protected static int parseVersionPart(String string) {
        char c;
        string = string.toString();
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n && (c = string.charAt(i)) <= '9' && c >= '0'; ++i) {
            n2 = n2 * 10 + (c - 48);
        }
        return n2;
    }
}

