/*
 * Decompiled with CFR 0.152.
 */
package roboguice.inject;

import android.content.Context;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.internal.Nullable;
import com.google.inject.internal.Preconditions;
import java.lang.reflect.Field;
import roboguice.inject.ContextScope;
import roboguice.inject.InjectPreference;

class PreferenceMembersInjector<T>
implements MembersInjector<T> {
    protected Field field;
    protected Provider<Context> contextProvider;
    protected InjectPreference annotation;
    protected ContextScope scope;
    protected T instance;

    public PreferenceMembersInjector(Field field, Provider<Context> contextProvider, InjectPreference annotation, ContextScope scope) {
        this.field = field;
        this.annotation = annotation;
        this.contextProvider = contextProvider;
        this.scope = scope;
    }

    public void injectMembers(T instance) {
        this.instance = instance;
        this.scope.registerPreferenceForInjection(this);
    }

    public void reallyInjectMembers() {
        Preconditions.checkNotNull(this.instance);
        Preference value = null;
        try {
            value = ((PreferenceActivity)this.contextProvider.get()).findPreference((CharSequence)this.annotation.value());
            if (value == null && this.field.getAnnotation(Nullable.class) == null) {
                throw new NullPointerException(String.format("Can't inject null value into %s.%s when field is not @Nullable", this.field.getDeclaringClass(), this.field.getName()));
            }
            this.field.setAccessible(true);
            this.field.set(this.instance, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException f) {
            throw new IllegalArgumentException(String.format("Can't assign %s value %s to %s field %s", value != null ? value.getClass() : "(null)", value, this.field.getType(), this.field.getName()));
        }
    }
}

