/*
 * Decompiled with CFR 0.152.
 */
package roboguice.inject;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.inject.Inject;
import com.google.inject.Provider;
import roboguice.inject.SharedPreferencesName;

public class SharedPreferencesProvider
implements Provider<SharedPreferences> {
    protected static final String DEFAULT = "default";
    protected String preferencesName;
    @Inject
    protected Provider<Context> contextProvider;

    public SharedPreferencesProvider() {
        this.preferencesName = DEFAULT;
    }

    @Inject
    public SharedPreferencesProvider(PreferencesNameHolder preferencesNameHolder) {
        this.preferencesName = preferencesNameHolder.value;
    }

    public SharedPreferencesProvider(String preferencesName) {
        this.preferencesName = preferencesName;
    }

    public SharedPreferences get() {
        return ((Context)this.contextProvider.get()).getSharedPreferences(this.preferencesName, 0);
    }

    public static class PreferencesNameHolder {
        @Inject(optional=true)
        @SharedPreferencesName
        protected String value = "default";
    }
}

