/*
 * Decompiled with CFR 0.152.
 */
package org.cmc.music.myid3;

import org.cmc.music.myid3.MyID3v2Constants;

public class ID3v2FrameFlags
implements MyID3v2Constants {
    public static final String TAG_ALTER_PRESERVATION = "Tag Alter Preservation";
    public static final String FILE_ALTER_PRESERVATION = "File Alter Preservation";
    public static final String READ_ONLY = "Read Only";
    public static final String GROUPING_IDENTITY = "Grouping Identity";
    public static final String COMPRESSION = "Compression";
    public static final String ENCRYPTION = "Encryption";
    public static final String UNSYNCHRONISATION = "Unsynchronisation";
    public static final String DATA_LENGTH_INDICATOR = "Data Length Indicator";
    private boolean tagAlterPreservation = false;
    private boolean fileAlterPreservation = false;
    private boolean readOnly = false;
    private boolean groupingIdentity = false;
    private boolean compression = false;
    private boolean encryption = false;
    private boolean unsynchronisation = false;
    private boolean dataLengthIndicator = false;

    public boolean getTagAlterPreservation() {
        return this.tagAlterPreservation;
    }

    public boolean getFileAlterPreservation() {
        return this.fileAlterPreservation;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public boolean getGroupingIdentity() {
        return this.groupingIdentity;
    }

    public boolean getCompression() {
        return this.compression;
    }

    public boolean getEncryption() {
        return this.encryption;
    }

    public boolean getUnsynchronisation() {
        return this.unsynchronisation;
    }

    public boolean getDataLengthIndicator() {
        return this.dataLengthIndicator;
    }

    public void setTagAlterPreservation(boolean value) {
        this.tagAlterPreservation = value;
    }

    public void setFileAlterPreservation(boolean value) {
        this.fileAlterPreservation = value;
    }

    public void setReadOnly(boolean value) {
        this.readOnly = value;
    }

    public void setGroupingIdentity(boolean value) {
        this.groupingIdentity = value;
    }

    public void setCompression(boolean value) {
        this.compression = value;
    }

    public void setEncryption(boolean value) {
        this.encryption = value;
    }

    public void setUnsynchronisation(boolean value) {
        this.unsynchronisation = value;
    }

    public void setDataLengthIndicator(boolean value) {
        this.dataLengthIndicator = value;
    }

    public boolean hasSetFlag() {
        return this.tagAlterPreservation || this.fileAlterPreservation || this.readOnly || this.groupingIdentity || this.compression || this.encryption || this.unsynchronisation || this.dataLengthIndicator;
    }

    public String getSummary() {
        StringBuffer result = new StringBuffer();
        result.append("{");
        if (this.getTagAlterPreservation()) {
            result.append("ID3v2FrameFlags: TagAlterPreservation, ");
        }
        if (this.getFileAlterPreservation()) {
            result.append("ID3v2FrameFlags: FileAlterPreservation, ");
        }
        if (this.getReadOnly()) {
            result.append("ID3v2FrameFlags: ReadOnly, ");
        }
        if (this.getGroupingIdentity()) {
            result.append("ID3v2FrameFlags: GroupingIdentity, ");
        }
        if (this.getCompression()) {
            result.append("ID3v2FrameFlags: Compression, ");
        }
        if (this.getEncryption()) {
            result.append("ID3v2FrameFlags: Encryption, ");
        }
        if (this.getUnsynchronisation()) {
            result.append("ID3v2FrameFlags: Unsynchronisation, ");
        }
        if (this.getDataLengthIndicator()) {
            result.append("ID3v2FrameFlags: DataLengthIndicator, ");
        }
        result.append("}");
        return result.toString();
    }
}

