/*
 * Decompiled with CFR 0.152.
 */
package org.cmc.music.myid3;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.cmc.music.common.ID3WriteException;
import org.cmc.music.metadata.MusicMetadata;
import org.cmc.music.metadata.MusicMetadataSet;
import org.cmc.music.myid3.ID3Tag;
import org.cmc.music.myid3.ID3v2DataMapping;
import org.cmc.music.myid3.MyID3Listener;
import org.cmc.music.myid3.MyID3v1;
import org.cmc.music.myid3.MyID3v2Read;
import org.cmc.music.myid3.MyID3v2Write;

public class MyID3 {
    private boolean skipId3v1 = false;
    private boolean skipId3v2 = false;
    private boolean skipId3v2Head = false;
    private boolean skipId3v2Tail = false;
    private static final int ID3v2_HEADER_LENGTH = 10;

    public void update(File file, MusicMetadataSet set, MusicMetadata values) throws UnsupportedEncodingException, IOException, ID3WriteException {
        File temp = null;
        temp = File.createTempFile(file.getName(), ".tmp", file.getParentFile());
        this.write(file, temp, set, values);
        temp.setLastModified(file.lastModified());
        file.delete();
        temp.renameTo(file);
    }

    public void update(File file, MusicMetadataSet set, MusicMetadata values, MyID3v2Write.Filter filter, MyID3Listener listener) throws UnsupportedEncodingException, IOException, ID3WriteException {
        File temp = null;
        try {
            temp = File.createTempFile(file.getName(), ".tmp", file.getParentFile());
            this.write(file, temp, set, values, filter, listener);
            temp.setLastModified(file.lastModified());
            file.delete();
            temp.renameTo(file);
        }
        catch (UnsupportedEncodingException e) {
            if (temp != null && temp.exists() && file.exists()) {
                temp.delete();
            }
            throw e;
        }
        catch (IOException e) {
            if (temp != null && temp.exists() && file.exists()) {
                temp.delete();
            }
            throw e;
        }
        catch (ID3WriteException e) {
            if (temp != null && temp.exists() && file.exists()) {
                temp.delete();
            }
            throw e;
        }
    }

    public void write(File src, File dst, MusicMetadataSet set, MusicMetadata values) throws UnsupportedEncodingException, IOException, ID3WriteException {
        this.write(src, dst, set, values, null, null);
    }

    public void write(File src, File dst, MusicMetadataSet set, MusicMetadata values, MyID3Listener listener) throws UnsupportedEncodingException, IOException, ID3WriteException {
        this.write(src, dst, set, values, null, listener);
    }

    public void write(File src, File dst, MusicMetadataSet set, MusicMetadata values, MyID3v2Write.Filter filter, MyID3Listener listener) throws UnsupportedEncodingException, IOException, ID3WriteException {
        if (values == null && listener != null) {
            listener.log();
        }
        byte[] id3v1Tag = new MyID3v1().toTag(values);
        if (listener != null) {
            listener.log("writing id3v1Tag", id3v1Tag == null ? "null" : "" + id3v1Tag.length);
        }
        byte[] id3v2TailTag = new MyID3v2Write().toTag(filter, set, values);
        if (listener != null) {
            listener.log("writing id3v2TailTag", id3v2TailTag == null ? "null" : "" + id3v2TailTag.length);
        }
        this.write(src, dst, id3v1Tag, id3v2TailTag, id3v2TailTag);
        if (listener != null) {
            listener.log();
        }
    }

    public void removeTags(File src, File dst) throws UnsupportedEncodingException, IOException, ID3WriteException {
        byte[] id3v1Tag = null;
        byte[] id3v2HeadTag = null;
        byte[] id3v2TailTag = null;
        this.write(src, dst, id3v1Tag, id3v2HeadTag, id3v2TailTag);
    }

    public void rewriteTags(File src, File dst) throws UnsupportedEncodingException, IOException, ID3WriteException {
        byte[] id3v1Tag = null;
        ID3Tag tag = this.readID3v1(src);
        if (tag != null) {
            id3v1Tag = tag.bytes;
        }
        byte[] id3v2HeadTag = this.readID3v2Head(src);
        boolean hasId3v1 = id3v1Tag != null;
        byte[] id3v2TailTag = this.readID3v2Tail(src, hasId3v1);
        this.write(src, dst, id3v1Tag, id3v2HeadTag, id3v2TailTag);
    }

    public void setSkipId3v1() {
        this.skipId3v1 = true;
    }

    public void setSkipId3v2() {
        this.skipId3v2 = true;
    }

    public void setSkipId3v2Head() {
        this.skipId3v2Head = true;
    }

    public void setSkipId3v2Tail() {
        this.skipId3v2Tail = true;
    }

    private void write(File src, File dst, byte[] id3v1Tag, byte[] id3v2HeadTag, byte[] id3v2TailTag) throws IOException {
        boolean hasId3v1;
        if (!(src != null && src.exists() || src.getName().toLowerCase().endsWith(".mp3") || dst != null || !dst.exists())) {
            dst.delete();
        }
        long id3v1Length = (hasId3v1 = this.hasID3v1(src)) ? 128 : 0;
        long id3v2HeadLength = this.findID3v2HeadLength(src);
        long id3v2TailLength = this.findID3v2TailLength(src, hasId3v1);
        OutputStream os = null;
        InputStream is = null;
        try {
            dst.getParentFile().mkdirs();
            os = new FileOutputStream(dst);
            os = new BufferedOutputStream(os);
            if (!this.skipId3v2Head && !this.skipId3v2 && id3v2HeadTag != null) {
                os.write(id3v2HeadTag);
            }
            is = new FileInputStream(src);
            is = new BufferedInputStream(is, 8192);
            is.skip(id3v2HeadLength);
            long total_to_read = src.length();
            total_to_read -= id3v1Length;
            total_to_read -= id3v2HeadLength;
            total_to_read -= id3v2TailLength;
            byte[] buffer = new byte[1024];
            long total_read = 0L;
            while (total_read < total_to_read) {
                int remainder = (int)(total_to_read - total_read);
                int readSize = Math.min(buffer.length, remainder);
                int read = is.read(buffer, 0, readSize);
                if (read <= 0) {
                    throw new IOException("unexpected EOF");
                }
                os.write(buffer, 0, read);
                total_read += (long)read;
            }
            if (!this.skipId3v2Tail && !this.skipId3v2 && id3v2TailTag != null) {
                os.write(id3v2TailTag);
            }
            if (!this.skipId3v1 && id3v1Tag != null) {
                os.write(id3v1Tag);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private final byte[] readArray(InputStream is, int length) throws IOException {
        byte[] result = new byte[length];
        int total = 0;
        while (total < length) {
            int read = is.read(result, total, length - total);
            if (read < 0) {
                throw new IOException("bad read");
            }
            total += read;
        }
        return result;
    }

    public MusicMetadataSet read(File file) throws IOException {
        return this.read(file, null);
    }

    public MusicMetadataSet read(File file, MyID3Listener listener) throws IOException {
        block6: {
            block5: {
                if (file != null && file.exists()) break block5;
                return null;
            }
            if (file.getName().toLowerCase().endsWith(".mp3")) break block6;
            return null;
        }
        try {
            ID3Tag id3v1 = this.readID3v1(listener, file);
            ID3Tag.V2 id3v2 = this.readID3v2(listener, file, id3v1 != null);
            MusicMetadataSet result = MusicMetadataSet.factoryMethod(id3v1, id3v2, file.getName(), file.getParentFile().getName());
            return result;
        }
        catch (Error e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    private ID3Tag readID3v1(File file) throws IOException {
        return this.readID3v1(null, file);
    }

    private ID3Tag readID3v1(MyID3Listener listener, File file) throws IOException {
        byte[] bytes;
        if (file == null || !file.exists()) {
            return null;
        }
        long length = file.length();
        if (length < 128L) {
            return null;
        }
        InputStream is = null;
        try {
            is = new FileInputStream(file);
            is = new BufferedInputStream(is, 8192);
            is.skip(length - 128L);
            bytes = this.readArray(is, 128);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (bytes[0] != 84) {
            return null;
        }
        if (bytes[1] != 65) {
            return null;
        }
        if (bytes[2] != 71) {
            return null;
        }
        if (listener != null) {
            listener.log("ID3v1 tag found.");
        }
        MyID3v1 id3v1 = new MyID3v1();
        MusicMetadata tags = id3v1.parseTags(listener, bytes);
        return new ID3Tag.V1(bytes, tags);
    }

    private boolean hasID3v1(File file) throws IOException {
        byte[] bytes;
        if (file == null || !file.exists()) {
            return false;
        }
        long length = file.length();
        if (length < 128L) {
            return false;
        }
        InputStream is = null;
        try {
            is = new FileInputStream(file);
            is = new BufferedInputStream(is, 8192);
            is.skip(length - 128L);
            bytes = this.readArray(is, 128);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (bytes[0] != 84) {
            return false;
        }
        if (bytes[1] != 65) {
            return false;
        }
        return bytes[2] == 71;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readID3v2Head(File file) throws IOException {
        if (file == null) return null;
        if (!file.exists()) {
            return null;
        }
        long length = file.length();
        if (length < 10L) {
            return null;
        }
        InputStream is = null;
        try {
            is = new FileInputStream(file);
            is = new BufferedInputStream(is, 8192);
            byte[] header = this.readArray(is, 10);
            if (header[0] != 73) {
                return null;
            }
            if (header[1] != 68) {
                return null;
            }
            if (header[2] != 51) {
                return null;
            }
            byte flags = header[5];
            boolean has_footer = (flags & 0x10) > 0;
            Number tagLength = MyID3v2Read.readSynchsafeInt(header, 6);
            if (tagLength == null) {
                return null;
            }
            int bodyLength = tagLength.intValue();
            if (has_footer) {
                bodyLength += 10;
            }
            if ((long)(10 + bodyLength) > length) {
                return null;
            }
            byte[] body = this.readArray(is, bodyLength);
            byte[] result = new byte[header.length + body.length];
            System.arraycopy(header, 0, result, 0, header.length);
            System.arraycopy(body, 0, result, header.length, body.length);
            byte[] byArray = result;
            return byArray;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long findID3v2HeadLength(File file) throws IOException {
        if (file == null) return 0L;
        if (!file.exists()) {
            return 0L;
        }
        long length = file.length();
        if (length < 10L) {
            return 0L;
        }
        InputStream is = null;
        try {
            is = new FileInputStream(file);
            is = new BufferedInputStream(is, 8192);
            byte[] header = this.readArray(is, 10);
            if (header[0] != 73) {
                return 0L;
            }
            if (header[1] != 68) {
                return 0L;
            }
            if (header[2] != 51) {
                return 0L;
            }
            byte flags = header[5];
            boolean has_footer = (flags & 0x10) > 0;
            Number tagLength = MyID3v2Read.readSynchsafeInt(header, 6);
            if (tagLength == null) {
                return 0L;
            }
            int totalLength = 10 + tagLength.intValue();
            if (has_footer) {
                totalLength += 10;
            }
            long l = totalLength;
            return l;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int findID3v2TailLength(File file, boolean hasId3v1) throws IOException {
        int index;
        if (file == null) return 0;
        if (!file.exists()) {
            return 0;
        }
        long length = file.length();
        int n = index = hasId3v1 ? 128 : 0;
        if ((long)(index += 10) > length) {
            return 0;
        }
        InputStream is = null;
        try {
            int totalLength;
            is = new FileInputStream(file);
            is = new BufferedInputStream(is, 8192);
            is.skip(length - (long)index);
            byte[] footer = this.readArray(is, 10);
            if (footer[0] != 51) {
                return 0;
            }
            if (footer[1] != 68) {
                return 0;
            }
            if (footer[2] != 73) {
                return 0;
            }
            Number tagLength = MyID3v2Read.readSynchsafeInt(footer, 6);
            if (tagLength == null) {
                return 0;
            }
            int n2 = totalLength = 20 + tagLength.intValue();
            return n2;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] readID3v2Tail(File file, boolean hasId3v1) throws IOException {
        int index;
        if (file == null) return null;
        if (!file.exists()) {
            return null;
        }
        long length = file.length();
        int n = index = hasId3v1 ? 128 : 0;
        if ((long)(index += 10) > length) {
            return null;
        }
        InputStream is = null;
        try {
            byte[] header_and_body;
            byte[] result;
            is = new FileInputStream(file);
            is = new BufferedInputStream(is, 8192);
            is.skip(length - (long)index);
            byte[] footer = this.readArray(is, 10);
            if (footer[2] != 51) {
                return null;
            }
            if (footer[1] != 68) {
                return null;
            }
            if (footer[0] != 73) {
                return null;
            }
            Number tagLength = MyID3v2Read.readSynchsafeInt(footer, 6);
            if (tagLength == null) {
                return null;
            }
            int bodyLength = tagLength.intValue();
            if ((long)(index + bodyLength) > length) {
                return null;
            }
            is.close();
            is = null;
            is = new FileInputStream(file);
            is = new BufferedInputStream(is, 8192);
            long skip = length;
            skip -= 10L;
            skip -= (long)bodyLength;
            skip -= 10L;
            if (hasId3v1) {
                skip -= 128L;
            }
            is.skip(skip);
            byte[] byArray = result = (header_and_body = this.readArray(is, 10 + bodyLength + 10));
            return byArray;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private ID3Tag.V2 readID3v2(MyID3Listener listener, File file, boolean hasId3v1) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        byte[] bytes = null;
        bytes = this.readID3v2Tail(file, hasId3v1);
        if (bytes == null) {
            bytes = this.readID3v2Head(file);
        }
        if (bytes == null) {
            return null;
        }
        if (listener != null) {
            listener.log("ID3v2 tag found: " + bytes.length + " bytes");
        }
        MyID3v2Read parser = new MyID3v2Read(listener, new ByteArrayInputStream(bytes), false);
        while (!parser.isComplete()) {
            parser.iteration();
        }
        if (parser.isError()) {
            if (listener != null) {
                listener.log("id3v2 error", parser.getErrorMessage());
            }
            parser.dump();
            return null;
        }
        if (!parser.hasTags()) {
            return null;
        }
        Vector tags = parser.getTags();
        MusicMetadata values = new ID3v2DataMapping().process(tags);
        byte version_major = parser.getVersionMajor();
        byte version_minor = parser.getVersionMinor();
        if (listener != null) {
            listener.log();
        }
        return new ID3Tag.V2(version_major, version_minor, bytes, values, tags);
    }
}

