/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSHotCopier;
import org.tmatesoft.svn.core.internal.io.fs.FSPacker;
import org.tmatesoft.svn.core.internal.io.fs.FSRecoverer;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNUUIDGenerator;
import org.tmatesoft.svn.core.internal.wc.DefaultDumpFilterHandler;
import org.tmatesoft.svn.core.internal.wc.DefaultLoadHandler;
import org.tmatesoft.svn.core.internal.wc.SVNAdminDeltifier;
import org.tmatesoft.svn.core.internal.wc.SVNAdminHelper;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNDumpEditor;
import org.tmatesoft.svn.core.internal.wc.SVNDumpStreamParser;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.replicator.SVNRepositoryReplicator;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import org.tmatesoft.svn.core.wc.admin.SVNReplayHandler;
import org.tmatesoft.svn.core.wc.admin.SVNSyncInfo;
import org.tmatesoft.svn.core.wc.admin.SVNUUIDAction;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNAdminClient
extends SVNBasicClient {
    private ISVNLogEntryHandler mySyncHandler;
    private DefaultDumpFilterHandler myDumpFilterHandler;
    private ISVNAdminEventHandler myEventHandler;
    private FSHotCopier myHotCopier;
    private SVNDumpStreamParser myDumpStreamParser;
    private SVNDumpEditor myDumpEditor;
    private static final int LOCK_RETRY_COUNT = 10;

    public SVNAdminClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNAdminClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public void setReplayHandler(ISVNLogEntryHandler handler) {
        this.mySyncHandler = handler;
    }

    public void setEventHandler(ISVNEventHandler handler) {
        super.setEventHandler(handler);
        if (handler instanceof ISVNAdminEventHandler) {
            this.myEventHandler = (ISVNAdminEventHandler)handler;
        }
    }

    public SVNURL doCreateRepository(File path, String uuid, boolean enableRevisionProperties, boolean force) throws SVNException {
        return SVNRepositoryFactory.createLocalRepository(path, uuid, enableRevisionProperties, force);
    }

    public SVNURL doCreateRepository(File path, String uuid, boolean enableRevisionProperties, boolean force, boolean pre14Compatible) throws SVNException {
        return this.doCreateRepository(path, uuid, enableRevisionProperties, force, pre14Compatible, false);
    }

    public SVNURL doCreateRepository(File path, String uuid, boolean enableRevisionProperties, boolean force, boolean pre14Compatible, boolean pre15Compatible, boolean pre16Compatible) throws SVNException {
        return SVNRepositoryFactory.createLocalRepository(path, uuid, enableRevisionProperties, force, pre14Compatible, pre15Compatible, pre16Compatible);
    }

    public SVNURL doCreateRepository(File path, String uuid, boolean enableRevisionProperties, boolean force, boolean pre14Compatible, boolean pre15Compatible) throws SVNException {
        return this.doCreateRepository(path, uuid, enableRevisionProperties, force, pre14Compatible, pre15Compatible, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCopyRevisionProperties(SVNURL toURL, long startRevision, long endRevision) throws SVNException {
        SVNRepository toRepos = null;
        SessionInfo info = null;
        SVNException error = null;
        SVNException error2 = null;
        try {
            SVNErrorMessage err;
            toRepos = this.createRepository(toURL, null, true);
            this.checkIfRepositoryIsAtRoot(toRepos, toURL);
            this.lock(toRepos);
            info = this.openSourceRepository(toRepos);
            if (!SVNRevision.isValidRevisionNumber(startRevision)) {
                startRevision = info.myLastMergedRevision;
            }
            if (!SVNRevision.isValidRevisionNumber(endRevision)) {
                endRevision = info.myLastMergedRevision;
            }
            if (startRevision > info.myLastMergedRevision) {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot copy revprops for a revision ({0}) that has not been synchronized yet", String.valueOf(startRevision));
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            if (endRevision > info.myLastMergedRevision) {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot copy revprops for a revision ({0}) that has not been synchronized yet", String.valueOf(endRevision));
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            int normalizedRevPropsCount = 0;
            long step = startRevision > endRevision ? -1L : 1L;
            for (long i = startRevision; i != endRevision + step; i += step) {
                this.checkCancelled();
                SVNProperties normalizedProps = this.copyRevisionProperties(info.myRepository, toRepos, i, false);
                normalizedRevPropsCount += normalizedProps.size();
            }
            this.handleNormalizedProperties(normalizedRevPropsCount, 0);
        }
        catch (SVNException svne) {
            error = svne;
        }
        finally {
            try {
                this.unlock(toRepos);
                if (toRepos != null) {
                    toRepos.closeSession();
                }
                if (info != null && info.myRepository != null) {
                    info.myRepository.closeSession();
                }
            }
            catch (SVNException svne) {
                error2 = svne;
            }
        }
        if (error != null) {
            throw error;
        }
        if (error2 != null) {
            throw error2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInitialize(SVNURL fromURL, SVNURL toURL) throws SVNException {
        SVNRepository toRepos = null;
        SVNRepository fromRepos = null;
        SVNException error = null;
        SVNException error2 = null;
        try {
            SVNURL rootURL;
            SVNPropertyValue fromURLProp;
            toRepos = this.createRepository(toURL, null, true);
            this.checkIfRepositoryIsAtRoot(toRepos, toURL);
            this.lock(toRepos);
            long latestRevision = toRepos.getLatestRevision();
            if (latestRevision != 0L) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot initialize a repository with content in it");
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            if ((fromURLProp = toRepos.getRevisionPropertyValue(0L, "svn:sync-from-url")) != null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Destination repository is already synchronizing from ''{0}''", fromURLProp);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            if (SVNPathUtil.getPathAsChild((rootURL = (fromRepos = this.createRepository(fromURL, null, false)).getRepositoryRoot(true)).toString(), fromURL.toString()) != null) {
                boolean supportsPartialReplay;
                block21: {
                    supportsPartialReplay = false;
                    try {
                        supportsPartialReplay = fromRepos.hasCapability(SVNCapability.PARTIAL_REPLAY);
                    }
                    catch (SVNException svne) {
                        if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.UNSUPPORTED_FEATURE) break block21;
                        throw svne;
                    }
                }
                if (!supportsPartialReplay) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_PARTIAL_REPLAY_NOT_SUPPORTED);
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                }
            }
            toRepos.setRevisionPropertyValue(0L, "svn:sync-from-url", SVNPropertyValue.create(fromURL.toDecodedString()));
            String uuid = fromRepos.getRepositoryUUID(true);
            toRepos.setRevisionPropertyValue(0L, "svn:sync-from-uuid", SVNPropertyValue.create(uuid));
            toRepos.setRevisionPropertyValue(0L, "svn:sync-last-merged-rev", SVNPropertyValue.create("0"));
            SVNProperties normalizedProps = this.copyRevisionProperties(fromRepos, toRepos, 0L, false);
            this.handleNormalizedProperties(normalizedProps.size(), 0);
        }
        catch (SVNException svne) {
            error = svne;
        }
        finally {
            try {
                this.unlock(toRepos);
                if (toRepos != null) {
                    toRepos.closeSession();
                }
                if (fromRepos != null) {
                    fromRepos.closeSession();
                }
            }
            catch (SVNException svne) {
                error2 = svne;
            }
        }
        if (error != null) {
            throw error;
        }
        if (error2 != null) {
            throw error2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNSyncInfo doInfo(SVNURL toURL) throws SVNException {
        SVNRepository toRepos = null;
        try {
            toRepos = this.createRepository(toURL, null, true);
            this.checkIfRepositoryIsAtRoot(toRepos, toURL);
            SVNPropertyValue fromURL = toRepos.getRevisionPropertyValue(0L, "svn:sync-from-url");
            if (fromURL == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Repository ''{0}'' is not initialized for synchronization", toURL);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            SVNPropertyValue fromUUID = toRepos.getRevisionPropertyValue(0L, "svn:sync-from-uuid");
            SVNPropertyValue lastMergedRevProp = toRepos.getRevisionPropertyValue(0L, "svn:sync-last-merged-rev");
            long lastMergedRev = lastMergedRevProp != null ? Long.parseLong(lastMergedRevProp.getString()) : -1L;
            SVNSyncInfo sVNSyncInfo = new SVNSyncInfo(fromURL.getString(), fromUUID != null ? fromUUID.getString() : null, lastMergedRev);
            return sVNSyncInfo;
        }
        finally {
            if (toRepos != null) {
                toRepos.closeSession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPack(File repositoryRoot) throws SVNException {
        FSFS fsfs = SVNAdminHelper.openRepository(repositoryRoot, true);
        try {
            FSPacker packer = new FSPacker(this.myEventHandler);
            packer.pack(fsfs);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCompleteSynchronize(SVNURL fromURL, SVNURL toURL) throws SVNException {
        try {
            this.doInitialize(fromURL, toURL);
            this.doSynchronize(toURL);
            return;
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() != SVNErrorCode.RA_NOT_IMPLEMENTED) {
                throw svne;
            }
            SVNRepositoryReplicator replicator = SVNRepositoryReplicator.newInstance();
            SVNRepository fromRepos = null;
            SVNRepository toRepos = null;
            try {
                fromRepos = this.createRepository(fromURL, null, true);
                toRepos = this.createRepository(toURL, null, false);
                replicator.replicateRepository(fromRepos, toRepos, 1L, -1L);
            }
            finally {
                if (fromRepos != null) {
                    fromRepos.closeSession();
                }
                if (toRepos != null) {
                    toRepos.closeSession();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSynchronize(SVNURL toURL) throws SVNException {
        SVNRepository toRepos = null;
        SVNRepository fromRepos = null;
        SVNException error = null;
        SVNException error2 = null;
        try {
            toRepos = this.createRepository(toURL, null, true);
            this.checkIfRepositoryIsAtRoot(toRepos, toURL);
            this.lock(toRepos);
            SessionInfo info = this.openSourceRepository(toRepos);
            fromRepos = info.myRepository;
            long lastMergedRevision = info.myLastMergedRevision;
            SVNPropertyValue currentlyCopying = toRepos.getRevisionPropertyValue(0L, "svn:sync-currently-copying");
            long toLatestRevision = toRepos.getLatestRevision();
            int normalizedRevPropsCount = 0;
            if (currentlyCopying != null) {
                long copyingRev = -1L;
                try {
                    copyingRev = Long.parseLong(currentlyCopying.getString());
                }
                catch (NumberFormatException nfe) {
                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, nfe), SVNLogType.WC);
                }
                if (copyingRev < lastMergedRevision || copyingRev > lastMergedRevision + 1L || toLatestRevision != lastMergedRevision && toLatestRevision != copyingRev) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Revision being currently copied ({0}), last merged revision ({1}), and destination HEAD ({2}) are inconsistent; have you committed to the destination without using svnsync?", new Object[]{String.valueOf(copyingRev), String.valueOf(lastMergedRevision), String.valueOf(toLatestRevision)});
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                } else if (copyingRev == toLatestRevision) {
                    if (copyingRev > lastMergedRevision) {
                        SVNProperties normalizedProps = this.copyRevisionProperties(fromRepos, toRepos, toLatestRevision, true);
                        normalizedRevPropsCount += normalizedProps.size();
                        lastMergedRevision = copyingRev;
                    }
                    toRepos.setRevisionPropertyValue(0L, "svn:sync-last-merged-rev", SVNPropertyValue.create(SVNProperty.toString(lastMergedRevision)));
                    toRepos.setRevisionPropertyValue(0L, "svn:sync-currently-copying", null);
                }
            } else if (toLatestRevision != lastMergedRevision) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Destination HEAD ({0}) is not the last merged revision ({1}); have you committed to the destination without using svnsync?", new Object[]{String.valueOf(toLatestRevision), String.valueOf(lastMergedRevision)});
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            long fromLatestRevision = fromRepos.getLatestRevision();
            if (fromLatestRevision < lastMergedRevision) {
                return;
            }
            boolean hasCommitRevPropCapability = toRepos.hasCapability(SVNCapability.COMMIT_REVPROPS);
            this.checkCancelled();
            long startRevision = lastMergedRevision + 1L;
            long endRevision = fromLatestRevision;
            SVNReplayHandler replayHandler = new SVNReplayHandler(toRepos, hasCommitRevPropCapability, this.mySyncHandler, this.getDebugLog(), this, this);
            fromRepos.replayRange(startRevision, endRevision, 0L, true, replayHandler);
            this.handleNormalizedProperties(normalizedRevPropsCount + replayHandler.getNormalizedRevPropsCount(), replayHandler.getNormalizedNodePropsCount());
        }
        catch (SVNException svne) {
            error = svne;
        }
        finally {
            try {
                this.unlock(toRepos);
                if (toRepos != null) {
                    toRepos.closeSession();
                }
                if (fromRepos != null) {
                    fromRepos.closeSession();
                }
            }
            catch (SVNException svne) {
                error2 = svne;
            }
        }
        if (error != null) {
            throw error;
        }
        if (error2 != null) {
            throw error2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doListLocks(File repositoryRoot) throws SVNException {
        FSFS fsfs = SVNAdminHelper.openRepository(repositoryRoot, true);
        try {
            File digestFile = fsfs.getDigestFileFromRepositoryPath("/");
            ISVNLockHandler handler = new ISVNLockHandler(){

                public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                    SVNAdminClient.this.checkCancelled();
                    if (SVNAdminClient.this.myEventHandler != null) {
                        SVNAdminEvent event = new SVNAdminEvent(SVNAdminEventAction.LOCK_LISTED, lock, error, null);
                        SVNAdminClient.this.myEventHandler.handleAdminEvent(event, -1.0);
                    }
                }

                public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                }
            };
            fsfs.walkDigestFiles(digestFile, handler, false);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveLocks(File repositoryRoot, String[] paths) throws SVNException {
        if (paths == null) {
            return;
        }
        FSFS fsfs = SVNAdminHelper.openRepository(repositoryRoot, true);
        try {
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                if (path == null) continue;
                this.checkCancelled();
                SVNLock lock = null;
                try {
                    SVNAdminEvent event;
                    lock = fsfs.getLockHelper(path, false);
                    if (lock == null) {
                        if (this.myEventHandler == null) continue;
                        event = new SVNAdminEvent(SVNAdminEventAction.NOT_LOCKED, null, null, "Path '" + path + "' isn't locked.");
                        this.myEventHandler.handleAdminEvent(event, -1.0);
                        continue;
                    }
                    fsfs.unlockPath(path, lock.getID(), null, true, false);
                    if (this.myEventHandler == null) continue;
                    event = new SVNAdminEvent(SVNAdminEventAction.UNLOCKED, lock, null, "Removed lock on '" + path + "'.");
                    this.myEventHandler.handleAdminEvent(event, -1.0);
                    continue;
                }
                catch (SVNException svne) {
                    if (this.myEventHandler == null) continue;
                    SVNAdminEvent event = new SVNAdminEvent(SVNAdminEventAction.UNLOCK_FAILED, lock, svne.getErrorMessage(), "svnadmin: " + svne.getErrorMessage().getFullMessage());
                    this.myEventHandler.handleAdminEvent(event, -1.0);
                }
            }
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doListTransactions(File repositoryRoot) throws SVNException {
        FSFS fsfs = SVNAdminHelper.openRepository(repositoryRoot, true);
        try {
            Map txns = fsfs.listTransactions();
            Iterator names = txns.keySet().iterator();
            while (names.hasNext()) {
                String txnName = (String)names.next();
                File txnDir = (File)txns.get(txnName);
                if (this.myEventHandler == null) continue;
                SVNAdminEvent event = new SVNAdminEvent(txnName, txnDir, SVNAdminEventAction.TRANSACTION_LISTED);
                this.myEventHandler.handleAdminEvent(event, -1.0);
            }
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRemoveTransactions(File repositoryRoot, String[] transactions) throws SVNException {
        if (transactions == null) {
            return;
        }
        FSFS fsfs = SVNAdminHelper.openRepository(repositoryRoot, true);
        try {
            for (int i = 0; i < transactions.length; ++i) {
                String txnName = transactions[i];
                fsfs.openTxn(txnName);
                fsfs.purgeTxn(txnName);
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.FSFS, "Transaction '" + txnName + "' removed.\n");
                if (this.myEventHandler == null) continue;
                SVNAdminEvent event = new SVNAdminEvent(txnName, fsfs.getTransactionDir(txnName), SVNAdminEventAction.TRANSACTION_REMOVED);
                this.myEventHandler.handleAdminEvent(event, -1.0);
            }
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public void doVerify(File repositoryRoot) throws SVNException {
        this.doVerify(repositoryRoot, SVNRevision.create(0L), SVNRevision.HEAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doVerify(File repositoryRoot, SVNRevision startRevision, SVNRevision endRevision) throws SVNException {
        FSFS fsfs = SVNAdminHelper.openRepository(repositoryRoot, true);
        try {
            long youngestRevision = fsfs.getYoungestRevision();
            long lowerRev = SVNAdminHelper.getRevisionNumber(startRevision, youngestRevision, fsfs);
            long upperRev = SVNAdminHelper.getRevisionNumber(endRevision, youngestRevision, fsfs);
            if (!SVNRevision.isValidRevisionNumber(upperRev)) {
                upperRev = lowerRev;
            }
            this.verify(fsfs, lowerRev, upperRev);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDump(File repositoryRoot, OutputStream dumpStream, SVNRevision startRevision, SVNRevision endRevision, boolean isIncremental, boolean useDeltas) throws SVNException {
        FSFS fsfs = SVNAdminHelper.openRepository(repositoryRoot, true);
        try {
            long youngestRevision = fsfs.getYoungestRevision();
            long lowerR = SVNAdminHelper.getRevisionNumber(startRevision, youngestRevision, fsfs);
            long upperR = SVNAdminHelper.getRevisionNumber(endRevision, youngestRevision, fsfs);
            if (!SVNRevision.isValidRevisionNumber(lowerR)) {
                lowerR = 0L;
                upperR = youngestRevision;
            } else if (!SVNRevision.isValidRevisionNumber(upperR)) {
                upperR = lowerR;
            }
            if (lowerR > upperR) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "First revision cannot be higher than second");
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            this.dump(fsfs, dumpStream, lowerR, upperR, isIncremental, useDeltas);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public void doLoad(File repositoryRoot, InputStream dumpStream) throws SVNException {
        this.doLoad(repositoryRoot, dumpStream, false, false, SVNUUIDAction.DEFAULT, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoad(File repositoryRoot, InputStream dumpStream, boolean usePreCommitHook, boolean usePostCommitHook, SVNUUIDAction uuidAction, String parentDir) throws SVNException {
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        FSFS fsfs = null;
        try {
            fsfs = SVNAdminHelper.openRepository(repositoryRoot, true);
            DefaultLoadHandler handler = this.createLoadHandler(fsfs, usePreCommitHook, usePostCommitHook, uuidAction, parentDir);
            SVNDumpStreamParser parser = this.getDumpStreamParser();
            parser.parseDumpStream(dumpStream, handler, decoder);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRecover(File repositoryRoot) throws SVNException {
        FSFS fsfs = null;
        try {
            fsfs = SVNAdminHelper.openRepositoryForRecovery(repositoryRoot);
            if (this.myEventHandler != null) {
                SVNAdminEvent event = new SVNAdminEvent(SVNAdminEventAction.RECOVERY_STARTED);
                this.myEventHandler.handleAdminEvent(event, -1.0);
            }
            FSRecoverer recoverer = new FSRecoverer(fsfs, this);
            recoverer.runRecovery();
        }
        finally {
            if (fsfs != null) {
                fsfs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpgrade(File repositoryRoot) throws SVNException {
        FSFS fsfs = SVNAdminHelper.openRepository(repositoryRoot, true);
        try {
            if (this.myEventHandler != null) {
                SVNAdminEvent event = new SVNAdminEvent(SVNAdminEventAction.UPGRADE);
                this.myEventHandler.handleAdminEvent(event, -1.0);
            }
            File reposFormatFile = fsfs.getRepositoryFormatFile();
            int format = fsfs.getReposFormat();
            SVNFileUtil.writeVersionFile(reposFormatFile, format);
            fsfs.upgrade();
            SVNFileUtil.writeVersionFile(reposFormatFile, 5);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSetUUID(File repositoryRoot, String uuid) throws SVNException {
        FSFS fsfs = SVNAdminHelper.openRepository(repositoryRoot, true);
        try {
            if (uuid == null) {
                uuid = SVNUUIDGenerator.generateUUIDString();
            } else {
                String[] components = uuid.split("-");
                if (components.length != 5) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_UUID, "Malformed UUID ''{0}''", uuid);
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                }
            }
            fsfs.setUUID(uuid);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHotCopy(File srcRepositoryRoot, File newRepositoryRoot) throws SVNException {
        FSFS fsfs = SVNAdminHelper.openRepository(srcRepositoryRoot, false);
        try {
            FSHotCopier copier = this.getHotCopier();
            copier.runHotCopy(fsfs, newRepositoryRoot);
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getYoungestRevision(File repositoryRoot) throws SVNException {
        FSFS fsfs = SVNAdminHelper.openRepository(repositoryRoot, true);
        try {
            long l = fsfs.getYoungestRevision();
            return l;
        }
        finally {
            SVNAdminHelper.closeRepository(fsfs);
        }
    }

    public void doFilter(InputStream dumpStream, OutputStream resultDumpStream, boolean exclude, boolean renumberRevisions, boolean dropEmptyRevisions, boolean preserveRevisionProperties, Collection prefixes, boolean skipMissingMergeSources) throws SVNException {
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        this.writeDumpData(resultDumpStream, "SVN-fs-dump-format-version: 2\n\n");
        DefaultDumpFilterHandler handler = this.getDumpFilterHandler(resultDumpStream, exclude, renumberRevisions, dropEmptyRevisions, preserveRevisionProperties, prefixes, skipMissingMergeSources);
        SVNDumpStreamParser parser = this.getDumpStreamParser();
        parser.parseDumpStream(dumpStream, handler, decoder);
        if (this.myEventHandler != null) {
            Map droppedNodes;
            if (handler.getDroppedRevisionsCount() > 0L) {
                String message = MessageFormat.format("Dropped {0} revision(s).", String.valueOf(handler.getDroppedRevisionsCount()));
                SVNAdminEvent event = new SVNAdminEvent(SVNAdminEventAction.DUMP_FILTER_TOTAL_REVISIONS_DROPPED, message);
                event.setDroppedRevisionsCount(handler.getDroppedRevisionsCount());
                this.myEventHandler.handleAdminEvent(event, -1.0);
            }
            if (renumberRevisions) {
                Map renumberHistory = handler.getRenumberHistory();
                Object[] reNumberedRevisions = renumberHistory.keySet().toArray(new Long[renumberHistory.size()]);
                Arrays.sort(reNumberedRevisions);
                for (int i = reNumberedRevisions.length; i > 0; --i) {
                    SVNAdminEvent event;
                    String message;
                    Object revision = reNumberedRevisions[i - 1];
                    DefaultDumpFilterHandler.RevisionItem revItem = (DefaultDumpFilterHandler.RevisionItem)renumberHistory.get(revision);
                    if (revItem.wasDropped()) {
                        message = MessageFormat.format("{0} => (dropped)", ((Long)revision).toString());
                        event = new SVNAdminEvent((Long)revision, SVNAdminEventAction.DUMP_FILTER_DROPPED_RENUMBERED_REVISION, message);
                        this.myEventHandler.handleAdminEvent(event, -1.0);
                        continue;
                    }
                    message = MessageFormat.format("{0} => {1}", ((Long)revision).toString(), String.valueOf(revItem.getRevision()));
                    event = new SVNAdminEvent(revItem.getRevision(), (Long)revision, SVNAdminEventAction.DUMP_FILTER_RENUMBERED_REVISION, message);
                    this.myEventHandler.handleAdminEvent(event, -1.0);
                }
            }
            if (!(droppedNodes = handler.getDroppedNodes()).isEmpty()) {
                String message = MessageFormat.format("Dropped {0} node(s)", String.valueOf(droppedNodes.size()));
                SVNAdminEvent event = new SVNAdminEvent(SVNAdminEventAction.DUMP_FILTER_TOTAL_NODES_DROPPED, message);
                event.setDroppedNodesCount(droppedNodes.size());
                this.myEventHandler.handleAdminEvent(event, -1.0);
                String[] paths = droppedNodes.keySet().toArray(new String[droppedNodes.size()]);
                Arrays.sort(paths, SVNPathUtil.PATH_COMPARATOR);
                for (int i = 0; i < paths.length; ++i) {
                    String path = paths[i];
                    message = "'" + path + "'";
                    event = new SVNAdminEvent(SVNAdminEventAction.DUMP_FILTER_DROPPED_NODE, path, message);
                    this.myEventHandler.handleAdminEvent(event, -1.0);
                }
            }
        }
    }

    protected void handlePropertesCopied(boolean foundSyncProps, long revision) throws SVNException {
        if (this.myEventHandler != null) {
            String message = null;
            message = foundSyncProps ? MessageFormat.format("Copied properties for revision {0} ({1}* properties skipped).", String.valueOf(revision), "svn:sync-") : MessageFormat.format("Copied properties for revision {0}.", String.valueOf(revision));
            SVNAdminEvent event = new SVNAdminEvent(revision, SVNAdminEventAction.REVISION_PROPERTIES_COPIED, message);
            this.myEventHandler.handleAdminEvent(event, -1.0);
        }
    }

    protected void handleNormalizedProperties(int normalizedRevPropsCount, int normalizedNodePropsCount) throws SVNException {
        if (this.myEventHandler != null && (normalizedRevPropsCount > 0 || normalizedNodePropsCount > 0)) {
            String message = MessageFormat.format("NOTE: Normalized {0}* properties to LF line endings ({1} rev-props, {2} node-props).", "svn:", String.valueOf(normalizedRevPropsCount), String.valueOf(normalizedNodePropsCount));
            SVNAdminEvent event = new SVNAdminEvent(SVNAdminEventAction.NORMALIZED_PROPERTIES, message);
            this.myEventHandler.handleAdminEvent(event, -1.0);
        }
    }

    private FSHotCopier getHotCopier() {
        if (this.myHotCopier == null) {
            this.myHotCopier = new FSHotCopier();
        }
        return this.myHotCopier;
    }

    private void verify(FSFS fsfs, long startRev, long endRev) throws SVNException {
        SVNErrorMessage err;
        long youngestRev = fsfs.getYoungestRevision();
        if (!SVNRevision.isValidRevisionNumber(startRev)) {
            startRev = 0L;
        }
        if (!SVNRevision.isValidRevisionNumber(endRev)) {
            endRev = youngestRev;
        }
        if (startRev > endRev) {
            err = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "Start revision {0} is greater than end revision {1}", new Object[]{String.valueOf(startRev), String.valueOf(endRev)});
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (endRev > youngestRev) {
            err = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "End revision {0} is invalid (youngest revision is {1})", new Object[]{String.valueOf(endRev), String.valueOf(youngestRev)});
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        for (long rev = startRev; rev <= endRev; ++rev) {
            FSRevisionRoot toRoot = fsfs.createRevisionRoot(rev);
            ISVNEditor editor = this.getDumpEditor(fsfs, toRoot, rev, startRev, "/", SVNFileUtil.DUMMY_OUT, false, true);
            editor = SVNCancellableEditor.newInstance(editor, this.getEventDispatcher(), this.getDebugLog());
            FSRepositoryUtil.replay(fsfs, toRoot, "", -1L, false, editor);
            fsfs.getRevisionProperties(rev);
            String message = "* Verified revision " + rev + ".";
            if (this.myEventHandler == null) continue;
            SVNAdminEvent event = new SVNAdminEvent(rev, SVNAdminEventAction.REVISION_DUMPED, message);
            this.myEventHandler.handleAdminEvent(event, -1.0);
        }
    }

    private void dump(FSFS fsfs, OutputStream dumpStream, long start, long end, boolean isIncremental, boolean useDeltas) throws SVNException {
        SVNErrorMessage err;
        boolean isDumping = dumpStream != null && dumpStream != SVNFileUtil.DUMMY_OUT;
        long youngestRevision = fsfs.getYoungestRevision();
        SVNAdminDeltifier deltifier = new SVNAdminDeltifier(fsfs, SVNDepth.INFINITY, false, false, false, null);
        if (!SVNRevision.isValidRevisionNumber(start)) {
            start = 0L;
        }
        if (!SVNRevision.isValidRevisionNumber(end)) {
            end = youngestRevision;
        }
        if (dumpStream == null) {
            dumpStream = SVNFileUtil.DUMMY_OUT;
        }
        if (start > end) {
            err = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "Start revision {0} is greater than end revision {1}", new Object[]{String.valueOf(start), String.valueOf(end)});
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (end > youngestRevision) {
            err = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "End revision {0} is invalid (youngest revision is {1})", new Object[]{String.valueOf(end), String.valueOf(youngestRevision)});
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (start == 0L && isIncremental) {
            isIncremental = false;
        }
        String uuid = fsfs.getUUID();
        int version = 3;
        if (!useDeltas) {
            --version;
        }
        this.writeDumpData(dumpStream, "SVN-fs-dump-format-version: " + version + "\n\n");
        this.writeDumpData(dumpStream, "UUID: " + uuid + "\n\n");
        for (long i = start; i <= end; ++i) {
            long fromRev;
            long toRev;
            this.checkCancelled();
            if (i == start && !isIncremental) {
                if (i == 0L) {
                    this.writeRevisionRecord(dumpStream, fsfs, 0L);
                    toRev = 0L;
                    String message = (isDumping ? "* Dumped" : "* Verified") + " revision " + toRev + ".";
                    if (this.myEventHandler == null) continue;
                    SVNAdminEvent event = new SVNAdminEvent(toRev, SVNAdminEventAction.REVISION_DUMPED, message);
                    this.myEventHandler.handleAdminEvent(event, -1.0);
                    continue;
                }
                fromRev = 0L;
                toRev = i;
            } else {
                fromRev = i - 1L;
                toRev = i;
            }
            this.writeRevisionRecord(dumpStream, fsfs, toRev);
            boolean useDeltasForRevision = useDeltas && (isIncremental || i != start);
            FSRevisionRoot toRoot = fsfs.createRevisionRoot(toRev);
            SVNDumpEditor dumpEditor = this.getDumpEditor(fsfs, toRoot, toRev, start, "/", dumpStream, useDeltasForRevision, false);
            if (i == start && !isIncremental) {
                FSRevisionRoot fromRoot = fsfs.createRevisionRoot(fromRev);
                deltifier.setEditor(dumpEditor);
                deltifier.deltifyDir(fromRoot, "/", "", toRoot, "/");
            } else {
                FSRepositoryUtil.replay(fsfs, toRoot, "", -1L, false, dumpEditor);
            }
            String message = (isDumping ? "* Dumped" : "* Verified") + " revision " + toRev + ".";
            if (this.myEventHandler == null) continue;
            SVNAdminEvent event = new SVNAdminEvent(toRev, SVNAdminEventAction.REVISION_DUMPED, message);
            this.myEventHandler.handleAdminEvent(event, -1.0);
        }
    }

    private void writeRevisionRecord(OutputStream dumpStream, FSFS fsfs, long revision) throws SVNException {
        SVNProperties revProps = fsfs.getRevisionProperties(revision);
        String revisionDate = revProps.getStringValue("svn:date");
        if (revisionDate != null) {
            SVNDate date = SVNDate.parseDate(revisionDate);
            revProps.put("svn:date", date.format());
        }
        ByteArrayOutputStream encodedProps = new ByteArrayOutputStream();
        SVNAdminHelper.writeProperties(revProps, null, encodedProps);
        this.writeDumpData(dumpStream, "Revision-number: " + revision + "\n");
        String propContents = null;
        try {
            propContents = new String(encodedProps.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, uee.getLocalizedMessage());
            SVNErrorManager.error(err, uee, SVNLogType.FSFS);
        }
        this.writeDumpData(dumpStream, "Prop-content-length: " + propContents.length() + "\n");
        this.writeDumpData(dumpStream, "Content-length: " + propContents.length() + "\n\n");
        this.writeDumpData(dumpStream, propContents);
        this.writeDumpData(dumpStream, "\n");
    }

    private void writeDumpData(OutputStream out, String data) throws SVNException {
        try {
            out.write(data.getBytes("UTF-8"));
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
        }
    }

    private DefaultLoadHandler createLoadHandler(FSFS fsfs, boolean usePreCommitHook, boolean usePostCommitHook, SVNUUIDAction uuidAction, String parentDir) {
        DefaultLoadHandler handler = new DefaultLoadHandler(usePreCommitHook, usePostCommitHook, uuidAction, parentDir, this.myEventHandler);
        handler.setFSFS(fsfs);
        handler.setUsePreCommitHook(usePreCommitHook);
        handler.setUsePostCommitHook(usePostCommitHook);
        handler.setUUIDAction(uuidAction);
        handler.setParentDir(parentDir);
        return handler;
    }

    private DefaultDumpFilterHandler getDumpFilterHandler(OutputStream os, boolean exclude, boolean renumberRevisions, boolean dropEmptyRevisions, boolean preserveRevisionProperties, Collection prefixes, boolean skipMissingMergeSources) {
        if (this.myDumpFilterHandler == null) {
            this.myDumpFilterHandler = new DefaultDumpFilterHandler(os, this.myEventHandler, exclude, renumberRevisions, dropEmptyRevisions, preserveRevisionProperties, prefixes, skipMissingMergeSources);
        } else {
            this.myDumpFilterHandler.reset(os, this.myEventHandler, exclude, renumberRevisions, dropEmptyRevisions, preserveRevisionProperties, prefixes, skipMissingMergeSources);
        }
        return this.myDumpFilterHandler;
    }

    private SVNDumpStreamParser getDumpStreamParser() {
        if (this.myDumpStreamParser == null) {
            this.myDumpStreamParser = new SVNDumpStreamParser(this);
        }
        return this.myDumpStreamParser;
    }

    private SVNDumpEditor getDumpEditor(FSFS fsfs, FSRoot root, long toRevision, long oldestDumpedRevision, String rootPath, OutputStream dumpStream, boolean useDeltas, boolean isVerify) {
        if (this.myDumpEditor == null) {
            this.myDumpEditor = new SVNDumpEditor(fsfs, root, toRevision, oldestDumpedRevision, rootPath, dumpStream, useDeltas, isVerify);
        } else {
            this.myDumpEditor.reset(fsfs, root, toRevision, oldestDumpedRevision, rootPath, dumpStream, useDeltas, isVerify);
        }
        return this.myDumpEditor;
    }

    private SVNProperties copyRevisionProperties(SVNRepository fromRepository, SVNRepository toRepository, long revision, boolean sync) throws SVNException {
        int filteredCount = 0;
        SVNProperties existingRevProps = null;
        if (sync) {
            existingRevProps = toRepository.getRevisionProperties(revision, null);
        }
        SVNProperties revProps = fromRepository.getRevisionProperties(revision, null);
        SVNProperties normalizedProps = SVNAdminClient.normalizeRevisionProperties(revProps);
        filteredCount += SVNAdminHelper.writeRevisionProperties(toRepository, revision, revProps);
        if (sync) {
            SVNAdminHelper.removePropertiesNotInSource(toRepository, revision, revProps, existingRevProps);
        }
        this.handlePropertesCopied(filteredCount > 0, revision);
        return normalizedProps;
    }

    private SessionInfo openSourceRepository(SVNRepository targetRepos) throws SVNException {
        SVNPropertyValue fromURL = targetRepos.getRevisionPropertyValue(0L, "svn:sync-from-url");
        SVNPropertyValue fromUUID = targetRepos.getRevisionPropertyValue(0L, "svn:sync-from-uuid");
        SVNPropertyValue lastMergedRev = targetRepos.getRevisionPropertyValue(0L, "svn:sync-last-merged-rev");
        if (fromURL == null || fromUUID == null || lastMergedRev == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Destination repository has not been initialized");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        SVNURL srcURL = SVNURL.parseURIDecoded(fromURL.getString());
        SVNRepository srcRepos = this.createRepository(srcURL, fromUUID.getString(), false);
        try {
            return new SessionInfo(srcRepos, Long.parseLong(lastMergedRev.getString()));
        }
        catch (NumberFormatException nfe) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, nfe), SVNLogType.FSFS);
            return null;
        }
    }

    private void checkIfRepositoryIsAtRoot(SVNRepository repos, SVNURL url) throws SVNException {
        SVNURL reposRoot = repos.getRepositoryRoot(true);
        if (!reposRoot.equals(url)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Session is rooted at ''{0}'' but the repos root is ''{1}''", new SVNURL[]{url, reposRoot});
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
    }

    private void lock(SVNRepository repos) throws SVNException {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Can't get local hostname");
            SVNErrorManager.error(err, e, SVNLogType.FSFS);
        }
        if (hostName.length() > 256) {
            hostName = hostName.substring(0, 256);
        }
        String lockToken = hostName + ":" + SVNUUIDGenerator.formatUUID(SVNUUIDGenerator.generateUUID());
        int i = 0;
        SVNErrorMessage childError = null;
        for (i = 0; i < 10; ++i) {
            this.checkCancelled();
            SVNPropertyValue reposLockToken = repos.getRevisionPropertyValue(0L, "svn:sync-lock");
            if (reposLockToken != null) {
                if (lockToken.equals(reposLockToken.getString())) {
                    return;
                }
                childError = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Failed to get lock on destination repos, currently held by ''{0}''", reposLockToken.getString());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
                continue;
            }
            if (i >= 9) continue;
            repos.setRevisionPropertyValue(0L, "svn:sync-lock", SVNPropertyValue.create(lockToken));
        }
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Couldn''t get lock on destination repos after {0} attempts", String.valueOf(i));
        if (childError != null) {
            err.setChildErrorMessage(childError);
        }
        SVNErrorManager.error(err, SVNLogType.FSFS);
    }

    private void unlock(SVNRepository repos) throws SVNException {
        repos.setRevisionPropertyValue(0L, "svn:sync-lock", null);
    }

    public static SVNProperties normalizeRevisionProperties(SVNProperties revProps) throws SVNException {
        SVNProperties normalizedProps = new SVNProperties();
        Iterator propNamesIter = revProps.nameSet().iterator();
        while (propNamesIter.hasNext()) {
            SVNPropertyValue value;
            String normalizedValue;
            String propName = (String)propNamesIter.next();
            if (!SVNPropertiesManager.propNeedsTranslation(propName) || (normalizedValue = SVNAdminClient.normalizeString(SVNPropertyValue.getPropertyAsString(value = revProps.getSVNPropertyValue(propName)))) == null) continue;
            normalizedProps.put(propName, SVNPropertyValue.create(normalizedValue));
        }
        revProps.putAll(normalizedProps);
        return normalizedProps;
    }

    public static String normalizeString(String string) throws SVNException {
        if (string != null && string.indexOf(SVNProperty.EOL_CR_BYTES[0]) != -1) {
            return SVNTranslator.transalteString(string, SVNProperty.EOL_LF_BYTES, null, true, false);
        }
        return null;
    }

    private class SessionInfo {
        SVNRepository myRepository;
        long myLastMergedRevision;

        public SessionInfo(SVNRepository repos, long lastMergedRev) {
            this.myRepository = repos;
            this.myLastMergedRevision = lastMergedRev;
        }
    }
}

