/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Random;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNUUIDGenerator {
    private static final int NODE_LENGTH = 6;
    private static byte[] ourUUIDStateNode = new byte[6];
    private static long ourUUIDStateSeqNum;
    private static long ourLastGeneratedTime;
    private static long ourFudgeFactor;

    private static long getCurrentTime() {
        long l = System.currentTimeMillis();
        if (ourLastGeneratedTime != l) {
            ourFudgeFactor = ourLastGeneratedTime + ourFudgeFactor > l ? ourLastGeneratedTime + ourFudgeFactor - l + 1L : 0L;
            ourLastGeneratedTime = l;
        } else {
            ++ourFudgeFactor;
        }
        return l + ourFudgeFactor;
    }

    public static String generateUUIDString() throws SVNException {
        return SVNUUIDGenerator.formatUUID(SVNUUIDGenerator.generateUUID());
    }

    public static synchronized byte[] generateUUID() throws SVNException {
        if (ourUUIDStateNode[0] == 0) {
            SVNUUIDGenerator.initState();
        }
        long l = SVNUUIDGenerator.getCurrentTime();
        byte[] byArray = new byte[16];
        byArray[0] = (byte)l;
        byArray[1] = (byte)(l >> 8);
        byArray[2] = (byte)(l >> 16);
        byArray[3] = (byte)(l >> 24);
        byArray[4] = (byte)(l >> 32);
        byArray[5] = (byte)(l >> 40);
        byArray[6] = (byte)(l >> 48);
        byArray[7] = (byte)(l >> 56 & 0xFL | 0x10L);
        byArray[8] = (byte)(ourUUIDStateSeqNum >> 8 & 0x3FL | 0x80L);
        byArray[9] = (byte)ourUUIDStateSeqNum;
        System.arraycopy(ourUUIDStateNode, 0, byArray, 10, 6);
        return byArray;
    }

    public static String formatUUID(byte[] byArray) {
        Object object;
        if (byArray.length < 16) {
            object = new byte[16];
            Arrays.fill((byte[])object, (byte)0);
            System.arraycopy(byArray, 0, object, 0, byArray.length);
            byArray = object;
        }
        object = new StringBuffer();
        SVNFormatUtil.appendHexNumber((StringBuffer)object, byArray[0]);
        SVNFormatUtil.appendHexNumber((StringBuffer)object, byArray[1]);
        SVNFormatUtil.appendHexNumber((StringBuffer)object, byArray[2]);
        SVNFormatUtil.appendHexNumber((StringBuffer)object, byArray[3]);
        ((StringBuffer)object).append('-');
        SVNFormatUtil.appendHexNumber((StringBuffer)object, byArray[4]);
        SVNFormatUtil.appendHexNumber((StringBuffer)object, byArray[5]);
        ((StringBuffer)object).append('-');
        SVNFormatUtil.appendHexNumber((StringBuffer)object, byArray[6]);
        SVNFormatUtil.appendHexNumber((StringBuffer)object, byArray[7]);
        ((StringBuffer)object).append('-');
        SVNFormatUtil.appendHexNumber((StringBuffer)object, byArray[8]);
        SVNFormatUtil.appendHexNumber((StringBuffer)object, byArray[9]);
        ((StringBuffer)object).append('-');
        SVNFormatUtil.appendHexNumber((StringBuffer)object, byArray[10]);
        SVNFormatUtil.appendHexNumber((StringBuffer)object, byArray[11]);
        SVNFormatUtil.appendHexNumber((StringBuffer)object, byArray[12]);
        SVNFormatUtil.appendHexNumber((StringBuffer)object, byArray[13]);
        SVNFormatUtil.appendHexNumber((StringBuffer)object, byArray[14]);
        SVNFormatUtil.appendHexNumber((StringBuffer)object, byArray[15]);
        return ((StringBuffer)object).toString();
    }

    private static void initState() throws SVNException {
        long l = System.currentTimeMillis() * 10L + 122192928000000000L;
        Random random = new Random();
        random.setSeed((l >> 32 ^ l) & 0xFFFFFFFFL);
        ourUUIDStateSeqNum = random.nextLong() & 0xFFFFL;
        SVNUUIDGenerator.getRandomInfo(ourUUIDStateNode);
    }

    private static void getRandomInfo(byte[] byArray) throws SVNException {
        Double d = Math.random();
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "MD5 implementation not found: {0}", noSuchAlgorithmException.getLocalizedMessage());
            SVNErrorManager.error(sVNErrorMessage, noSuchAlgorithmException, SVNLogType.DEFAULT);
        }
        messageDigest.update(d.toString().getBytes());
        byte[] byArray2 = messageDigest.digest();
        int n = byArray.length < byArray2.length ? byArray.length : byArray2.length;
        System.arraycopy(byArray2, 0, byArray, 0, n);
        byArray[0] = (byte)(byArray[0] | 1);
    }
}

