/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util.jna;

import java.io.File;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.jna.SVNGnomeKeyring;
import org.tmatesoft.svn.core.internal.util.jna.SVNLinuxUtil;
import org.tmatesoft.svn.core.internal.util.jna.SVNMacOsKeychain;
import org.tmatesoft.svn.core.internal.util.jna.SVNWin32Util;
import org.tmatesoft.svn.core.internal.util.jna.SVNWinCrypt;
import org.tmatesoft.svn.core.internal.wc.ISVNGnomeKeyringPasswordProvider;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public class SVNJNAUtil {
    private static boolean ourIsJNAEnabled;
    private static boolean ourIsJNAPresent;
    private static final String JNA_CLASS_NAME = "com.sun.jna.Library";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setJNAEnabled(boolean enabled) {
        Class clazz = SVNJNAUtil.class;
        synchronized (clazz) {
            ourIsJNAEnabled = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJNAPresent() {
        Class clazz = SVNJNAUtil.class;
        synchronized (clazz) {
            return ourIsJNAPresent && ourIsJNAEnabled;
        }
    }

    public static SVNFileType getFileType(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.getFileType(file);
        }
        return null;
    }

    public static Boolean isExecutable(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.isExecutable(file);
        }
        return null;
    }

    public static String getLinkTarget(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.getLinkTarget(file);
        }
        return null;
    }

    public static boolean setExecutable(File file, boolean set) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.setExecutable(file, set);
        }
        return false;
    }

    public static boolean setSGID(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.setSGID(file);
        }
        return false;
    }

    public static boolean createSymlink(File file, String linkName) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNLinuxUtil.createSymlink(file, linkName);
        }
        return false;
    }

    public static boolean setWritable(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNFileUtil.isWindows ? SVNWin32Util.setWritable(file) : SVNLinuxUtil.setWritable(file);
        }
        return false;
    }

    public static boolean setHidden(File file) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNWin32Util.setHidden(file);
        }
        return false;
    }

    public static boolean moveFile(File src, File dst) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNWin32Util.moveFile(src, dst);
        }
        return false;
    }

    public static String decrypt(String encryptedData) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNWinCrypt.decrypt(encryptedData);
        }
        return null;
    }

    public static String encrypt(String rawData) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNWinCrypt.encrypt(rawData);
        }
        return null;
    }

    public static boolean addPasswordToMacOsKeychain(String realm, String userName, String password, boolean nonInteractive) throws SVNException {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNMacOsKeychain.setPassword(realm, userName, password, nonInteractive);
        }
        return false;
    }

    public static String getPasswordFromMacOsKeychain(String realm, String userName, boolean nonInteractive) throws SVNException {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNMacOsKeychain.getPassword(realm, userName, nonInteractive);
        }
        return null;
    }

    public static boolean addPasswordToGnomeKeyring(String realm, String userName, String password, boolean nonInteractive, ISVNGnomeKeyringPasswordProvider keyringPasswordProvider) throws SVNException {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNGnomeKeyring.setPassword(realm, userName, password, nonInteractive, keyringPasswordProvider);
        }
        return false;
    }

    public static String getPasswordFromGnomeKeyring(String realm, String userName, boolean nonInteractive, ISVNGnomeKeyringPasswordProvider keyringPasswordProvider) throws SVNException {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNGnomeKeyring.getPassword(realm, userName, nonInteractive, keyringPasswordProvider);
        }
        return null;
    }

    public static synchronized boolean isWinCryptEnabled() {
        return SVNJNAUtil.isJNAPresent() && SVNWinCrypt.isEnabled();
    }

    public static synchronized boolean isMacOsKeychainEnabled() {
        return SVNJNAUtil.isJNAPresent() && SVNMacOsKeychain.isEnabled();
    }

    public static synchronized boolean isGnomeKeyringEnabled() {
        return SVNJNAUtil.isJNAPresent() && SVNGnomeKeyring.isEnabled();
    }

    public static String getApplicationDataPath(boolean common) {
        if (SVNJNAUtil.isJNAPresent()) {
            return SVNWin32Util.getApplicationDataPath(common);
        }
        return null;
    }

    static {
        try {
            ClassLoader loader = SVNJNAUtil.class.getClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            if (loader != null && loader.loadClass(JNA_CLASS_NAME) != null) {
                ourIsJNAPresent = true;
            }
        }
        catch (ClassNotFoundException e) {
            ourIsJNAPresent = false;
        }
        String jnaEnabledProperty = System.getProperty("svnkit.useJNA", "true");
        ourIsJNAEnabled = Boolean.valueOf(jnaEnabledProperty);
    }
}

