/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.Config;
import si.mazi.rescu.HttpMethod;
import si.mazi.rescu.utils.AssertUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpTemplate {
    public static final String CHARSET_UTF_8 = "UTF-8";
    private final Logger log = LoggerFactory.getLogger(HttpTemplate.class);
    private ObjectMapper objectMapper;
    private Map<String, String> defaultHttpHeaders = new HashMap<String, String>();
    private final int readTimeout = Config.getHttpReadTimeout();
    private final Proxy proxy;

    public HttpTemplate() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.defaultHttpHeaders.put("Accept-Charset", CHARSET_UTF_8);
        this.defaultHttpHeaders.put("Content-Type", "application/x-www-form-urlencoded");
        this.defaultHttpHeaders.put("Accept", "text/plain");
        this.defaultHttpHeaders.put("User-Agent", "ResCU JDK/6 AppleWebKit/535.7 Chrome/16.0.912.36 Safari/535.7");
        if (Config.getProxyPort() == null || Config.getProxyHost() == null) {
            this.proxy = Proxy.NO_PROXY;
        } else {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(Config.getProxyHost(), (int)Config.getProxyPort()));
            this.log.info("Using proxy {}", (Object)this.proxy);
        }
    }

    public <T> T executeRequest(String urlString, Class<T> returnType, String requestBody, Map<String, String> httpHeaders, HttpMethod method, String contentType, Class<? extends RuntimeException> exceptionType) throws IOException {
        this.log.debug("Executing {} request at {}", (Object)method, (Object)urlString);
        this.log.trace("Request body = {}", (Object)requestBody);
        this.log.trace("Request headers = {}", httpHeaders);
        AssertUtil.notNull(urlString, "urlString cannot be null");
        AssertUtil.notNull(httpHeaders, "httpHeaders should not be null");
        httpHeaders.put("Accept", "application/json");
        if (contentType != null) {
            httpHeaders.put("Content-Type", contentType);
        }
        int contentLength = requestBody == null ? 0 : requestBody.length();
        HttpURLConnection connection = this.configureURLConnection(method, urlString, httpHeaders, contentLength);
        if (contentLength > 0) {
            connection.getOutputStream().write(requestBody.getBytes(CHARSET_UTF_8));
        }
        String responseEncoding = this.getResponseEncoding(connection);
        int httpStatus = connection.getResponseCode();
        this.log.debug("Request http status = {}", (Object)httpStatus);
        if (httpStatus != 200) {
            String httpBody = this.readInputStreamAsEncodedString(connection.getErrorStream(), responseEncoding);
            this.log.trace("Http call returned {}; response body:\n{}", (Object)httpStatus, (Object)httpBody);
            if (exceptionType != null) {
                throw (RuntimeException)this.objectMapper.readValue(httpBody, exceptionType);
            }
            throw new IOException(String.format("HTTP status code was %d; response body: %s", httpStatus, httpBody));
        }
        InputStream inputStream = connection.getInputStream();
        String responseString = this.readInputStreamAsEncodedString(inputStream, responseEncoding);
        this.log.trace("Response body: {}", (Object)responseString);
        return (T)this.objectMapper.readValue(responseString, returnType);
    }

    private HttpURLConnection configureURLConnection(HttpMethod method, String urlString, Map<String, String> httpHeaders, int contentLength) throws IOException {
        AssertUtil.notNull((Object)method, "method cannot be null");
        AssertUtil.notNull(urlString, "urlString cannot be null");
        AssertUtil.notNull(httpHeaders, "httpHeaders cannot be null");
        HttpURLConnection connection = this.getHttpURLConnection(urlString);
        connection.setRequestMethod(method.name());
        HashMap<String, String> headerKeyValues = new HashMap<String, String>(this.defaultHttpHeaders);
        headerKeyValues.putAll(httpHeaders);
        for (Map.Entry entry : headerKeyValues.entrySet()) {
            connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            this.log.trace("Header request property: key='{}', value='{}'", entry.getKey(), entry.getValue());
        }
        if (contentLength > 0) {
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestProperty("Content-Length", Integer.toString(contentLength));
        }
        return connection;
    }

    protected HttpURLConnection getHttpURLConnection(String urlString) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(urlString).openConnection(this.proxy);
        if (this.readTimeout > 0) {
            connection.setReadTimeout(this.readTimeout);
        }
        return connection;
    }

    String readInputStreamAsEncodedString(InputStream inputStream, String responseEncoding) throws IOException {
        String responseString;
        if (inputStream == null) {
            return null;
        }
        if (responseEncoding != null) {
            String line;
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, responseEncoding));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            responseString = sb.toString();
        } else {
            int bytesRead;
            StringBuilder sb = new StringBuilder();
            BufferedInputStream bis = new BufferedInputStream(inputStream);
            byte[] byteContents = new byte[4096];
            while ((bytesRead = bis.read(byteContents)) != -1) {
                String strContents = new String(byteContents, 0, bytesRead);
                sb.append(strContents);
            }
            responseString = sb.toString();
        }
        return responseString;
    }

    private String getResponseEncoding(URLConnection connection) {
        String charset = null;
        String contentType = connection.getHeaderField("Content-Type");
        if (contentType != null) {
            for (String param : contentType.replace(" ", "").split(";")) {
                if (!param.startsWith("charset=")) continue;
                charset = param.split("=", 2)[1];
                break;
            }
        }
        return charset;
    }
}

