/*
 * Decompiled with CFR 0.152.
 */
package si.mazi.rescu;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import si.mazi.rescu.AnnotationUtils;
import si.mazi.rescu.HttpMethod;
import si.mazi.rescu.RestInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestMethodMetadata
implements Serializable {
    private static final List<Class<? extends Annotation>> HTTP_METHOD_ANNS = Arrays.asList(GET.class, POST.class, PUT.class, OPTIONS.class, HEAD.class, DELETE.class);
    protected final Class<?> returnType;
    protected final HttpMethod httpMethod;
    protected final String baseUrl;
    protected final String intfacePath;
    protected final String methodPathTemplate;
    protected final Class<? extends RuntimeException> exceptionType;
    protected final String contentType;
    protected final String methodName;
    protected final Map<Class<? extends Annotation>, Annotation> methodAnnotationMap;
    protected final Annotation[][] parameterAnnotations;

    private RestMethodMetadata(Class<?> returnType, HttpMethod httpMethod, String baseUrl, String intfacePath, String methodPathTemplate, Class<? extends RuntimeException> exceptionType, String contentType, String methodName, Map<Class<? extends Annotation>, Annotation> methodAnnotationMap, Annotation[][] parameterAnnotations) {
        this.returnType = returnType;
        this.httpMethod = httpMethod;
        this.baseUrl = baseUrl;
        this.intfacePath = intfacePath;
        this.contentType = contentType;
        this.methodName = methodName;
        this.methodAnnotationMap = methodAnnotationMap;
        this.parameterAnnotations = parameterAnnotations;
        this.methodPathTemplate = methodPathTemplate == null ? "" : methodPathTemplate;
        this.exceptionType = exceptionType;
    }

    static RestMethodMetadata create(Method method, String baseUrl, String intfacePath) {
        String methodName = method.getName();
        Map<Class<? extends Annotation>, Annotation> methodAnnotationMap = AnnotationUtils.getMethodAnnotationMap(method, RestInvocation.PARAM_ANNOTATION_CLASSES);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Consumes consumes = AnnotationUtils.getFromMethodOrClass(method, Consumes.class);
        String contentType = consumes != null ? consumes.value()[0] : "application/x-www-form-urlencoded";
        Path pathAnn = method.getAnnotation(Path.class);
        String methodPathTemplate = pathAnn == null ? "" : pathAnn.value();
        HttpMethod httpMethod = RestMethodMetadata.getHttpMethod(method);
        Type[] thrownExceptions = method.getGenericExceptionTypes();
        Class exceptionType = null;
        if (thrownExceptions.length > 1) {
            throw new IllegalArgumentException("At most one exception is supported on an API method; this method has more: " + method);
        }
        if (thrownExceptions.length == 1 && !RuntimeException.class.isAssignableFrom(exceptionType = (Class)thrownExceptions[0])) {
            throw new IllegalArgumentException("Only RuntimeExceptions are supported on API methods; this method doesn't comply: " + method);
        }
        return new RestMethodMetadata(method.getReturnType(), httpMethod, baseUrl, intfacePath, methodPathTemplate, exceptionType, contentType, methodName, methodAnnotationMap, parameterAnnotations);
    }

    static HttpMethod getHttpMethod(Method method) {
        HttpMethod httpMethod = null;
        for (Class<? extends Annotation> m : HTTP_METHOD_ANNS) {
            if (!method.isAnnotationPresent(m)) continue;
            if (httpMethod != null) {
                throw new IllegalArgumentException("Method is annotated with more than one HTTP-method annotation: " + method);
            }
            httpMethod = HttpMethod.valueOf(m.getSimpleName());
        }
        if (httpMethod == null) {
            throw new IllegalArgumentException("Method must be annotated with a HTTP-method annotation: " + method);
        }
        return httpMethod;
    }
}

