/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.kraken;

import com.xeiam.xchange.dto.Order;
import java.util.HashMap;
import java.util.Map;

public final class KrakenUtils {
    private static Map<String, String> krakenCurrencies = new HashMap<String, String>();
    private static Map<String, String> currencies = new HashMap<String, String>();

    private KrakenUtils() {
    }

    public static String getKrakenCurrencyCode(String currencyCode) {
        return krakenCurrencies.get(currencyCode);
    }

    public static String getCurrency(String krakenCurrencyCode) {
        return currencies.get(krakenCurrencyCode);
    }

    public static String createKrakenCurrencyPair(String tradableIdentifier, String currency) {
        String currency2;
        String currency1 = krakenCurrencies.get(tradableIdentifier);
        if (currency1 == null) {
            currency1 = tradableIdentifier;
        }
        if ((currency2 = krakenCurrencies.get(currency)) == null) {
            currency2 = currency;
        }
        return currency1 + currency2;
    }

    public static String getKrakenOrderType(Order.OrderType type) {
        return type == Order.OrderType.ASK ? "sell" : "buy";
    }

    public static long getNonce() {
        return System.currentTimeMillis();
    }

    static {
        krakenCurrencies.put("BTC", "XXBT");
        krakenCurrencies.put("LTC", "XLTC");
        krakenCurrencies.put("EUR", "ZEUR");
        krakenCurrencies.put("USD", "ZUSD");
        currencies.put("XXBT", "BTC");
        currencies.put("XLTC", "LTC");
        currencies.put("ZEUR", "EUR");
        currencies.put("ZUSD", "USD");
    }
}

