/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.kraken.service.polling;

import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotAvailableFromExchangeException;
import com.xeiam.xchange.NotYetImplementedForExchangeException;
import com.xeiam.xchange.dto.account.AccountInfo;
import com.xeiam.xchange.kraken.KrakenAdapters;
import com.xeiam.xchange.kraken.KrakenAuthenticated;
import com.xeiam.xchange.kraken.KrakenUtils;
import com.xeiam.xchange.kraken.dto.account.KrakenBalanceResult;
import com.xeiam.xchange.kraken.service.KrakenDigest;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingAccountService;
import com.xeiam.xchange.utils.Assert;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;

public class KrakenPollingAccountService
extends BasePollingExchangeService
implements PollingAccountService {
    private KrakenAuthenticated krakenAuthenticated;
    private ParamsDigest signatureCreator;

    public KrakenPollingAccountService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        Assert.notNull((Object)exchangeSpecification.getSslUri(), (String)"Exchange specification URI cannot be null");
        this.krakenAuthenticated = (KrakenAuthenticated)RestProxyFactory.createProxy(KrakenAuthenticated.class, (String)exchangeSpecification.getSslUri());
        this.signatureCreator = KrakenDigest.createInstance(exchangeSpecification.getSecretKey());
    }

    public AccountInfo getAccountInfo() throws IOException {
        KrakenBalanceResult result = this.krakenAuthenticated.getBalance(this.exchangeSpecification.getApiKey(), this.signatureCreator, KrakenUtils.getNonce());
        if (result.getError().length > 0) {
            throw new ExchangeException(Arrays.toString(result.getError()));
        }
        return KrakenAdapters.adaptBalance(result, this.exchangeSpecification.getUserName());
    }

    public String withdrawFunds(BigDecimal amount, String address) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException {
        throw new NotAvailableFromExchangeException();
    }

    public String requestBitcoinDepositAddress(String ... arguments) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException {
        throw new NotAvailableFromExchangeException();
    }
}

