/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.mtgox.v2;

import com.xeiam.xchange.currency.MoneyUtils;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.account.AccountInfo;
import com.xeiam.xchange.dto.marketdata.OrderBookUpdate;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trade;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.dto.trade.Wallet;
import com.xeiam.xchange.mtgox.MtGoxUtils;
import com.xeiam.xchange.mtgox.v2.dto.account.polling.MtGoxAccountInfo;
import com.xeiam.xchange.mtgox.v2.dto.account.polling.MtGoxWallet;
import com.xeiam.xchange.mtgox.v2.dto.account.polling.Wallets;
import com.xeiam.xchange.mtgox.v2.dto.marketdata.MtGoxDepthUpdate;
import com.xeiam.xchange.mtgox.v2.dto.marketdata.MtGoxOrder;
import com.xeiam.xchange.mtgox.v2.dto.marketdata.MtGoxTicker;
import com.xeiam.xchange.mtgox.v2.dto.marketdata.MtGoxTrade;
import com.xeiam.xchange.mtgox.v2.dto.trade.polling.MtGoxOpenOrder;
import com.xeiam.xchange.utils.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.joda.money.BigMoney;

public final class MtGoxAdapters {
    private MtGoxAdapters() {
    }

    public static AccountInfo adaptAccountInfo(MtGoxAccountInfo mtGoxAccountInfo) {
        AccountInfo accountInfo = new AccountInfo(mtGoxAccountInfo.getLogin(), MtGoxAdapters.adaptWallets(mtGoxAccountInfo.getWallets()));
        return accountInfo;
    }

    public static LimitOrder adaptOrder(BigDecimal amount, BigDecimal price, String currency, String orderTypeString, String id, Date timestamp) {
        Order.OrderType orderType = orderTypeString.equalsIgnoreCase("bid") ? Order.OrderType.BID : Order.OrderType.ASK;
        String tradableIdentifier = "BTC";
        String transactionCurrency = currency;
        BigMoney limitPrice = MoneyUtils.parse((String)(currency + " " + price));
        LimitOrder limitOrder = new LimitOrder(orderType, amount, tradableIdentifier, transactionCurrency, id, timestamp, limitPrice);
        return limitOrder;
    }

    public static List<LimitOrder> adaptOrders(List<MtGoxOrder> mtGoxOrders, String currency, String orderType, String id) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (MtGoxOrder mtGoxOrder : mtGoxOrders) {
            limitOrders.add(MtGoxAdapters.adaptOrder(mtGoxOrder.getAmount(), mtGoxOrder.getPrice(), currency, orderType, id, new Date(mtGoxOrder.getStamp() / 1000L)));
        }
        return limitOrders;
    }

    public static List<LimitOrder> adaptOrders(MtGoxOpenOrder[] mtGoxOpenOrders) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (int i = 0; i < mtGoxOpenOrders.length; ++i) {
            limitOrders.add(MtGoxAdapters.adaptOrder(mtGoxOpenOrders[i].getAmount().getValue(), mtGoxOpenOrders[i].getPrice().getValue(), mtGoxOpenOrders[i].getCurrency(), mtGoxOpenOrders[i].getType(), mtGoxOpenOrders[i].getOid(), new Date(mtGoxOpenOrders[i].getDate() * 1000L)));
        }
        return limitOrders;
    }

    public static Wallet adaptWallet(MtGoxWallet mtGoxWallet) {
        if (mtGoxWallet == null) {
            return null;
        }
        BigMoney cash = MoneyUtils.parse((String)(mtGoxWallet.getBalance().getCurrency() + " " + mtGoxWallet.getBalance().getValue()));
        return new Wallet(mtGoxWallet.getBalance().getCurrency(), cash);
    }

    public static List<Wallet> adaptWallets(Wallets mtGoxWallets) {
        ArrayList<Wallet> wallets = new ArrayList<Wallet>();
        for (MtGoxWallet mtGoxWallet : mtGoxWallets.getMtGoxWallets()) {
            Wallet wallet = MtGoxAdapters.adaptWallet(mtGoxWallet);
            if (wallet == null) continue;
            wallets.add(wallet);
        }
        return wallets;
    }

    public static Trade adaptTrade(MtGoxTrade mtGoxTrade) {
        Order.OrderType orderType = mtGoxTrade.getTradeType().equals("bid") ? Order.OrderType.BID : Order.OrderType.ASK;
        BigDecimal amount = new BigDecimal(mtGoxTrade.getAmountInt()).divide(new BigDecimal(100000000));
        String tradableIdentifier = mtGoxTrade.getItem();
        String transactionCurrency = mtGoxTrade.getPriceCurrency();
        BigMoney price = MtGoxUtils.getPrice(transactionCurrency, mtGoxTrade.getPriceInt());
        Date dateTime = DateUtils.fromMillisUtc((long)(mtGoxTrade.getDate() * 1000L));
        return new Trade(orderType, amount, tradableIdentifier, transactionCurrency, price, dateTime, mtGoxTrade.getTid());
    }

    public static OrderBookUpdate adaptDepthUpdate(MtGoxDepthUpdate mtGoxDepthUpdate) {
        Order.OrderType orderType = mtGoxDepthUpdate.getTradeType().equals("bid") ? Order.OrderType.BID : Order.OrderType.ASK;
        BigDecimal volume = new BigDecimal(mtGoxDepthUpdate.getVolumeInt()).divide(new BigDecimal(100000000));
        String tradableIdentifier = mtGoxDepthUpdate.getItem();
        String transactionCurrency = mtGoxDepthUpdate.getCurrency();
        BigMoney price = MtGoxUtils.getPrice(transactionCurrency, mtGoxDepthUpdate.getPriceInt());
        BigDecimal totalVolume = new BigDecimal(mtGoxDepthUpdate.getTotalVolumeInt()).divide(new BigDecimal(100000000));
        Date date = new Date(mtGoxDepthUpdate.getNow() / 1000L);
        OrderBookUpdate orderBookUpdate = new OrderBookUpdate(orderType, volume, tradableIdentifier, transactionCurrency, price, date, totalVolume);
        return orderBookUpdate;
    }

    public static Trades adaptTrades(MtGoxTrade[] mtGoxTrades) {
        ArrayList<Trade> tradesList = new ArrayList<Trade>();
        for (int i = 0; i < mtGoxTrades.length; ++i) {
            tradesList.add(MtGoxAdapters.adaptTrade(mtGoxTrades[i]));
        }
        return new Trades(tradesList);
    }

    public static Ticker adaptTicker(MtGoxTicker mtGoxTicker) {
        BigMoney last = MoneyUtils.parse((String)(mtGoxTicker.getLast().getCurrency() + " " + mtGoxTicker.getLast().getValue()));
        BigMoney bid = MoneyUtils.parse((String)(mtGoxTicker.getBuy().getCurrency() + " " + mtGoxTicker.getBuy().getValue()));
        BigMoney ask = MoneyUtils.parse((String)(mtGoxTicker.getSell().getCurrency() + " " + mtGoxTicker.getSell().getValue()));
        BigMoney high = MoneyUtils.parse((String)(mtGoxTicker.getHigh().getCurrency() + " " + mtGoxTicker.getHigh().getValue()));
        BigMoney low = MoneyUtils.parse((String)(mtGoxTicker.getLow().getCurrency() + " " + mtGoxTicker.getLow().getValue()));
        BigDecimal volume = mtGoxTicker.getVol().getValue();
        return Ticker.TickerBuilder.newInstance().withTradableIdentifier(mtGoxTicker.getVol().getCurrency()).withLast(last).withBid(bid).withAsk(ask).withHigh(high).withLow(low).withVolume(volume).withTimestamp(new Date(mtGoxTicker.getNow() / 1000L)).build();
    }
}

