/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.mtgox.v2.service.polling;

import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.dto.account.AccountInfo;
import com.xeiam.xchange.mtgox.MtGoxUtils;
import com.xeiam.xchange.mtgox.v2.MtGoxAdapters;
import com.xeiam.xchange.mtgox.v2.MtGoxV2;
import com.xeiam.xchange.mtgox.v2.dto.MtGoxException;
import com.xeiam.xchange.mtgox.v2.dto.account.polling.MtGoxAccountInfoWrapper;
import com.xeiam.xchange.mtgox.v2.dto.account.polling.MtGoxBitcoinDepositAddressWrapper;
import com.xeiam.xchange.mtgox.v2.dto.account.polling.MtGoxWithdrawalResponseWrapper;
import com.xeiam.xchange.mtgox.v2.service.MtGoxV2Digest;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingAccountService;
import com.xeiam.xchange.utils.Assert;
import java.math.BigDecimal;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;

public class MtGoxPollingAccountService
extends BasePollingExchangeService
implements PollingAccountService {
    private final MtGoxV2 mtGoxV2;
    private ParamsDigest signatureCreator;

    public MtGoxPollingAccountService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        Assert.notNull((Object)exchangeSpecification.getSslUri(), (String)"Exchange specification URI cannot be null");
        this.mtGoxV2 = (MtGoxV2)RestProxyFactory.createProxy(MtGoxV2.class, (String)exchangeSpecification.getSslUri());
        this.signatureCreator = MtGoxV2Digest.createInstance(exchangeSpecification.getSecretKey());
    }

    public AccountInfo getAccountInfo() {
        try {
            MtGoxAccountInfoWrapper mtGoxAccountInfoWrapper = this.mtGoxV2.getAccountInfo(this.exchangeSpecification.getApiKey(), this.signatureCreator, MtGoxUtils.getNonce());
            if (mtGoxAccountInfoWrapper.getResult().equals("success")) {
                return MtGoxAdapters.adaptAccountInfo(mtGoxAccountInfoWrapper.getMtGoxAccountInfo());
            }
            if (mtGoxAccountInfoWrapper.getResult().equals("error")) {
                throw new ExchangeException("Error calling getAccountInfo(): " + mtGoxAccountInfoWrapper.getError());
            }
            throw new ExchangeException("Error calling getAccountInfo(): Unexpected result!");
        }
        catch (MtGoxException e) {
            throw new ExchangeException("Error calling getAccountInfo(): " + e.getError());
        }
    }

    public String withdrawFunds(BigDecimal amount, String address) {
        try {
            MtGoxWithdrawalResponseWrapper mtGoxWithdrawalResponseWrapper = this.mtGoxV2.withdrawBtc(this.exchangeSpecification.getApiKey(), this.signatureCreator, MtGoxUtils.getNonce(), address, amount.multiply(new BigDecimal(100000000)).intValue(), 1, false, false);
            if (mtGoxWithdrawalResponseWrapper.getResult().equals("success")) {
                return mtGoxWithdrawalResponseWrapper.getMtGoxWithdrawalResponse().getTransactionId();
            }
            if (mtGoxWithdrawalResponseWrapper.getResult().equals("error")) {
                throw new ExchangeException("Error calling withdrawFunds(): " + mtGoxWithdrawalResponseWrapper.getError());
            }
            throw new ExchangeException("Error calling withdrawFunds(): Unexpected result!");
        }
        catch (MtGoxException e) {
            throw new ExchangeException("Error calling withdrawFunds(): " + e.getError());
        }
    }

    public String requestBitcoinDepositAddress(String ... arguments) {
        String description = arguments[0];
        String notificationUrl = arguments[1];
        try {
            MtGoxBitcoinDepositAddressWrapper mtGoxBitcoinDepositAddressWrapper = this.mtGoxV2.requestDepositAddress(this.exchangeSpecification.getApiKey(), this.signatureCreator, MtGoxUtils.getNonce(), description, notificationUrl);
            if (mtGoxBitcoinDepositAddressWrapper.getResult().equals("success")) {
                return mtGoxBitcoinDepositAddressWrapper.getMtGoxBitcoinDepositAddress().getAddres();
            }
            if (mtGoxBitcoinDepositAddressWrapper.getResult().equals("error")) {
                throw new ExchangeException("Error calling requestBitcoinDepositAddress(): " + mtGoxBitcoinDepositAddressWrapper.getError());
            }
            throw new ExchangeException("Error calling requestBitcoinDepositAddress(): Unexpected result!");
        }
        catch (MtGoxException e) {
            throw new ExchangeException("Error calling requestBitcoinDepositAddress(): " + e.getError());
        }
    }
}

