/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.mtgox.v2.service.polling;

import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.mtgox.MtGoxUtils;
import com.xeiam.xchange.mtgox.v2.MtGoxAdapters;
import com.xeiam.xchange.mtgox.v2.MtGoxV2;
import com.xeiam.xchange.mtgox.v2.dto.MtGoxException;
import com.xeiam.xchange.mtgox.v2.dto.marketdata.MtGoxDepthWrapper;
import com.xeiam.xchange.mtgox.v2.dto.marketdata.MtGoxTickerWrapper;
import com.xeiam.xchange.mtgox.v2.dto.marketdata.MtGoxTradesWrapper;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingMarketDataService;
import com.xeiam.xchange.utils.Assert;
import java.util.Date;
import java.util.List;
import si.mazi.rescu.RestProxyFactory;

public class MtGoxPollingMarketDataService
extends BasePollingExchangeService
implements PollingMarketDataService {
    private final MtGoxV2 mtGoxV2;

    public MtGoxPollingMarketDataService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        this.mtGoxV2 = (MtGoxV2)RestProxyFactory.createProxy(MtGoxV2.class, (String)exchangeSpecification.getSslUri());
    }

    public Ticker getTicker(String tradableIdentifier, String currency) {
        this.verify(tradableIdentifier, currency);
        try {
            MtGoxTickerWrapper mtGoxTickerWrapper = this.mtGoxV2.getTicker(tradableIdentifier, currency);
            if (mtGoxTickerWrapper.getResult().equals("success")) {
                return MtGoxAdapters.adaptTicker(mtGoxTickerWrapper.getMtGoxTicker());
            }
            if (mtGoxTickerWrapper.getResult().equals("error")) {
                throw new ExchangeException("Error calling getTicker(): " + mtGoxTickerWrapper.getError());
            }
            throw new ExchangeException("Error calling getTicker(): Unexpected result!");
        }
        catch (MtGoxException e) {
            throw new ExchangeException("Error calling getTicker(): " + e.getError());
        }
    }

    public OrderBook getPartialOrderBook(String tradableIdentifier, String currency) {
        this.verify(tradableIdentifier, currency);
        try {
            MtGoxDepthWrapper mtGoxDepthWrapper = this.mtGoxV2.getDepth(tradableIdentifier, currency);
            if (mtGoxDepthWrapper.getResult().equals("success")) {
                List<LimitOrder> asks = MtGoxAdapters.adaptOrders(mtGoxDepthWrapper.getMtGoxDepth().getAsks(), currency, "ask", "");
                List<LimitOrder> bids = MtGoxAdapters.adaptOrders(mtGoxDepthWrapper.getMtGoxDepth().getBids(), currency, "bid", "");
                Date date = new Date(mtGoxDepthWrapper.getMtGoxDepth().getMicroTime() / 1000L);
                return new OrderBook(date, asks, bids);
            }
            if (mtGoxDepthWrapper.getResult().equals("error")) {
                throw new ExchangeException("Error calling getPartialOrderBook(): " + mtGoxDepthWrapper.getError());
            }
            throw new ExchangeException("Error calling getPartialOrderBook(): Unexpected result!");
        }
        catch (MtGoxException e) {
            throw new ExchangeException("Error calling getPartialOrderBook(): " + e.getError());
        }
    }

    public OrderBook getFullOrderBook(String tradableIdentifier, String currency) {
        this.verify(tradableIdentifier, currency);
        try {
            MtGoxDepthWrapper mtGoxDepthWrapper = this.mtGoxV2.getFullDepth(tradableIdentifier, currency);
            if (mtGoxDepthWrapper.getResult().equals("success")) {
                List<LimitOrder> asks = MtGoxAdapters.adaptOrders(mtGoxDepthWrapper.getMtGoxDepth().getAsks(), currency, "ask", "");
                List<LimitOrder> bids = MtGoxAdapters.adaptOrders(mtGoxDepthWrapper.getMtGoxDepth().getBids(), currency, "bid", "");
                Date date = new Date(mtGoxDepthWrapper.getMtGoxDepth().getMicroTime() / 1000L);
                return new OrderBook(date, asks, bids);
            }
            if (mtGoxDepthWrapper.getResult().equals("error")) {
                throw new ExchangeException("Error calling getFullOrderBook(): " + mtGoxDepthWrapper.getError());
            }
            throw new ExchangeException("Error calling getFullOrderBook(): Unexpected result!");
        }
        catch (MtGoxException e) {
            throw new ExchangeException("Error calling getFullOrderBook(): " + e.getError());
        }
    }

    public Trades getTrades(String tradableIdentifier, String currency, Object ... args) {
        this.verify(tradableIdentifier, currency);
        try {
            MtGoxTradesWrapper mtGoxTradeWrapper = null;
            if (args.length > 0) {
                Long sinceTimeStamp = (Long)args[0];
                mtGoxTradeWrapper = this.mtGoxV2.getTrades(tradableIdentifier, currency, sinceTimeStamp);
            } else {
                mtGoxTradeWrapper = this.mtGoxV2.getTrades(tradableIdentifier, currency);
            }
            if (mtGoxTradeWrapper.getResult().equals("success")) {
                return MtGoxAdapters.adaptTrades(mtGoxTradeWrapper.getMtGoxTrades());
            }
            if (mtGoxTradeWrapper.getResult().equals("error")) {
                throw new ExchangeException("Error calling getTrades(): " + mtGoxTradeWrapper.getError());
            }
            throw new ExchangeException("Error calling getTrades(): Unexpected result!");
        }
        catch (MtGoxException e) {
            throw new ExchangeException("Error calling getTrades(): " + e.getError());
        }
    }

    private void verify(String tradableIdentifier, String currency) {
        Assert.notNull((Object)tradableIdentifier, (String)"tradableIdentifier cannot be null");
        Assert.notNull((Object)currency, (String)"currency cannot be null");
        Assert.isTrue((boolean)MtGoxUtils.isValidCurrencyPair(new CurrencyPair(tradableIdentifier, currency)), (String)("currencyPair is not valid:" + tradableIdentifier + " " + currency));
    }

    public List<CurrencyPair> getExchangeSymbols() {
        return MtGoxUtils.CURRENCY_PAIRS;
    }
}

