/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.mtgox.v2.service.polling;

import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotYetImplementedForExchangeException;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.dto.trade.MarketOrder;
import com.xeiam.xchange.dto.trade.OpenOrders;
import com.xeiam.xchange.mtgox.MtGoxUtils;
import com.xeiam.xchange.mtgox.v2.MtGoxAdapters;
import com.xeiam.xchange.mtgox.v2.MtGoxV2;
import com.xeiam.xchange.mtgox.v2.dto.MtGoxException;
import com.xeiam.xchange.mtgox.v2.dto.trade.polling.MtGoxGenericResponse;
import com.xeiam.xchange.mtgox.v2.dto.trade.polling.MtGoxOpenOrderWrapper;
import com.xeiam.xchange.mtgox.v2.service.MtGoxV2Digest;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingTradeService;
import com.xeiam.xchange.utils.Assert;
import java.math.BigDecimal;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;

public class MtGoxPollingTradeService
extends BasePollingExchangeService
implements PollingTradeService {
    private final MtGoxV2 mtGoxV2;
    private ParamsDigest signatureCreator;

    public MtGoxPollingTradeService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        Assert.notNull((Object)exchangeSpecification.getSslUri(), (String)"Exchange specification URI cannot be null");
        this.mtGoxV2 = (MtGoxV2)RestProxyFactory.createProxy(MtGoxV2.class, (String)exchangeSpecification.getSslUri());
        this.signatureCreator = MtGoxV2Digest.createInstance(exchangeSpecification.getSecretKey());
    }

    public OpenOrders getOpenOrders() {
        try {
            MtGoxOpenOrderWrapper mtGoxOpenOrderWrapper = this.mtGoxV2.getOpenOrders(MtGoxUtils.urlEncode(this.exchangeSpecification.getApiKey()), this.signatureCreator, MtGoxUtils.getNonce());
            if (mtGoxOpenOrderWrapper.getResult().equals("success")) {
                return new OpenOrders(MtGoxAdapters.adaptOrders(mtGoxOpenOrderWrapper.getMtGoxOpenOrders()));
            }
            if (mtGoxOpenOrderWrapper.getResult().equals("error")) {
                throw new ExchangeException("Error calling getOpenOrders(): " + mtGoxOpenOrderWrapper.getError());
            }
            throw new ExchangeException("Error calling getOpenOrders(): Unexpected result!");
        }
        catch (MtGoxException e) {
            throw new ExchangeException("Error calling getOpenOrders(): " + e.getError());
        }
    }

    public String placeMarketOrder(MarketOrder marketOrder) {
        this.verify((Order)marketOrder);
        try {
            MtGoxGenericResponse mtGoxGenericResponse = this.mtGoxV2.placeOrder(this.exchangeSpecification.getApiKey(), this.signatureCreator, MtGoxUtils.getNonce(), marketOrder.getTradableIdentifier(), marketOrder.getTransactionCurrency(), marketOrder.getType().equals((Object)Order.OrderType.BID) ? "bid" : "ask", marketOrder.getTradableAmount().multiply(new BigDecimal(100000000)), null);
            if (mtGoxGenericResponse.getResult().equals("success")) {
                return mtGoxGenericResponse.getDataString();
            }
            if (mtGoxGenericResponse.getResult().equals("error")) {
                throw new ExchangeException("Error calling placeMarketOrder(): " + mtGoxGenericResponse.getError());
            }
            throw new ExchangeException("Error calling placeMarketOrder(): Unexpected result!");
        }
        catch (MtGoxException e) {
            throw new ExchangeException("Error calling placeMarketOrder(): " + e.getError());
        }
    }

    public String placeLimitOrder(LimitOrder limitOrder) {
        this.verify((Order)limitOrder);
        Assert.notNull((Object)limitOrder.getLimitPrice().getAmount(), (String)"getLimitPrice().getAmount() cannot be null");
        Assert.notNull((Object)limitOrder.getLimitPrice().getCurrencyUnit(), (String)"getLimitPrice().getCurrencyUnit() cannot be null");
        String tradableIdentifier = limitOrder.getTradableIdentifier();
        String currency = limitOrder.getLimitPrice().getCurrencyUnit().toString();
        String type = limitOrder.getType().equals((Object)Order.OrderType.BID) ? "bid" : "ask";
        BigDecimal amount = limitOrder.getTradableAmount().multiply(new BigDecimal(100000000));
        String price = MtGoxUtils.getPriceString(limitOrder.getLimitPrice());
        try {
            MtGoxGenericResponse mtGoxGenericResponse = this.mtGoxV2.placeOrder(this.exchangeSpecification.getApiKey(), this.signatureCreator, MtGoxUtils.getNonce(), tradableIdentifier, currency, type, amount, price);
            if (mtGoxGenericResponse.getResult().equals("success")) {
                return mtGoxGenericResponse.getDataString();
            }
            if (mtGoxGenericResponse.getResult().equals("error")) {
                throw new ExchangeException("Error calling placeLimitOrder(): " + mtGoxGenericResponse.getError());
            }
            throw new ExchangeException("Error calling placeLimitOrder(): Unexpected result!");
        }
        catch (MtGoxException e) {
            throw new ExchangeException("Error calling placeLimitOrder(): " + e.getError());
        }
    }

    public boolean cancelOrder(String orderId) {
        Assert.notNull((Object)orderId, (String)"orderId cannot be null");
        try {
            MtGoxGenericResponse mtGoxGenericResponse = this.mtGoxV2.cancelOrder(this.exchangeSpecification.getApiKey(), this.signatureCreator, MtGoxUtils.getNonce(), orderId);
            if (mtGoxGenericResponse.getResult().equals("success")) {
                return true;
            }
            if (mtGoxGenericResponse.getResult().equals("error")) {
                throw new ExchangeException("Error calling cancelOrder(): " + mtGoxGenericResponse.getError());
            }
            throw new ExchangeException("Error calling placeLimitOrder(): Unexpected result!");
        }
        catch (MtGoxException e) {
            throw new ExchangeException("Error calling cancelOrder(): " + e.getError());
        }
    }

    private void verify(Order order) {
        Assert.notNull((Object)order.getTradableIdentifier(), (String)"getTradableIdentifier() cannot be null");
        Assert.notNull((Object)order.getType(), (String)"getType() cannot be null");
        Assert.notNull((Object)order.getTradableAmount(), (String)"getAmount_int() cannot be null");
        Assert.isTrue((boolean)MtGoxUtils.isValidCurrencyPair(new CurrencyPair(order.getTradableIdentifier(), order.getTransactionCurrency())), (String)"currencyPair is not valid");
    }

    public Trades getTradeHistory(Object ... arguments) {
        throw new NotYetImplementedForExchangeException();
    }
}

