/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.btcchina;

import com.xeiam.xchange.btcchina.dto.BTCChinaValue;
import com.xeiam.xchange.currency.CurrencyPair;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public final class BTCChinaUtils {
    private static long generatedId = 1L;
    public static final List<CurrencyPair> CURRENCY_PAIRS = Arrays.asList(CurrencyPair.BTC_CNY);

    private BTCChinaUtils() {
    }

    public static boolean isValidCurrencyPair(CurrencyPair currencyPair) {
        return CURRENCY_PAIRS.contains(currencyPair);
    }

    public static long getNonce() {
        return System.currentTimeMillis() * 1000L;
    }

    public static long getGeneratedId() {
        return generatedId++;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static BigDecimal valueToBigDecimal(BTCChinaValue value) {
        return new BigDecimal(new BigInteger(value.getAmountInteger()), value.getAmountDecimal().intValue());
    }
}

