/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.btcchina.service.polling;

import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.NotAvailableFromExchangeException;
import com.xeiam.xchange.btcchina.BTCChina;
import com.xeiam.xchange.btcchina.BTCChinaAdapters;
import com.xeiam.xchange.btcchina.BTCChinaUtils;
import com.xeiam.xchange.btcchina.dto.marketdata.BTCChinaDepth;
import com.xeiam.xchange.btcchina.dto.marketdata.BTCChinaTicker;
import com.xeiam.xchange.btcchina.dto.marketdata.BTCChinaTrade;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.service.polling.BasePollingExchangeService;
import com.xeiam.xchange.service.polling.PollingMarketDataService;
import com.xeiam.xchange.utils.Assert;
import java.util.List;
import si.mazi.rescu.RestProxyFactory;

public class BTCChinaPollingMarketDataService
extends BasePollingExchangeService
implements PollingMarketDataService {
    private final BTCChina btcChina;

    public BTCChinaPollingMarketDataService(ExchangeSpecification exchangeSpecification) {
        super(exchangeSpecification);
        this.btcChina = (BTCChina)RestProxyFactory.createProxy(BTCChina.class, (String)exchangeSpecification.getSslUri());
    }

    public Ticker getTicker(String tradableIdentifier, String currency) {
        this.verify(tradableIdentifier, currency);
        BTCChinaTicker btcChinaTicker = this.btcChina.getTicker(currency);
        return BTCChinaAdapters.adaptTicker(btcChinaTicker, currency, tradableIdentifier);
    }

    public OrderBook getPartialOrderBook(String tradableIdentifier, String currency) {
        throw new NotAvailableFromExchangeException();
    }

    public OrderBook getFullOrderBook(String tradableIdentifier, String currency) {
        this.verify(tradableIdentifier, currency);
        BTCChinaDepth btcChinaDepth = this.btcChina.getFullDepth(currency);
        List<LimitOrder> asks = BTCChinaAdapters.adaptOrders(btcChinaDepth.getAsks(), currency, "ask", "");
        List<LimitOrder> bids = BTCChinaAdapters.adaptOrders(btcChinaDepth.getBids(), currency, "bid", "");
        return new OrderBook(null, asks, bids);
    }

    public Trades getTrades(String tradableIdentifier, String currency, Object ... args) {
        this.verify(tradableIdentifier, currency);
        BTCChinaTrade[] btcChinaTrades = this.btcChina.getTrades(currency);
        return BTCChinaAdapters.adaptTrades(btcChinaTrades, currency, tradableIdentifier);
    }

    private void verify(String tradableIdentifier, String currency) {
        Assert.notNull((Object)tradableIdentifier, (String)"tradableIdentifier cannot be null");
        Assert.notNull((Object)currency, (String)"currency cannot be null");
        Assert.isTrue((boolean)BTCChinaUtils.isValidCurrencyPair(new CurrencyPair(tradableIdentifier, currency)), (String)("currencyPair is not valid:" + tradableIdentifier + " " + currency));
    }

    public List<CurrencyPair> getExchangeSymbols() {
        return BTCChinaUtils.CURRENCY_PAIRS;
    }
}

