/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.btce;

import com.xeiam.xchange.btce.dto.account.BTCEAccountInfo;
import com.xeiam.xchange.btce.dto.marketdata.BTCETicker;
import com.xeiam.xchange.btce.dto.marketdata.BTCETrade;
import com.xeiam.xchange.btce.dto.trade.BTCEOrder;
import com.xeiam.xchange.btce.dto.trade.BTCETradeHistoryResult;
import com.xeiam.xchange.currency.MoneyUtils;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.account.AccountInfo;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trade;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.dto.trade.OpenOrders;
import com.xeiam.xchange.dto.trade.Wallet;
import com.xeiam.xchange.utils.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.joda.money.BigMoney;
import org.joda.money.CurrencyUnit;
import org.joda.money.IllegalCurrencyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BTCEAdapters {
    private static final Logger log = LoggerFactory.getLogger(BTCEAdapters.class);

    private BTCEAdapters() {
    }

    public static LimitOrder adaptOrder(BigDecimal amount, BigDecimal price, String tradableIdentifier, String currency, String orderTypeString, String id) {
        Order.OrderType orderType = orderTypeString.equalsIgnoreCase("bid") ? Order.OrderType.BID : Order.OrderType.ASK;
        BigMoney limitPrice = MoneyUtils.parse((String)(currency + " " + price));
        return new LimitOrder(orderType, amount, tradableIdentifier, currency, limitPrice);
    }

    public static List<LimitOrder> adaptOrders(List<BigDecimal[]> BTCEOrders, String tradableIdentifier, String currency, String orderType, String id) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (BigDecimal[] btceOrder : BTCEOrders) {
            if (orderType.equalsIgnoreCase("bid")) {
                limitOrders.add(0, BTCEAdapters.adaptOrder(btceOrder[1], btceOrder[0], tradableIdentifier, currency, orderType, id));
                continue;
            }
            limitOrders.add(BTCEAdapters.adaptOrder(btceOrder[1], btceOrder[0], tradableIdentifier, currency, orderType, id));
        }
        return limitOrders;
    }

    public static Trade adaptTrade(BTCETrade bTCETrade) {
        Order.OrderType orderType = bTCETrade.getTradeType().equalsIgnoreCase("bid") ? Order.OrderType.BID : Order.OrderType.ASK;
        BigDecimal amount = bTCETrade.getAmount();
        String currency = bTCETrade.getPriceCurrency();
        BigMoney price = MoneyUtils.parse((String)(currency + " " + bTCETrade.getPrice()));
        String tradableIdentifier = bTCETrade.getItem();
        Date date = DateUtils.fromMillisUtc((long)(bTCETrade.getDate() * 1000L));
        return new Trade(orderType, amount, tradableIdentifier, currency, price, date, bTCETrade.getTid());
    }

    public static Trades adaptTrades(BTCETrade[] BTCETrades) {
        ArrayList<Trade> tradesList = new ArrayList<Trade>();
        for (BTCETrade BTCETrade2 : BTCETrades) {
            tradesList.add(0, BTCEAdapters.adaptTrade(BTCETrade2));
        }
        return new Trades(tradesList);
    }

    public static Ticker adaptTicker(BTCETicker bTCETicker, String tradableIdentifier, String currency) {
        BigMoney last = MoneyUtils.parse((String)(currency + " " + bTCETicker.getTicker().getLast()));
        BigMoney bid = MoneyUtils.parse((String)(currency + " " + bTCETicker.getTicker().getSell()));
        BigMoney ask = MoneyUtils.parse((String)(currency + " " + bTCETicker.getTicker().getBuy()));
        BigMoney high = MoneyUtils.parse((String)(currency + " " + bTCETicker.getTicker().getHigh()));
        BigMoney low = MoneyUtils.parse((String)(currency + " " + bTCETicker.getTicker().getLow()));
        BigDecimal volume = bTCETicker.getTicker().getVolCur();
        Date timestamp = DateUtils.fromMillisUtc((long)(bTCETicker.getTicker().getServerTime() * 1000L));
        return Ticker.TickerBuilder.newInstance().withTradableIdentifier(tradableIdentifier).withLast(last).withBid(bid).withAsk(ask).withHigh(high).withLow(low).withVolume(volume).withTimestamp(timestamp).build();
    }

    public static AccountInfo adaptAccountInfo(BTCEAccountInfo btceAccountInfo) {
        ArrayList<Wallet> wallets = new ArrayList<Wallet>();
        Map<String, BigDecimal> funds = btceAccountInfo.getFunds();
        for (String lcCurrency : funds.keySet()) {
            String currency = lcCurrency.toUpperCase();
            try {
                CurrencyUnit.of((String)currency);
            }
            catch (IllegalCurrencyException e) {
                log.warn("Ignoring unknown currency {}", (Object)currency);
                continue;
            }
            wallets.add(Wallet.createInstance((String)currency, (BigDecimal)funds.get(lcCurrency)));
        }
        return new AccountInfo(null, wallets);
    }

    public static OpenOrders adaptOrders(Map<Long, BTCEOrder> btceOrderMap) {
        ArrayList<LimitOrder> os = new ArrayList<LimitOrder>();
        for (Long id : btceOrderMap.keySet()) {
            BTCEOrder o = btceOrderMap.get(id);
            Order.OrderType orderType = o.getType() == BTCEOrder.Type.buy ? Order.OrderType.BID : Order.OrderType.ASK;
            String[] pair = o.getPair().split("_");
            String currency = pair[1].toUpperCase();
            BigMoney price = BigMoney.of((CurrencyUnit)CurrencyUnit.of((String)currency), (BigDecimal)o.getRate());
            os.add(new LimitOrder(orderType, o.getAmount(), pair[0].toUpperCase(), currency, Long.toString(id), price));
        }
        return new OpenOrders(os);
    }

    public static Trades adaptTradeHistory(Map<Long, BTCETradeHistoryResult> tradeHistory) {
        ArrayList<Trade> trades = new ArrayList<Trade>(tradeHistory.size());
        for (Map.Entry<Long, BTCETradeHistoryResult> entry : tradeHistory.entrySet()) {
            BTCETradeHistoryResult result = entry.getValue();
            Order.OrderType type = result.getType() == BTCETradeHistoryResult.Type.buy ? Order.OrderType.BID : Order.OrderType.ASK;
            String[] pair = result.getPair().split("_");
            String tradableIdentifier = pair[0].toUpperCase();
            String transactionCurrency = pair[1].toUpperCase();
            BigMoney price = BigMoney.of((CurrencyUnit)CurrencyUnit.of((String)transactionCurrency), (BigDecimal)result.getRate());
            BigDecimal tradableAmount = result.getAmount();
            Date timeStamp = new Date(result.getTimestamp());
            trades.add(new Trade(type, tradableAmount, tradableIdentifier, transactionCurrency, price, timeStamp, entry.getKey().longValue()));
        }
        return new Trades(trades);
    }
}

