/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.btce.service.polling;

import com.xeiam.xchange.ExchangeException;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.btce.BTCEAuthenticated;
import com.xeiam.xchange.btce.dto.marketdata.BTCEReturn;
import com.xeiam.xchange.btce.service.BTCEHmacPostBodyDigest;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;

public class BTCEBasePollingService {
    private static final long START_MILLIS = 1356998400000L;
    protected final String apiKey;
    protected final BTCEAuthenticated btce;
    protected final ParamsDigest signatureCreator;
    private int lastNonce = -1;

    public BTCEBasePollingService(ExchangeSpecification exchangeSpecification) {
        this.btce = (BTCEAuthenticated)RestProxyFactory.createProxy(BTCEAuthenticated.class, (String)exchangeSpecification.getSslUri());
        this.apiKey = exchangeSpecification.getApiKey();
        this.signatureCreator = BTCEHmacPostBodyDigest.createInstance(exchangeSpecification.getSecretKey());
    }

    protected synchronized int nextNonce() {
        if (this.lastNonce < 0) {
            this.lastNonce = (int)((System.currentTimeMillis() - 1356998400000L) / 250L);
        }
        int nonce = this.lastNonce++;
        return nonce;
    }

    protected void checkResult(BTCEReturn<?> info) {
        if (!info.isSuccess()) {
            throw new ExchangeException("BTCE returned an error: " + info.getError());
        }
        if (info.getReturnValue() == null) {
            throw new ExchangeException("Didn't recieve any return value. Message: " + info.getError());
        }
        if (info.getError() != null) {
            throw new ExchangeException("Got error message: " + info.getError());
        }
    }
}

