/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange.virtex;

import com.xeiam.xchange.currency.MoneyUtils;
import com.xeiam.xchange.dto.Order;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trade;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.utils.DateUtils;
import com.xeiam.xchange.virtex.dto.marketdata.VirtExTicker;
import com.xeiam.xchange.virtex.dto.marketdata.VirtExTrade;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.joda.money.BigMoney;

public final class VirtExAdapters {
    private VirtExAdapters() {
    }

    public static LimitOrder adaptOrder(BigDecimal amount, BigDecimal price, String currency, String orderTypeString, String id) {
        Order.OrderType orderType = orderTypeString.equalsIgnoreCase("bid") ? Order.OrderType.BID : Order.OrderType.ASK;
        String tradableIdentifier = "BTC";
        BigMoney limitPrice = MoneyUtils.parse((String)(currency + " " + price));
        return new LimitOrder(orderType, amount, tradableIdentifier, currency, limitPrice);
    }

    public static List<LimitOrder> adaptOrders(List<BigDecimal[]> virtexOrders, String currency, String orderType, String id) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (BigDecimal[] virtexOrder : virtexOrders) {
            limitOrders.add(VirtExAdapters.adaptOrder(virtexOrder[1], virtexOrder[0], currency, orderType, id));
        }
        return limitOrders;
    }

    public static Trade adaptTrade(VirtExTrade virtExTrade, String currency, String tradableIdentifier) {
        BigDecimal amount = virtExTrade.getAmount();
        BigMoney price = MoneyUtils.parse((String)(currency + " " + virtExTrade.getPrice()));
        Date date = DateUtils.fromMillisUtc((long)((long)virtExTrade.getDate() * 1000L));
        return new Trade(null, amount, tradableIdentifier, currency, price, date, virtExTrade.getTid());
    }

    public static Trades adaptTrades(VirtExTrade[] virtexTrades, String currency, String tradableIdentifier) {
        ArrayList<Trade> tradesList = new ArrayList<Trade>();
        for (VirtExTrade virtexTrade : virtexTrades) {
            tradesList.add(VirtExAdapters.adaptTrade(virtexTrade, currency, tradableIdentifier));
        }
        return new Trades(tradesList);
    }

    public static String getPriceString(BigMoney price) {
        return price.getAmount().stripTrailingZeros().toPlainString();
    }

    public static Ticker adaptTicker(VirtExTicker virtExTicker, String currency, String tradableIdentifier) {
        BigMoney last = MoneyUtils.parse((String)(currency + " " + virtExTicker.getLast()));
        BigMoney high = MoneyUtils.parse((String)(currency + " " + virtExTicker.getHigh()));
        BigMoney low = MoneyUtils.parse((String)(currency + " " + virtExTicker.getLow()));
        BigDecimal volume = virtExTicker.getVolume();
        return Ticker.TickerBuilder.newInstance().withTradableIdentifier(tradableIdentifier).withLast(last).withHigh(high).withLow(low).withVolume(volume).build();
    }
}

