/*
 * Decompiled with CFR 0.152.
 */
package com.xeiam.xchange;

import com.xeiam.xchange.Exchange;
import com.xeiam.xchange.ExchangeSpecification;
import com.xeiam.xchange.service.polling.PollingAccountService;
import com.xeiam.xchange.service.polling.PollingMarketDataService;
import com.xeiam.xchange.service.polling.PollingTradeService;
import com.xeiam.xchange.service.streaming.ExchangeStreamingConfiguration;
import com.xeiam.xchange.service.streaming.StreamingExchangeService;

public abstract class BaseExchange
implements Exchange {
    protected ExchangeSpecification exchangeSpecification;
    protected PollingMarketDataService pollingMarketDataService;
    protected PollingTradeService pollingTradeService;
    protected PollingAccountService pollingAccountService;
    protected StreamingExchangeService streamingExchangeService;

    @Override
    public void applySpecification(ExchangeSpecification exchangeSpecification) {
        ExchangeSpecification defaultSpecification = this.getDefaultExchangeSpecification();
        if (exchangeSpecification == null) {
            this.exchangeSpecification = defaultSpecification;
        } else {
            if (exchangeSpecification.getExchangeName() == null) {
                exchangeSpecification.setExchangeName(defaultSpecification.getExchangeName());
            }
            if (exchangeSpecification.getExchangeDescription() == null) {
                exchangeSpecification.setExchangeDescription(defaultSpecification.getExchangeDescription());
            }
            if (exchangeSpecification.getSslUri() == null) {
                exchangeSpecification.setSslUri(defaultSpecification.getSslUri());
            }
            if (exchangeSpecification.getHost() == null) {
                exchangeSpecification.setHost(defaultSpecification.getHost());
            }
            this.exchangeSpecification = exchangeSpecification;
        }
    }

    @Override
    public ExchangeSpecification getExchangeSpecification() {
        return this.exchangeSpecification;
    }

    @Override
    public PollingMarketDataService getPollingMarketDataService() {
        return this.pollingMarketDataService;
    }

    @Override
    public PollingTradeService getPollingTradeService() {
        return this.pollingTradeService;
    }

    @Override
    public StreamingExchangeService getStreamingExchangeService() {
        return this.streamingExchangeService;
    }

    @Override
    public PollingAccountService getPollingAccountService() {
        return this.pollingAccountService;
    }

    @Override
    public PollingMarketDataService getPollingMarketDataService(ExchangeStreamingConfiguration configuration) {
        return this.pollingMarketDataService;
    }

    @Override
    public PollingTradeService getPollingTradeService(ExchangeStreamingConfiguration configuration) {
        return this.pollingTradeService;
    }

    @Override
    public StreamingExchangeService getStreamingExchangeService(ExchangeStreamingConfiguration configuration) {
        return this.streamingExchangeService;
    }

    @Override
    public PollingAccountService getPollingAccountService(ExchangeStreamingConfiguration configuration) {
        return this.pollingAccountService;
    }

    void setPollingMarketDataService(PollingMarketDataService marketDataService) {
        this.pollingMarketDataService = marketDataService;
    }

    void setPollingTradeService(PollingTradeService tradeService) {
        this.pollingTradeService = tradeService;
    }

    void setStreamingMarketDataService(StreamingExchangeService streamingExchangeService) {
        this.streamingExchangeService = streamingExchangeService;
    }

    void setPollingAccountService(PollingAccountService pollingAccountService) {
        this.pollingAccountService = pollingAccountService;
    }
}

